/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentOptions;
import oracle.jdeveloper.deploy.ProgressEvent;
import oracle.jdeveloper.deploy.ProgressListener;
import oracle.jdeveloper.deploy.ProgressState;
import oracle.jdeveloper.deploy.Runnable;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdevimpl.deploy.fwk.RunnableImpl;

public abstract class DeployCommand
extends Command
implements Element {
    private static final int START_CALLBACK = 0;
    private static final int EXCEPTION_CALLBACK = 1;
    private static final int FINISHED_CALLBACK = 2;
    private Callback callback_;
    private Status status_ = Status.NOT_READY;
    private DeployCommandState state_;
    private boolean statefulDeployment_ = false;
    private boolean syncDeploy_ = false;
    private static Object callbackLock = new Object();

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator<Element> getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public void setPlatform(Platform platform) {
        this.state().setPlatform(platform);
    }

    public Platform getPlatform() {
        return this.state().getPlatform();
    }

    public void setContext(Context originalContext) {
        Context context = new Context(originalContext);
        ShellAdapter contextAdapter = ShellAdapter.getInstance(context);
        DeploymentOptions options = contextAdapter.getDeploymentOptions();
        Platform platform = contextAdapter.getPlatform();
        if (platform != null) {
            this.setPlatform(platform);
        } else if (this.getPlatform() != null) {
            contextAdapter.setPlatform(this.getPlatform());
        }
        if (options != null) {
            this.setDeploymentOptions(options);
        }
        super.setContext(context);
    }

    public DeployCommand(int cmdId, int type, int sequenceId) {
        super(cmdId, type);
        this.state_ = this.newState();
        this.state_.setDeploySequence(sequenceId);
        this.state_.setCommandId(cmdId);
        this.state_.setCommandType(type);
    }

    public DeployCommand(HashStructure hash) {
        super(DeployCommandState.getCommandId(hash), DeployCommandState.getCommandType(hash));
        this.state_ = this.newState(hash);
    }

    public int getSequenceId() {
        return this.state_.getDeploySequence();
    }

    public void setCallback(Callback callback) {
        this.callback_ = callback;
    }

    public synchronized Status getStatus() {
        this.updateStatus();
        return this.status_;
    }

    protected void updateStatus() {
        if (this.status_ == Status.NOT_READY || this.status_ == Status.READY) {
            if (this.isReady()) {
                this.setStatus(Status.READY);
            } else {
                this.setStatus(Status.NOT_READY);
            }
        }
    }

    protected DeployCommandState newState() {
        Class<? extends DeployCommandState> stateClass = this.getStateClass();
        try {
            return stateClass.newInstance();
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    protected DeployCommandState newState(HashStructure hash) {
        Class<? extends DeployCommandState> stateClass = this.getStateClass();
        try {
            Constructor<? extends DeployCommandState> ctor = stateClass.getConstructor(HashStructure.class);
            return ctor.newInstance(hash);
        }
        catch (NoSuchMethodException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    protected abstract Class<? extends DeployCommandState> getStateClass();

    protected synchronized void setStatus(Status status) {
        this.status_ = status;
    }

    protected abstract boolean isReady();

    public int doit() throws Exception {
        Runnable runner = this.createRunnable();
        if (!this.isSynchronous()) {
            new Thread(runner).start();
            return 0;
        }
        runner.run();
        return runner.getState() != ProgressState.FINISHED_WITH_EXCEPTION ? 0 : 1;
    }

    public Runnable createRunnable() throws DeployException {
        if (this.getStatus() != Status.READY) {
            throw new IllegalStateException("Command not in ready state");
        }
        DeployShellFactory shellFactory = this.getDeployShellFactory();
        assert (this.getContext() != null);
        final DeployShell shell = shellFactory.create(this.getSequenceId(), this.getContext(), null);
        HashStructure commandOptionsHash = this.getDeploymentOptions(DeploymentOptions.class).getHashStructure();
        HashStructure copy = commandOptionsHash.copyTo(HashStructure.newInstance());
        ShellAdapter shellAdapter = ShellAdapter.getInstance(shell);
        HashStructure shellOptionsHash = shellAdapter.getDeploymentOptionsHash();
        if (shellOptionsHash != null) {
            copy = HashStructure.newChainForOverriding((HashStructure[])new HashStructure[]{copy, shellOptionsHash});
        }
        shellAdapter.setDeploymentOptions(copy);
        this.prepare(shell);
        if (this.getPlatform() != null) {
            shellAdapter.setPlatform(this.getPlatform());
        }
        DeploymentProgressShellAdapter dpsa = new DeploymentProgressShellAdapter(shell);
        RunnableImpl runner = dpsa.initRunnableIfNeeded(this.getSequenceId(), shell);
        runner.setIcon(this.getIcon());
        runner.setLongLabel(this.getLongLabel());
        runner.setShortLabel(this.getShortLabel());
        runner.setTooltipText(this.getToolTipText());
        runner.addProgressListener(new ProgressListener(){
            private boolean exception = false;

            @Override
            public void handleEvent(ProgressEvent dpe) {
                if (dpe.getType().equals(ProgressEvent.START_EVENT_TYPE)) {
                    DeployCommand.this.setStatus(Status.DEPLOYING);
                    DeployCommand.this.fireCallbackMethod(0, shell, null);
                }
                if (dpe.getType().equals(ProgressEvent.EXCEPTION_EVENT_TYPE)) {
                    this.exception = true;
                    DeployCommand.this.setStatus(Status.FAILED);
                    Exception e = (Exception)dpe.getData();
                    DeployCommand.this.exception(e, shell);
                    DeployCommand.this.fireCallbackMethod(1, shell, e);
                }
                if (dpe.getType().equals(ProgressEvent.FINISH_EVENT_TYPE)) {
                    if (!this.exception) {
                        DeployCommand.this.setStatus(Status.SUCCESS);
                    }
                    DeployCommand.this.finished(shell);
                    DeployCommand.this.fireCallbackMethod(2, shell, null);
                }
            }
        });
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCallbackMethod(int type, DeployShell shell, Exception e) {
        if (this.callback_ == null) {
            return;
        }
        Object object = callbackLock;
        synchronized (object) {
            switch (type) {
                case 0: {
                    this.callback_.start(shell);
                    break;
                }
                case 1: {
                    this.callback_.exception(e, shell);
                    break;
                }
                case 2: {
                    this.callback_.finished(shell);
                }
            }
        }
    }

    protected void prepare(DeployShell shell) {
        Platform p = this.getPlatform();
        if (p != null) {
            ShellAdapter.getInstance(shell).setPlatform(p);
        }
    }

    protected void deploy(DeployShell shell) throws Exception {
        int sequenceId = this.getSequenceId();
        DeploymentManager.deploy(sequenceId, shell);
    }

    protected void exception(Exception e, DeployShell shell) {
    }

    protected void finished(DeployShell shell) {
    }

    protected DeployShellFactory getDeployShellFactory() {
        return DeployShellFactory.getInstance();
    }

    protected DeployCommandState state() {
        return this.state_;
    }

    public abstract String getShortLabel();

    public DeployCommandState getState() {
        return (DeployCommandState)((Object)this.state().copyTo(null));
    }

    public boolean isSynchronous() {
        return this.syncDeploy_;
    }

    public void setSynchronous(boolean sync) {
        this.syncDeploy_ = sync;
    }

    public void setState(DeployCommandState state) {
        this.state_ = state;
    }

    public <T extends DeploymentOptions> T getDeploymentOptions(Class<T> optionsClass) {
        return this.state().getDeploymentOptions(optionsClass);
    }

    public <T extends DeploymentOptions> void setDeploymentOptions(T options) {
        this.state().setDeploymentOptions(options);
    }

    @Deprecated
    public static DeployCommand create(HashStructure hash) {
        try {
            String className = DeployCommandState.getCommandClassName(hash);
            Class<?> cl = Class.forName(className);
            Constructor<?> ctor = cl.getConstructor(HashStructure.class);
            DeployCommand cmd = (DeployCommand)((Object)ctor.newInstance(hash));
            return cmd;
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (ClassNotFoundException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    private static void commandInstantiationException(Exception e) {
        throw new CommandInstantiationException("Could not read command", e);
    }

    private class DeploymentProgressShellAdapter
    extends ShellAdapter {
        public DeploymentProgressShellAdapter(DeployShell shell) {
            super(shell);
        }

        public RunnableImpl initRunnableIfNeeded(int deploySequence, final DeployShell shell) {
            RunnableImpl runner = (RunnableImpl)this.getRoot().get("Deployment.runnableObject");
            if (runner == null) {
                runner = new RunnableImpl(deploySequence, shell){

                    @Override
                    protected void deploy(DeployShell dsh) throws Exception {
                        try {
                            DeployCommand.this.deploy(dsh);
                        }
                        catch (Exception e) {
                            this.printUnwrappedExceptionMessage(e, shell.getLogger());
                            throw e;
                        }
                    }
                };
                this.getRoot().put("Deployment.runnableObject", runner);
            }
            return runner;
        }
    }

    public static class CommandInstantiationException
    extends RuntimeException {
        CommandInstantiationException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class DefaultCallback
    implements Callback {
        @Override
        public void start(DeployShell shell) {
        }

        @Override
        public void finished(DeployShell shell) {
        }

        @Override
        public void exception(Exception e, DeployShell shell) {
        }
    }

    public static interface Callback {
        public void start(DeployShell var1);

        public void finished(DeployShell var1);

        public void exception(Exception var1, DeployShell var2);
    }

    public static enum Status {
        NOT_READY,
        READY,
        DEPLOYING,
        SUCCESS,
        FAILED;

    }
}

