/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.StateException;

public interface Stateful {
    public void initializeState() throws StateException;

    public void invalidateState() throws StateException;

    public void releaseState() throws StateException;

    public static abstract class State {
        public static final int INITIALIZED = 0;
        public static final int INVALIDATED = 1;
        public static final int RELEASED = 2;
        volatile int current = 2;

        public synchronized void tran(int to) {
            if (this.current == to) {
                return;
            }
            int prev = this.current;
            this.current = to;
            switch (to) {
                case 0: {
                    if (prev == 1) {
                        this.current = prev;
                        throw new IllegalStateException("Invalidate state should be released.");
                    }
                    this.fireInitialized();
                    break;
                }
                case 2: {
                    this.fireReleased();
                    break;
                }
                case 1: {
                    if (prev != 0) {
                        this.current = prev;
                        Assert.printStackTrace((String)"Invalidate called on released state");
                    }
                    this.fireInvalidated();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public boolean isInitialized() {
            return this.current == 0;
        }

        public boolean isInvalidated() {
            return this.current == 1;
        }

        public boolean isReleased() {
            return this.current == 2;
        }

        protected abstract void fireInitialized();

        protected abstract void fireInvalidated();

        protected abstract void fireReleased();
    }
}

