/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardValidateEvent;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bali.share.event.ListenerManager;

public class WizardPage {
    public static final int NOT_ADDED_INDEX = -1;
    private String _label;
    private String _pageTitle;
    private Component _content;
    private boolean _enabled;
    private boolean _visible;
    private Component _initialFocus;
    private boolean _canAdvance;
    private boolean _canGoBack;
    private boolean _visited;
    private boolean _branching;
    private boolean _valid;
    private Vector _validationComponents;
    private BaseWizard _parent;
    private ListenerManager _wizardValidateListeners;
    private PropertyChangeSupport _propertySupport;
    private String _accessibleDescription = "";

    public WizardPage(Component content) {
        this(content, null);
    }

    public WizardPage(Component content, String label) {
        this(content, label, null);
    }

    public WizardPage(Component content, String label, String pageTitle) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this._enabled = true;
        this._visible = true;
        this._label = label;
        this._content = content;
        this._canAdvance = true;
        this._canGoBack = true;
        this._valid = true;
        this._initialFocus = null;
        this._pageTitle = pageTitle;
    }

    public void setVisible(boolean visible) {
        if (visible != this._visible) {
            this._visible = visible;
            this._firePropertyChange("visible", visible);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setContent(Component content) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        Component oldContent = this._content;
        if (oldContent != content) {
            this._content = content;
            this.firePropertyChange("content", oldContent, content);
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setLabel(String label) {
        String oldLabel = this._label;
        if (oldLabel != label) {
            this._label = label;
            this.firePropertyChange("label", oldLabel, label);
        }
    }

    public String getLabel() {
        return this._label;
    }

    public void setEnabled(boolean enabled) {
        if (this._enabled != enabled) {
            this._enabled = enabled;
            this._firePropertyChange("enabled", enabled);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setCanAdvance(boolean advance) {
        if (advance != this.getCanAdvance()) {
            this._canAdvance = advance;
            this._firePropertyChange("canAdvance", advance);
        }
    }

    public boolean getCanAdvance() {
        return this._canAdvance;
    }

    public void setCanGoBack(boolean canGoBack) {
        if (canGoBack != this.getCanGoBack()) {
            this._canGoBack = canGoBack;
            this._firePropertyChange("canGoBack", canGoBack);
        }
    }

    public boolean getCanGoBack() {
        return this._canGoBack;
    }

    public boolean isSelected() {
        BaseWizard parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getSelectedPage() == this;
    }

    public int getIndex() {
        BaseWizard parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        return parent.__getPageIndex(this);
    }

    public BaseWizard getParent() {
        return this._parent;
    }

    public Component getInitialFocus() {
        return this._initialFocus;
    }

    public void setInitialFocus(Component initialFocus) {
        this._initialFocus = initialFocus;
    }

    public String getAccessibleDescription() {
        return this._accessibleDescription;
    }

    public void setAccessibleDescription(String accessibleDescription) {
        String old = this._accessibleDescription;
        this._accessibleDescription = accessibleDescription;
        this.firePropertyChange("accessibleDescription", old, this._accessibleDescription);
    }

    public void setPageTitle(String pageTitle) {
        String oldTitle = this._pageTitle;
        if (oldTitle != pageTitle) {
            this._pageTitle = pageTitle;
            this.firePropertyChange("pageTitle", oldTitle, this._pageTitle);
        }
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setBranching(boolean branching) {
        if (branching != this.isBranching()) {
            this._branching = branching;
            this._firePropertyChange("branching", this._branching);
        }
    }

    public boolean isBranching() {
        return this._branching;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setValid(boolean valid) {
        if (valid != this._valid) {
            this._valid = valid;
            this._firePropertyChange("valid", this._valid);
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public void reset() {
        this.__setVisited(false);
        this.setValid(true);
    }

    public void addValidationComponent(ValidationComponent comp) {
        if (comp != null) {
            if (this._validationComponents == null) {
                this._validationComponents = new Vector();
            }
            if (!this._validationComponents.contains(comp)) {
                this._validationComponents.add(comp);
            }
        }
    }

    public void removeValidationComponent(ValidationComponent comp) {
        if (this._validationComponents != null) {
            this._validationComponents.remove(comp);
        }
    }

    public void removeAllValidationComponents() {
        if (this._validationComponents != null) {
            this._validationComponents.removeAllElements();
        }
    }

    public ValidationComponent[] getValidationComponents() {
        if (this._validationComponents != null) {
            return this._validationComponents.toArray(new ValidationComponent[0]);
        }
        return new ValidationComponent[0];
    }

    public synchronized void addWizardValidateListener(WizardValidateListener listener) {
        if (this._wizardValidateListeners == null) {
            this._wizardValidateListeners = new ListenerManager();
        }
        this._wizardValidateListeners.addListener((EventListener)listener);
    }

    public synchronized void removeWizardValidateListener(WizardValidateListener listener) {
        if (this._wizardValidateListeners != null) {
            this._wizardValidateListeners.removeListener((EventListener)listener);
        }
    }

    public String toString() {
        String str = this.getClass().getName();
        str = str + ",pageTitle=" + this.getPageTitle();
        str = str + ",label=" + this.getLabel();
        if (!this.isEnabled()) {
            str = str + ",disabled";
        }
        if (!this.isVisible()) {
            str = str + ",hidden";
        }
        if (this.isSelected()) {
            str = str + ",selected";
        }
        if (this.isVisited()) {
            str = str + ",visited";
        }
        return str;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected boolean validatePage() {
        WizardValidateEvent event = new WizardValidateEvent(this, 2000, this);
        this.processWizardValidateEvent(event);
        return !event.isCancelled();
    }

    protected void processWizardValidateEvent(WizardValidateEvent event) {
        Enumeration enumer;
        int id = event.getID();
        ListenerManager listeners = this._wizardValidateListeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                WizardValidateListener listener = (WizardValidateListener)enumer.nextElement();
                listener.wizardValidatePage(event);
            }
        }
    }

    void __setParent(BaseWizard parent) {
        this._parent = parent;
        this._visited = false;
    }

    void __setVisited(boolean visited) {
        this._visited = visited;
    }

    private void _firePropertyChange(String propertyName, boolean newValue) {
        this.firePropertyChange(propertyName, newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }
}

