/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JComponent;
import oracle.bali.ewt.validate.DefaultValidationMessageModel;
import oracle.bali.ewt.validate.DefaultValidationPainter;
import oracle.bali.ewt.validate.NullValidationPainter;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.bali.ewt.validate.Validator;
import oracle.bali.share.event.ListenerManager;

public abstract class AbstractValidationComponent
implements ValidationComponent {
    private Component _component;
    private ValidationMessageModel _model;
    private ValidationPainter _painter;
    private HashMap _validatorMap;
    private HashMap _msgMap;
    private PropertyChangeSupport _propertySupport;
    private ListenerManager _listenerManager;
    private Listener _listener;

    public AbstractValidationComponent(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        this._component = comp;
        this._validatorMap = new HashMap(1);
        this._msgMap = new HashMap(1);
        this._listener = new Listener();
        this.setValidationMessageModel(new DefaultValidationMessageModel());
        if (comp instanceof JComponent) {
            this.setValidationPainter(DefaultValidationPainter.getValidationPainter());
        } else {
            this.setValidationPainter(NullValidationPainter.getValidationPainter());
        }
    }

    @Override
    public Component getComponent() {
        return this._component;
    }

    @Override
    public void addValidator(Object key, Validator validator) {
        ArrayList<Validator> list = (ArrayList<Validator>)this._validatorMap.get(key);
        if (list == null) {
            list = new ArrayList<Validator>(2);
            this._validatorMap.put(key, list);
        }
        if (!list.contains(validator)) {
            list.add(validator);
        }
    }

    @Override
    public void removeValidator(Object key, Validator validator) {
        ArrayList list = (ArrayList)this._validatorMap.get(key);
        if (list != null) {
            list.remove(validator);
        }
    }

    @Override
    public Validator[] getValidators(Object key) {
        ArrayList list = (ArrayList)this._validatorMap.get(key);
        if (list != null) {
            return list.toArray(new Validator[0]);
        }
        return null;
    }

    @Override
    public void setValidationMessageModel(ValidationMessageModel model) {
        if (this._model != model) {
            ValidationMessageModel oldModel = this._model;
            if (oldModel != null) {
                oldModel.removeValidationMessageListener(this._listener);
            }
            if (model == null) {
                model = new DefaultValidationMessageModel();
            }
            this._model = model;
            this._model.addValidationMessageListener(this._listener);
            this.firePropertyChange("validationModel", oldModel, this._model);
        }
    }

    @Override
    public ValidationMessageModel getValidationMessageModel() {
        return this._model;
    }

    @Override
    public void setValidationPainter(ValidationPainter painter) {
        if (painter == null) {
            painter = NullValidationPainter.getValidationPainter();
        }
        this._painter = painter;
    }

    @Override
    public ValidationPainter getValidationPainter() {
        return this._painter;
    }

    @Override
    public void validateComponent(Object key) {
        Validator[] validators = this.getValidators(key);
        if (validators == null || validators.length == 0) {
            return;
        }
        ValidationMessageModel model = this.getValidationMessageModel();
        Component comp = this.getComponent();
        Object data = this.getData();
        ValidationMessageModel dummy = (ValidationMessageModel)this._msgMap.get(key);
        if (dummy != null) {
            model.removeValidationMessages(dummy.getValidationMessages());
            dummy.clear();
        } else {
            dummy = new DefaultValidationMessageModel();
            this._msgMap.put(key, dummy);
        }
        for (int i = 0; i < validators.length; ++i) {
            ValidationMessage[] msg = validators[i].validate(comp, data);
            if (msg == null) continue;
            model.addValidationMessages(msg);
            dummy.addValidationMessages(msg);
        }
    }

    @Override
    public boolean isValid() {
        return this.getValidationMessageModel().isEmpty();
    }

    @Override
    public synchronized void addValidationMessageModelListener(ValidationMessageModelListener listener) {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        this._listenerManager.addListener((EventListener)listener);
    }

    @Override
    public synchronized void removeValidationMessageModelListener(ValidationMessageModelListener listener) {
        if (this._listenerManager != null) {
            this._listenerManager.removeListener((EventListener)listener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    public void paintValidationComponent() {
        this.getValidationPainter().paintComponent(this);
    }

    protected void fireValidationMessageEvent(int eventID, ValidationMessage message) {
        if (this._listenerManager != null) {
            Enumeration enumer = this._listenerManager.getListeners();
            if (enumer == null || !enumer.hasMoreElements()) {
                return;
            }
            ValidationMessageModelEvent event = new ValidationMessageModelEvent(this, eventID, message);
            switch (eventID) {
                case 2001: {
                    while (enumer.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumer.nextElement()).messageAdded(event);
                    }
                    break;
                }
                case 2002: {
                    while (enumer.hasMoreElements()) {
                        ((ValidationMessageModelListener)enumer.nextElement()).messageRemoved(event);
                    }
                    break;
                }
            }
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private class Listener
    implements ValidationMessageModelListener {
        private Listener() {
        }

        @Override
        public void messageAdded(ValidationMessageModelEvent event) {
            AbstractValidationComponent.this.paintValidationComponent();
            AbstractValidationComponent.this.fireValidationMessageEvent(event.getID(), event.getMessage());
        }

        @Override
        public void messageRemoved(ValidationMessageModelEvent event) {
            AbstractValidationComponent.this.paintValidationComponent();
            AbstractValidationComponent.this.fireValidationMessageEvent(event.getID(), event.getMessage());
        }
    }
}

