/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.ruler;

import oracle.bali.ewt.ruler.Tick;

public class RulerStyle {
    private static RulerStyle _sInches;
    private static RulerStyle _sMM;
    private double _pixelsPerTick;
    private Tick[] _ticks;

    public RulerStyle(Tick[] ticks, double pixelsPerTick) {
        if (ticks == null) {
            throw new NullPointerException("ticks must be non-null");
        }
        this._pixelsPerTick = pixelsPerTick;
        this._ticks = new Tick[ticks.length];
        System.arraycopy(ticks, 0, this._ticks, 0, ticks.length);
    }

    public static RulerStyle getInches() {
        if (_sInches == null) {
            Tick[] ticks = new Tick[]{new Tick(80, 128), new Tick(60, 64), new Tick(40, 32), new Tick(30, 16), new Tick(20, 8)};
            _sInches = new RulerStyle(ticks, 80.0);
        }
        return _sInches;
    }

    public static RulerStyle getMillimeters() {
        if (_sMM == null) {
            Tick[] ticks = new Tick[]{new Tick(75, 100), new Tick(50, 50), new Tick(25, 10)};
            _sMM = new RulerStyle(ticks, 31.496062992125985);
        }
        return _sMM;
    }

    public int getTickCount() {
        return this._ticks.length;
    }

    public double getPixelsPerTick() {
        return this._pixelsPerTick;
    }

    public Tick getTick(int index) {
        if (index < 0 || index >= this.getTickCount()) {
            throw new IllegalArgumentException("index is invalid.");
        }
        return this._ticks[index];
    }
}

