/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;

public class PivotHeaderGridSelectionManager
extends GeneralGridSelectionManager {
    private Grid _grid;
    private boolean _isHorizontal;
    private int _cellConstraint;

    public PivotHeaderGridSelectionManager(Grid grid, boolean isHorizontal) {
        this(grid, 1, 1, isHorizontal);
    }

    public PivotHeaderGridSelectionManager(Grid grid, int cellConstraint, int levelConstraint, boolean isHorizontal) {
        super(isHorizontal ? 0 : levelConstraint, isHorizontal ? levelConstraint : 0, cellConstraint);
        this._isHorizontal = isHorizontal;
        this._cellConstraint = cellConstraint;
        this._grid = grid;
    }

    public Grid getGrid() {
        return this._grid;
    }

    @Override
    public TwoDSelection getRepaintSelection(TwoDSelection oldSelection, TwoDSelection newSelection) {
        TwoDSelection result = super.getRepaintSelection(oldSelection, newSelection);
        if (!result.getRowSelection().isEmpty() || !result.getColumnSelection().isEmpty()) {
            Grid grid = this.getGrid();
            int col1 = grid.getNextVisibleColumn(-1);
            int col2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
            int row1 = grid.getNextVisibleRow(-1);
            int row2 = grid.getPreviousVisibleRow(grid.getRowCount());
            result = new TwoDSelection(null, null, col1, row1, col2, row2);
        }
        return result;
    }

    @Override
    protected TwoDSelection constrain(TwoDSelection sel) {
        CellRange result;
        CellRange[] cellRanges;
        if (this._cellConstraint == 1 && (cellRanges = sel.getCellRanges()) != null && cellRanges.length > 0 && (result = this._getSingleCellRange(cellRanges)) != null) {
            sel = new TwoDSelection(sel.getColumnSelection(), sel.getRowSelection(), result);
        }
        sel = super.constrain(sel);
        return new TwoDSelection(sel.getColumnSelection(), sel.getRowSelection(), this._constrainBigCellRange(sel.getCellRanges(), true));
    }

    @Override
    protected boolean meetsConstraints(TwoDSelection sel) {
        sel = new TwoDSelection(sel.getColumnSelection(), sel.getRowSelection(), this._constrainBigCellRange(sel.getCellRanges(), false));
        return super.meetsConstraints(sel);
    }

    private CellRange _getSingleCellRange(CellRange[] cellRanges) {
        Grid grid = this.getGrid();
        Cell minCell = null;
        for (int i = 0; i < cellRanges.length; ++i) {
            int row;
            AbstractBigCell bigCell;
            Cell lower = cellRanges[i].getLowerLimit();
            if (minCell == null) {
                minCell = lower;
            } else if (this._isHorizontal) {
                if (lower.row < minCell.row || lower.row == minCell.row && lower.column < minCell.column) {
                    minCell = lower;
                }
            } else if (lower.column < minCell.column || lower.column == minCell.column && lower.row < minCell.row) {
                minCell = lower;
            }
            if (minCell == null || (bigCell = AbstractBigCell.getBigCell(grid, minCell.column, minCell.row)) == null) continue;
            int col = bigCell.getColumn();
            if (CellRange.cellRangesContain(cellRanges, col, row = bigCell.getRow())) {
                minCell.column = col;
                minCell.row = row;
                continue;
            }
            minCell = null;
        }
        if (minCell == null) {
            minCell = cellRanges[0].getLowerLimit();
            AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, minCell.column, minCell.row);
            if (bigCell != null) {
                minCell.column = bigCell.getColumn();
                minCell.row = bigCell.getRow();
            }
        }
        if (minCell != null) {
            return new CellRange(minCell);
        }
        return null;
    }

    private CellRange[] _constrainBigCellRange(CellRange[] cellRanges, boolean add) {
        if (cellRanges != null && cellRanges.length > 0) {
            CellRange[] result = null;
            Grid grid = this.getGrid();
            for (int i = 0; i < cellRanges.length; ++i) {
                Cell lower = cellRanges[i].getLowerLimit();
                Cell upper = cellRanges[i].getUpperLimit();
                for (int j = lower.column; j <= upper.column; ++j) {
                    for (int k = lower.row; k <= upper.row; ++k) {
                        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, j, k);
                        if (bigCell != null) {
                            int row;
                            int col = bigCell.getColumn();
                            if (!CellRange.cellRangesContain(cellRanges, col, row = bigCell.getRow())) continue;
                            CellRange[] temp = new CellRange[]{add ? new CellRange(col, row, col + bigCell.getColumnCount() - 1, row + bigCell.getRowCount() - 1) : new CellRange(col, row)};
                            result = CellRange.addCellRanges(result, temp);
                            continue;
                        }
                        CellRange[] temp = new CellRange[]{new CellRange(j, k)};
                        result = CellRange.addCellRanges(result, temp);
                    }
                }
            }
            cellRanges = result;
        }
        return cellRanges;
    }
}

