/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotValidateEvent;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;

final class PivotGridTabAdapt
implements TableEditListener,
TableResizeListener {
    private PivotTable _pivot;

    public PivotGridTabAdapt(PivotTable pivotTable) {
        this._pivot = pivotTable;
    }

    public void dispose() {
        this._pivot = null;
    }

    @Override
    public void cellEditing(TableEvent e) {
        PivotValidateEvent event = new PivotValidateEvent(this._pivot, 2005, e.getColumn(), e.getRow());
        this._pivot.postEvent(event);
        if (event.isCancelled()) {
            ((Cancelable)((Object)e)).cancel();
        }
    }

    @Override
    public void cellEdited(TableEvent e) {
        this._pivot.postEvent(new TableEvent(this._pivot, 2006, e.getColumn(), e.getRow()));
    }

    @Override
    public void columnResizing(TableEvent e) {
        PivotValidateEvent event = new PivotValidateEvent(this._pivot, 2001, e.getColumn(), -1);
        this._pivot.postEvent(event);
        if (event.isCancelled()) {
            ((Cancelable)((Object)e)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    @Override
    public void columnResized(TableEvent e) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable table = (SpreadTable)e.getSource();
        int index = e.getColumn();
        int width = table.getColumnWidth(index);
        if (this._pivot.getEqualSizedColumns()) {
            this._pivot.tryDefaultColumns();
            table.setColumnWidth(index, -1);
            PivotHeader h = this._pivot.getColumnPivotHeader();
            h.setColumnWidth(index, -1);
            this._pivot.setDefaultColumnWidth(width);
        } else {
            this._pivot.setColumnWidth(index, width);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2002, index, -1));
    }

    @Override
    public void rowResizing(TableEvent e) {
        PivotValidateEvent event = new PivotValidateEvent(this._pivot, 2003, -1, e.getRow());
        this._pivot.postEvent(event);
        if (event.isCancelled()) {
            ((Cancelable)((Object)e)).cancel();
        } else {
            this._pivot.getPivotGrid().setCurrentlyResizing(true);
        }
    }

    @Override
    public void rowResized(TableEvent e) {
        this._pivot.getPivotGrid().setCurrentlyResizing(false);
        SpreadTable table = (SpreadTable)e.getSource();
        int index = e.getRow();
        int height = table.getRowHeight(index);
        if (this._pivot.getEqualSizedRows()) {
            this._pivot.tryDefaultRows();
            table.setRowHeight(index, -1);
            PivotHeader h = this._pivot.getRowPivotHeader();
            h.setRowHeight(index, -1);
            this._pivot.setDefaultRowHeight(height);
        } else {
            this._pivot.setRowHeight(index, height);
        }
        this._pivot.postEvent(new TableEvent(this._pivot, 2004, -1, index));
    }
}

