/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PainterTiler
extends AbstractWrappingPainter {
    private int _preferredWidthTiles;
    private int _preferredHeightTiles;

    public PainterTiler(Painter tilee) {
        this(tilee, 1, 1);
    }

    public PainterTiler(Painter tilee, int preferredWidthTiles, int preferredHeightTiles) {
        super(tilee);
        this._preferredWidthTiles = preferredWidthTiles;
        this._preferredHeightTiles = preferredHeightTiles;
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        Dimension preferredTileSize = super.getPreferredSize(context);
        preferredTileSize.width *= this._preferredWidthTiles;
        preferredTileSize.height *= this._preferredHeightTiles;
        return preferredTileSize;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Painter tilee = this.getWrappedPainter(context);
        Dimension tileSize = tilee.getPreferredSize(context);
        int tileWidth = tileSize.width;
        int tileHeight = tileSize.height;
        Rectangle clipRect = g.getClipBounds();
        int initialX = clipRect.x / tileWidth * tileWidth;
        int initialY = clipRect.y / tileHeight * tileHeight;
        int lastX = clipRect.x + clipRect.width;
        int lastY = clipRect.y + clipRect.height;
        if (initialX < x) {
            initialX = x;
        }
        if (initialY < y) {
            initialY = y;
        }
        if (lastX > x + width) {
            lastX = x + width;
        }
        if (lastY > y + height) {
            lastY = y + height;
        }
        Shape savedClip = g.getClip();
        g.clipRect(initialX, initialY, lastX - initialX, lastY - initialY);
        for (int currY = initialY; currY < lastY; currY += tileHeight) {
            for (int currX = initialX; currX < lastX; currX += tileWidth) {
                tilee.paint(context, g, currX, currY, tileWidth, tileHeight);
            }
        }
        g.setClip(savedClip);
    }

    @Override
    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        if (x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            Painter tilee = this.getWrappedPainter(context);
            Dimension tileSize = tilee.getPreferredSize(context);
            return super.getPainterAt(context, tileSize.width, tileSize.height, x % tileSize.width, y % tileSize.height, proxyPainter);
        }
        return null;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x80;
    }
}

