/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleSeparatorPainter
extends AbstractPainter {
    private boolean _horizontal;
    private static Painter _sHorizInstance;
    private static Painter _sVertInstance;

    public static Painter getPainter(boolean horizontal) {
        if (horizontal) {
            if (_sHorizInstance == null) {
                _sHorizInstance = new OracleSeparatorPainter(true);
            }
            return _sHorizInstance;
        }
        if (_sVertInstance == null) {
            _sVertInstance = new OracleSeparatorPainter(false);
        }
        return _sVertInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("HorizInsetSeparatorPainter".equals(key) || "HorizOutsetSeparatorPainter".equals(key)) {
            return OracleSeparatorPainter.getPainter(true);
        }
        if ("VertInsetSeparatorPainter".equals(key) || "VertOutsetSeparatorPainter".equals(key)) {
            return OracleSeparatorPainter.getPainter(false);
        }
        return null;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int y2;
        int x2;
        if (this._horizontal) {
            x2 = x + width - 1;
            y2 = y += (height - 1) / 2;
        } else {
            x2 = x += (width - 1) / 2;
            y2 = y + height - 1;
        }
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        g.setColor(defaults.getColor("controlShadowDark"));
        g.drawLine(x, y, x2, y2);
        g.setColor(savedColor);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        if (this._horizontal) {
            return new Dimension(0, 1);
        }
        return new Dimension(1, 0);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    private OracleSeparatorPainter(boolean horizontal) {
        this._horizontal = horizontal;
    }
}

