/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class OracleRaisedBorderPainter
extends AbstractBorderPainter {
    private static OracleRaisedBorderPainter _sPainter;
    private static final ImmInsets[] _sInsetsArr;

    public static BorderPainter getPainter() {
        if (_sPainter == null) {
            _sPainter = new OracleRaisedBorderPainter();
        }
        return _sPainter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        int insetsIndex = 0;
        if (this._getVScrollBarWidth(context) > 0) {
            insetsIndex += 2;
        }
        if (this._getHScrollBarHeight(context) > 0) {
            ++insetsIndex;
        }
        return _sInsetsArr[insetsIndex];
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        g.setColor(context.getPaintBackground());
        g.drawLine(x + 3, y + 1, right - 4, y + 1);
        g.drawLine(x + 1, y + 3, x + 1, bottom - 3);
        g.setColor(defaults.getColor(LookAndFeel.CONTROL_SHADOW));
        g.drawLine(x + 3, y, right - 4, y);
        g.drawLine(x, y + 3, x, bottom - 3);
        g.drawLine(x + 2, bottom - 1, right - 4, bottom - 1);
        g.drawLine(right - 1, y + 3, right - 1, bottom - 3);
        g.drawLine(x + 1, y + 1, x + 2, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 2);
        g.drawLine(x + 1, bottom - 2, x + 1, bottom - 1);
        g.drawLine(x + 1, bottom - 1, x + 2, bottom - 1);
        g.drawLine(right - 3, bottom - 2, right - 2, bottom - 2);
        g.drawLine(right - 2, bottom - 2, right - 2, bottom - 3);
        g.drawLine(right - 3, y + 1, right - 2, y + 1);
        g.drawLine(right - 2, y + 2, right - 2, y + 1);
        g.setColor(defaults.getColor(LookAndFeel.CONTROL_TEXT));
        g.drawLine(x + 4, bottom, right - 4, bottom);
        g.drawLine(right, y + 5, right, bottom - 4);
        g.drawLine(right - 3, bottom - 1, right - 2, bottom - 1);
        g.drawLine(right - 1, bottom - 2, right - 1, bottom - 3);
        g.setColor(defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW));
        g.drawLine(right - 3, bottom, right - 3, bottom);
        g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
        g.drawLine(right, bottom - 3, right, bottom - 3);
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private OracleRaisedBorderPainter() {
    }

    private int _getHScrollBarHeight(PaintContext context) {
        Object data = context.getPaintData("HorizontalScrollBarHeight");
        return data == null ? 0 : (Integer)data;
    }

    private int _getVScrollBarWidth(PaintContext context) {
        Object data = context.getPaintData("VerticalScrollBarWidth");
        return data == null ? 0 : (Integer)data;
    }

    static {
        _sInsetsArr = new ImmInsets[]{new ImmInsets(2, 2, 2, 2), new ImmInsets(2, 2, 1, 2), new ImmInsets(2, 2, 2, 1), new ImmInsets(2, 2, 1, 1)};
    }
}

