/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.image.ImageFilter;
import java.util.Locale;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.ColorizingFilter;

public class ColorScheme {
    public static final Object CONTROL_INACTIVE_TEXT = LookAndFeel.CONTROL_INACTIVE_TEXT;
    public static final Object LIGHT_INTENSITY = LookAndFeel.LIGHT_INTENSITY;
    public static final Object NORMAL_INTENSITY = LookAndFeel.NORMAL_INTENSITY;
    public static final Object DARK_INTENSITY = LookAndFeel.DARK_INTENSITY;
    public static final Object VERY_DARK_INTENSITY = LookAndFeel.VERY_DARK_INTENSITY;
    public static final Object CONTROL_SHADOW_DARK = "controlShadowDark";
    public static final Object CONTROL_SHADOW_DARK_LIGHT = "controlShadowDarkLight";
    public static final Object CONTROL_SHADOW_VERY_LIGHT = "controlShadowVeryLight";
    public static final Object SECONDARY_TEXT_HIGHLIGHT = LookAndFeel.SECONDARY_TEXT_HIGHLIGHT;
    public static final Object TEXT_HIGHLIGHT_TEXT = LookAndFeel.TEXT_HIGHLIGHT_TEXT;
    public static final Object TEXT_INACTIVE_TEXT = LookAndFeel.TEXT_INACTIVE_TEXT;
    public static final Object TEXT_TEXT = LookAndFeel.TEXT_TEXT;
    public static final Object LIGHT_LOOK = LookAndFeel.LIGHT_LOOK;
    public static final Object DARK_LOOK = LookAndFeel.DARK_LOOK;
    public static final Object VERY_DARK_LOOK = LookAndFeel.VERY_DARK_LOOK;
    private static final int _DEFINING_INDEX = 2;
    private static final Color _sBlack;
    static Color __sControlText;
    private static final int _NUM_COLORS = 9;
    private String _name;
    private String _description;
    private int[] _intRamp;
    private Color[] _colorRamp;
    private int[] _mappingTable;
    private int _schemeIndex;
    private boolean _isDerived;

    ColorScheme(String name, String description, Color hsColor, Color textHighlight, boolean useGray, int schemeIndex) {
        int hsRed = hsColor.getRed();
        int hsGreen = hsColor.getGreen();
        int hsBlue = hsColor.getBlue();
        float[] hsb = Color.RGBtoHSB(hsRed, hsGreen, hsBlue, null);
        float hue = hsb[0];
        float saturation = hsb[1];
        float currBrightness = 0.8f;
        int currHexBrightness = -872415232;
        int[] colors = new int[9];
        colors[0] = -1;
        colors[5] = 0;
        for (int i = 1; i < 5; ++i) {
            int currRGB = Color.HSBtoRGB(hue, saturation, currBrightness);
            colors[i] = (currRGB &= 0xFFFFFF) & 0xFFFFFF | currHexBrightness;
            currBrightness -= 0.2f;
            currHexBrightness -= 0x33000000;
        }
        if (useGray) {
            colors[1] = -858993460;
        }
        colors[6] = textHighlight.getRGB();
        if (hsRed == hsGreen && hsGreen == hsBlue) {
            colors[7] = 14678255;
            colors[8] = 11726551;
        } else {
            colors[7] = (hsGreen << 15) + 0x800000 | (hsBlue << 7) + 32768 | (hsRed >> 1) + 128;
            colors[8] = (hsBlue << 15) + 0x800000 | (hsRed << 7) + 32768 | (hsGreen >> 1) + 128;
        }
        this._init(name, description, colors, schemeIndex);
        this._isDerived = true;
    }

    ColorScheme(String name, String description, int[] intRamp, int schemeIndex) {
        this._init(name, description, intRamp, schemeIndex);
        this._isDerived = false;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String getDescription(Locale locale) {
        return this._description;
    }

    public Color getDefiningColor() {
        return this._getColorRamp()[2];
    }

    public ImageFilter createColorizingFilter() {
        return new ColorizingFilter(this.getColorMappingTable());
    }

    int _getSchemeIndex() {
        return this._schemeIndex;
    }

    boolean _isDerived() {
        return this._isDerived;
    }

    void _installCommonColors(UIDefaults defaults) {
        Object[] indexedSystemColors = new Object[]{"activeCaption", "#4", "activeCaptionText", "#0", "inactiveCaption", "#2", "inactiveCaptionText", "#1", "menu", "#1", "control", "#1", "scrollbar", "#2", "text", "#0", "textText", "#5", "textInactiveText", "#3", "textHighlightText", "#0", "infoText", "#5", SECONDARY_TEXT_HIGHLIGHT, "#6", LIGHT_INTENSITY, "#1", NORMAL_INTENSITY, "#2", DARK_INTENSITY, "#3", VERY_DARK_INTENSITY, "#4", LIGHT_LOOK, "#1", DARK_LOOK, "#3", VERY_DARK_LOOK, "#4"};
        this._initializeColors(defaults, indexedSystemColors);
    }

    void _installLightColors(UIDefaults defaults) {
        Object[] indexedSystemColors = new Object[]{"window", "#1", "controlText", "#5", "controlHighlight", "#1", "controlLtHighlight", "#0", "controlShadow", "#2", "controlDkShadow", "#3", CONTROL_INACTIVE_TEXT, "#3", CONTROL_SHADOW_DARK, "#2", CONTROL_SHADOW_VERY_LIGHT, "#2", CONTROL_SHADOW_DARK_LIGHT, "#3"};
        this._initializeColors(defaults, indexedSystemColors);
        __sControlText = defaults.getColor("controlText");
    }

    void _installDarkColors(UIDefaults defaults) {
        Object[] indexedSystemColors = new Object[]{"window", "#3", "controlText", "#0", "controlHighlight", "#2", "controlLtHighlight", "#1", "controlShadow", "#3", "controlDkShadow", "#4", CONTROL_INACTIVE_TEXT, "#4", CONTROL_SHADOW_DARK, "#4", CONTROL_SHADOW_VERY_LIGHT, "#0", CONTROL_SHADOW_DARK_LIGHT, "#2"};
        this._initializeColors(defaults, indexedSystemColors);
    }

    private void _initializeColors(UIDefaults defaults, Object[] indexedSystemColors) {
        Color[] colorRamp = this._getColorRamp();
        for (int i = 0; i < indexedSystemColors.length; i += 2) {
            Color color = _sBlack;
            try {
                color = colorRamp[Integer.decode((String)indexedSystemColors[i + 1])];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            defaults.put(indexedSystemColors[i], color);
        }
    }

    int[] getColorMappingTable() {
        if (this._mappingTable == null) {
            int[] mappingTable = new int[256];
            int[] intRamp = this._intRamp;
            int currRampIndex = 0;
            int currRampMatch = intRamp[0] >> 24 & 0xFF;
            for (int i = 255; i >= 0; --i) {
                if (i == currRampMatch) {
                    mappingTable[i] = intRamp[currRampIndex] | 0xFF000000;
                    currRampMatch = intRamp[++currRampIndex] >> 24 & 0xFF;
                    continue;
                }
                mappingTable[i] = 0xFF000000 | (i << 16 | i << 8 | i);
            }
            this._mappingTable = mappingTable;
        }
        return this._mappingTable;
    }

    private Color[] _getColorRamp() {
        if (this._colorRamp == null) {
            int[] intRamp = this._intRamp;
            int rampSize = intRamp.length;
            Color[] colorRamp = new Color[rampSize];
            for (int i = 0; i < rampSize; ++i) {
                colorRamp[i] = new ColorUIResource(intRamp[i] | 0xFF000000);
            }
            this._colorRamp = colorRamp;
        }
        return this._colorRamp;
    }

    private void _remapColors(UIDefaults defaults, Object[] indexedSystemColors) {
        Color[] colorRamp = this._getColorRamp();
        for (int i = 0; i < indexedSystemColors.length; i += 2) {
            Color color = _sBlack;
            try {
                color = colorRamp[Integer.decode((String)indexedSystemColors[i + 1])];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            defaults.put(indexedSystemColors[i], color);
        }
    }

    private void _init(String name, String description, int[] intRamp, int schemeIndex) {
        this._name = name;
        this._description = description;
        this._intRamp = intRamp;
        this._schemeIndex = schemeIndex;
    }

    void __setIntRamp(int[] ramp) {
        this._intRamp = ramp;
    }

    static {
        __sControlText = _sBlack = new ColorUIResource(Color.black);
    }
}

