/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.SwingConstants;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.share.collection.StringKey;

class AlignedPainterJoiner
extends PainterJoiner
implements SwingConstants {
    public static final Object HORIZONTAL_TEXT_POSITION = new StringKey("HorizTextPos");
    public static final Object VERTICAL_TEXT_POSITION = new StringKey("VerticalTextPos");
    private static final int _MAIN_INDEX = 0;
    private static final int _SECOND_INDEX = 1;
    private Painter _main;
    private Painter _second;

    public AlignedPainterJoiner(Painter first, Painter second) {
        super(first, second);
        this._main = first;
        this._second = second;
    }

    @Override
    protected int getActualAlignment(PaintContext context) {
        Object vert;
        Object horiz = context.getPaintData(HORIZONTAL_TEXT_POSITION);
        if (horiz != null && horiz instanceof Integer && (vert = context.getPaintData(VERTICAL_TEXT_POSITION)) != null && vert instanceof Integer) {
            int alignment = 0;
            int horizPosition = (Integer)horiz;
            switch (OracleUIUtils.getActualHorizontalAlignment(context, horizPosition)) {
                case 4: {
                    alignment = 6;
                    break;
                }
                case 0: {
                    alignment = 3;
                    break;
                }
            }
            switch ((Integer)vert) {
                case 0: {
                    ++alignment;
                    break;
                }
                case 3: {
                    alignment += 2;
                    break;
                }
            }
            return alignment;
        }
        return super.getActualAlignment(context);
    }

    @Override
    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Rectangle[] positions = this._getPainterBounds(context, 0, 0, availableWidth, availableHeight);
        return this._getCombinedSize(context, new Dimension(positions[0].width, positions[0].height), new Dimension(positions[1].width, positions[1].height), true);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getPreferredSize(context), this._second.getPreferredSize(context), true);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getMinimumSize(context), this._second.getMinimumSize(context), true);
    }

    @Override
    public Dimension getMaximumSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getMaximumSize(context), this._second.getMaximumSize(context), false);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Rectangle[] positions = this._getPainterBounds(context, x, y, width, height);
        Rectangle mainPosition = positions[0];
        if (mainPosition.width > 0 && mainPosition.height > 0) {
            this._main.paint(context, g, mainPosition.x, mainPosition.y, mainPosition.width, mainPosition.height);
        }
        Rectangle secondPosition = positions[1];
        if (secondPosition.width > 0 && secondPosition.height > 0) {
            this._second.paint(context, g, secondPosition.x, secondPosition.y, secondPosition.width, secondPosition.height);
        }
    }

    @Override
    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Rectangle[] positions = this._getPainterBounds(context, 0, 0, availableWidth, availableHeight);
        Rectangle secondPosition = positions[1];
        Painter containedPainter = this._second.getPainterAt(context, secondPosition.width, secondPosition.height, x - secondPosition.x, y - secondPosition.y, proxyPainter);
        if (containedPainter == null) {
            Rectangle mainPosition = positions[0];
            containedPainter = this._main.getPainterAt(context, mainPosition.width, mainPosition.height, x - mainPosition.x, y - mainPosition.y, proxyPainter);
        }
        if (proxyPainter == this && containedPainter != null) {
            containedPainter = this;
        }
        return containedPainter;
    }

    private Dimension _getCombinedSize(PaintContext context, Dimension mainSize, Dimension secondSize, boolean useMaximum) {
        int align = this.getActualAlignment(context);
        if (align / 3 != 1 || align % 3 == 1) {
            if (useMaximum) {
                if (secondSize.height > mainSize.height) {
                    mainSize.height = secondSize.height;
                }
            } else if (secondSize.height < mainSize.height) {
                mainSize.height = secondSize.height;
            }
        } else {
            mainSize.height += secondSize.height;
        }
        if (align / 3 == 1) {
            if (useMaximum) {
                if (secondSize.width > mainSize.width) {
                    mainSize.width = secondSize.width;
                }
            } else if (secondSize.width < mainSize.width) {
                mainSize.width = secondSize.width;
            }
        } else {
            mainSize.width += secondSize.width;
        }
        return mainSize;
    }

    private Rectangle[] _getPainterBounds(PaintContext context, int x, int y, int width, int height) {
        Rectangle[] positions = new Rectangle[2];
        Dimension mainSize = this._main.getPreferredSize(context);
        Dimension secondSize = this._second.getPreferredSize(context);
        Rectangle mainPosition = new Rectangle();
        Rectangle secondPosition = new Rectangle();
        positions[0] = mainPosition;
        positions[1] = secondPosition;
        mainPosition.x = x;
        mainPosition.y = y;
        mainPosition.width = mainSize.width;
        mainPosition.height = mainSize.height;
        secondPosition.x = x;
        secondPosition.y = y;
        secondPosition.height = secondSize.height;
        int align = this.getActualAlignment(context);
        switch (align % 3) {
            case 0: {
                if (align / 3 != 1) break;
                secondPosition.height = height - mainPosition.height;
                if (secondPosition.height < 0) {
                    secondPosition.height = 0;
                }
                if (secondPosition.height > secondSize.height) {
                    secondPosition.height = secondSize.height;
                }
                mainPosition.y += secondPosition.height;
                break;
            }
            case 1: {
                secondPosition.y += (height - secondSize.height + 1) / 2;
                mainPosition.y += (height - mainSize.height + 1) / 2;
                break;
            }
            case 2: {
                if (align / 3 != 1) {
                    int maxHeight = Math.max(mainSize.height, secondSize.height);
                    if (maxHeight > height) {
                        if (secondSize.height == maxHeight) {
                            mainPosition.y = y + maxHeight - mainSize.height;
                            break;
                        }
                        secondPosition.y = y + maxHeight - secondSize.height;
                        break;
                    }
                    mainPosition.y = y + maxHeight - mainSize.height;
                    secondPosition.y = y + maxHeight - secondSize.height;
                    break;
                }
                secondPosition.y += mainPosition.height;
                secondPosition.height = height - mainPosition.height;
                if (secondPosition.height < 0) {
                    secondPosition.height = 0;
                }
                if (secondPosition.height <= secondSize.height) break;
                secondPosition.height = secondSize.height;
            }
        }
        switch (align / 3) {
            case 0: {
                secondPosition.width = width - mainPosition.width;
                if (secondPosition.width < 0) {
                    secondPosition.width = 0;
                }
                if (secondPosition.width > secondSize.width) {
                    secondPosition.width = secondSize.width;
                }
                mainPosition.x += secondPosition.width;
                break;
            }
            case 1: {
                secondPosition.x += (width - secondSize.width) / 2;
                mainPosition.x += (width - mainSize.width) / 2;
                secondPosition.width = secondSize.width;
                break;
            }
            case 2: {
                secondPosition.x += mainPosition.width;
                secondPosition.width = width - mainPosition.width;
                if (secondPosition.width < 0) {
                    secondPosition.width = 0;
                }
                if (secondPosition.width <= secondSize.width) break;
                secondPosition.width = secondSize.width;
            }
        }
        if (mainPosition.width > width) {
            mainPosition.width = width;
        }
        if (mainPosition.height > height) {
            mainPosition.height = height;
        }
        return positions;
    }
}

