/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import oracle.bali.ewt.model.AbstractOneDModel;

public class ArrayOneDModel
extends AbstractOneDModel {
    private int _itemCount;
    private Object[] _items;

    public ArrayOneDModel(int size) {
        this._itemCount = size;
    }

    public ArrayOneDModel(Object[] items) {
        if (items != null) {
            this._itemCount = items.length;
            this._items = new Object[this._itemCount];
            System.arraycopy(items, 0, this._items, 0, this._itemCount);
        }
    }

    @Override
    public int getItemCount() {
        return this._itemCount;
    }

    public void addItems(int startIndex, Object[] items) {
        if (items != null && items.length > 0) {
            this._addToArray(startIndex, items.length);
            System.arraycopy(items, 0, this._items, startIndex, items.length);
            this.fireModelEvent(2001, startIndex, items.length);
        }
    }

    public void addItems(int startIndex, int count) {
        if (this._items == null) {
            this._itemCount += count;
        } else {
            this._addToArray(startIndex, count);
        }
        this.fireModelEvent(2001, startIndex, count);
    }

    public void removeItems(int startIndex, int count) {
        this._removeFromArray(startIndex, count);
        this.fireModelEvent(2002, startIndex, count);
    }

    @Override
    public Object getData(int index) {
        if (this._items == null) {
            return null;
        }
        return this._items[index];
    }

    @Override
    public void setData(int index, Object data) {
        if (this._items == null) {
            this._items = new Object[this._itemCount];
        }
        this._items[index] = data;
        this.fireModelEvent(2003, index, 1);
    }

    private void _addToArray(int start, int number) {
        Object[] src = this._items;
        int length = 0;
        if (src != null) {
            length = src.length;
        }
        Object[] dst = new Object[length + number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (start != length) {
            System.arraycopy(src, start, dst, start + number, length - start);
        }
        this._items = dst;
        this._itemCount = this._items.length;
    }

    private void _removeFromArray(int start, int number) {
        Object[] src = this._items;
        if (src == null) {
            this._itemCount -= number;
            return;
        }
        int length = src.length;
        Object[] dst = new Object[length - number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (length - number != start) {
            System.arraycopy(src, start + number, dst, start, length - (start + number));
        }
        for (int i = start; i < start + number; ++i) {
            this._items[i] = null;
        }
        this._items = dst;
        this._itemCount = this._items.length;
    }
}

