/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.UIDefaults;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

class WindowsBusyBarPainter
extends AbstractPainter {
    private static boolean _sInitialized;
    private static int _sNumCells;
    private static int _sCellSize;

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if (!this._isRunning(context)) {
            return;
        }
        int state = (Integer)context.getPaintData(EWTBusyBarUI.STATE_KEY);
        Image busyStrip = WindowsBusyBarPainter._getBusyStrip(context);
        int cellIndex = state % _sNumCells;
        int cellSize = _sCellSize;
        g.drawImage(busyStrip, x, y, x + cellSize, y + cellSize, 0, cellSize * cellIndex, cellSize, cellSize * (cellIndex + 1), context.getImageObserver());
    }

    private boolean _isRunning(PaintContext context) {
        return Boolean.TRUE.equals(context.getPaintData(EWTBusyBarUI.IS_RUNNING_KEY));
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        WindowsBusyBarPainter._initialize(context);
        return new Dimension(_sCellSize, _sCellSize);
    }

    private static void _initialize(PaintContext context) {
        if (!_sInitialized) {
            Image busyStrip = WindowsBusyBarPainter._getBusyStrip(context);
            _sCellSize = busyStrip.getWidth(null);
            _sNumCells = busyStrip.getHeight(null) / _sCellSize;
            _sInitialized = true;
        }
    }

    private static Image _getBusyStrip(PaintContext context) {
        UIDefaults defaults = context.getPaintUIDefaults();
        return (Image)defaults.get("EWTBusyBar.stripImage");
    }
}

