/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class SpinButtonPainter
extends AbstractBorderPainter {
    private boolean _increment;
    private boolean _standAlone;
    private static final ImmInsets _sStandAloneInsets = new ImmInsets(2, 2, 1, 2);
    private static final ImmInsets _sCombinedInsets = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _sStandAloneArmedInsets = new ImmInsets(3, 2, 0, 2);
    private static final ImmInsets _sCombinedArmedInsets = new ImmInsets(2, 1, 0, 1);

    public SpinButtonPainter(Painter wrappedPainter, boolean isIncrement, boolean standAlone) {
        super(wrappedPainter);
        this._increment = isIncrement;
        this._standAlone = standAlone;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 1031;
    }

    @Override
    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        boolean armed;
        boolean bl = armed = (context.getPaintState() & 2) != 0;
        return this._standAlone ? (armed ? _sStandAloneArmedInsets : _sStandAloneInsets) : (armed ? _sCombinedArmedInsets : _sCombinedInsets);
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color whiteToBack;
        Color normalToDark;
        Color normalToBack;
        Color backToDark;
        Color whiteToDark;
        boolean isArmed;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color normal = defaults.getColor("normalIntensity");
        Color grayDark = defaults.getColor("controlShadowDark");
        Color outerLight = defaults.getColor("controlLtHighlight");
        Color back = defaults.getColor("control");
        Color white = Color.white;
        boolean isInactive = (state & 4) != 0;
        boolean bl = isArmed = (state & 2) != 0;
        if (isArmed) {
            Color dark;
            whiteToDark = dark = defaults.getColor("controlDkShadow");
            backToDark = dark;
            normalToBack = back;
            normalToDark = dark;
            whiteToBack = back;
        } else {
            whiteToDark = white;
            backToDark = back;
            normalToBack = normal;
            normalToDark = normal;
            whiteToBack = white;
        }
        g.setColor(back);
        if (this._standAlone) {
            if (this._increment) {
                g.fillRect(x + 1, y + 1, width - 2, height - 1);
            } else {
                g.fillRect(x + 1, y, width - 2, height - 1);
            }
        } else {
            g.fillRect(x, y, width, height);
        }
        if (this._increment) {
            if (isInactive) {
                g.setColor(defaults.getColor("controlShadowDark"));
                g.drawLine(x, bottom, right, bottom);
                if (this._standAlone) {
                    g.drawLine(x, y + 1, x, bottom);
                    g.drawLine(x + 1, y, right - 1, y);
                    g.drawLine(right, y + 1, right, bottom);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(right - 1, y + 1, right - 1, y + 1);
                }
            } else {
                if (this._standAlone) {
                    g.setColor(grayDark);
                    g.drawLine(x, y + 1, x, bottom);
                    g.drawLine(x + 1, y, right - 1, y);
                    g.setColor(outerLight);
                    g.drawLine(right, y + 1, right, bottom);
                    g.setColor(back);
                    g.drawLine(right - 1, y + 1, right - 1, y + 1);
                    ++x;
                    ++y;
                    --right;
                }
                g.setColor(normalToDark);
                g.drawLine(x, y, x, y);
                g.setColor(whiteToDark);
                g.drawLine(x, y + 1, x, bottom - 1);
                g.setColor(backToDark);
                g.drawLine(x, bottom, x, bottom);
                g.setColor(normalToBack);
                g.drawLine(x + 1, bottom, right, bottom);
                g.drawLine(right, y + 1, right, bottom - 1);
                g.setColor(normal);
                g.drawLine(right, y, right, y);
                g.setColor(normalToBack);
                g.drawLine(right - 1, y, right - 1, y);
                if (this._standAlone) {
                    g.setColor(whiteToDark);
                } else {
                    g.setColor(whiteToBack);
                }
                g.drawLine(x + 1, y, right - 2, y);
            }
        } else if (isInactive) {
            if (this._standAlone) {
                g.setColor(defaults.getColor("controlShadowDark"));
                g.drawLine(x, y, x, bottom - 1);
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
                g.drawLine(x + 1, bottom, right - 1, bottom);
                g.drawLine(right, y, right, bottom - 1);
            }
        } else {
            if (this._standAlone) {
                g.setColor(grayDark);
                g.drawLine(x, y, x, bottom - 1);
                g.setColor(outerLight);
                g.drawLine(x + 1, bottom, right - 1, bottom);
                g.drawLine(right, y, right, bottom - 1);
                g.setColor(back);
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                ++x;
                --right;
                --bottom;
            }
            g.setColor(whiteToDark);
            g.drawLine(x, y, right - 1, y);
            g.drawLine(x, y + 1, x, bottom - 1);
            g.setColor(normal);
            g.drawLine(x, bottom, x, bottom);
            g.setColor(isArmed ? back : defaults.getColor("controlShadow"));
            g.drawLine(x + 1, bottom, right - 2, bottom);
            g.setColor(normalToBack);
            g.drawLine(right - 1, bottom, right - 1, bottom);
            g.drawLine(right, y + 1, right, bottom - 2);
            g.drawLine(right - 1, bottom - 1, right, bottom - 1);
            g.setColor(back);
            g.drawLine(right, y, right, y);
            if (this._standAlone) {
                g.setColor(outerLight);
            } else {
                g.setColor(defaults.getColor("controlHighlight"));
            }
            g.drawLine(right, bottom, right, bottom);
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

