/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.ImmInsets;

class OraclePivotCellBorderPainter
extends AbstractBorderPainter {
    private static BorderPainter _sInstance;
    private static final ImmInsets _sInsets;

    private OraclePivotCellBorderPainter() {
    }

    public static BorderPainter getBorderPainter() {
        if (_sInstance == null) {
            _sInstance = new OraclePivotCellBorderPainter();
        }
        return _sInstance;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean raised;
        Object data = context.getPaintData("pivotheader.outline");
        boolean outline = Boolean.TRUE.equals(data);
        data = context.getPaintData("pivotheader.horizontal");
        boolean horizontal = Boolean.TRUE.equals(data);
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height;
        int right = x + width;
        Color control = defaults.getColor(LookAndFeel.CONTROL);
        Color shadow = defaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        g.setColor(shadow);
        if (!outline || !horizontal) {
            g.drawLine(x, bottom, right, bottom);
        }
        if (!outline || horizontal) {
            g.drawLine(right, y, right, bottom);
        }
        boolean bl = raised = (data = context.getPaintData(PivotTable.KEY_DRAW_RAISED)) instanceof Boolean ? (Boolean)data : true;
        if (raised && (state & 4) == 0) {
            g.setColor(Color.white);
            if (!outline || !horizontal) {
                g.drawLine(x, y, right, y);
            }
            if (!outline || horizontal) {
                g.drawLine(x, y, x, bottom);
            }
            g.setColor(control);
            g.drawLine(x, bottom, x, bottom);
            g.drawLine(right, y, right, y);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    static {
        _sInsets = new ImmInsets(2, 2, 1, 0);
    }
}

