/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.elaf.basic.BasicEWTArrowBoxUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.oracle.ArrowButtonPainter;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.scrolling.ArrowBox;

public class OracleEWTArrowBoxUI
extends BasicEWTArrowBoxUI {
    private static final Border _BORDER = new BorderUIResource(new BorderAdapter(new OracleInsetBorderPainter(true)));
    private static OracleEWTArrowBoxUI _sInstance;
    private static final Painter[] _painters;

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTArrowBoxUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTArrowBox.border".equals(key)) {
            return _BORDER;
        }
        return null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        LWComponent comp = (LWComponent)c;
        OracleUIUtils.fillBackground(g, comp);
    }

    @Override
    public AbstractButton getIncrementButton(JComponent component) {
        PainterButton pb = new PainterButton(this._getCachedPainter(component, true));
        pb.setFocusable(false);
        return pb;
    }

    @Override
    public AbstractButton getDecrementButton(JComponent component) {
        PainterButton pb = new PainterButton(this._getCachedPainter(component, false));
        pb.setFocusable(false);
        return pb;
    }

    private Painter _getCachedPainter(JComponent component, boolean increment) {
        Painter painter;
        ArrowBox ab = (ArrowBox)component;
        boolean horizontal = ab.getOrientation() == 0;
        int cacheIndex = 0;
        if (increment) {
            ++cacheIndex;
        }
        if (horizontal) {
            cacheIndex += 2;
        }
        if ((painter = _painters[cacheIndex]) == null) {
            int orientation = increment ? (horizontal ? 4 : 3) : (horizontal ? 2 : 1);
            ImageSetPainter containedPainter = new ImageSetPainter(new ImageStrip(BasicUIUtils.getArrowStrip(orientation), 1));
            OracleEWTArrowBoxUI._painters[cacheIndex] = painter = new ArrowButtonPainter(new AlignmentPainter(containedPainter), increment);
        }
        return painter;
    }

    private OracleEWTArrowBoxUI() {
    }

    static {
        _painters = new Painter[4];
    }
}

