/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OracleBusyBarPainter
extends AbstractBorderPainter {
    private static final int _MIN_STATES = 11;
    private static final int _BIG_END_CAP_WIDTH = 7;
    private static final ImageStrip _LARGE_SCANNERS = new ImageStrip(OracleUIUtils.getImage("largeBusyScanStrip.gif"), 1);
    private static final ImageStrip _SMALL_SCANNERS = new ImageStrip(OracleUIUtils.getImage("smallBusyScanStrip.gif"), 1);
    private static final ImageStrip _SMALL_ENDS = new ImageStrip(OracleUIUtils.getImage("smallBusyEndStrip.gif"), 7);
    private static final int _MIN_BUSY_WIDTH = 80;
    private static Dimension _LARGE_SCAN_SIZE = _LARGE_SCANNERS.getSize();
    private static Dimension _SMALL_SCAN_SIZE = _SMALL_SCANNERS.getSize();
    private static Dimension _SMALL_END_SIZE = _SMALL_ENDS.getSize();
    private static final ImmInsets _BIG_INSETS = new ImmInsets(1, 7, 1, 7);
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, OracleBusyBarPainter._SMALL_END_SIZE.width, 1, OracleBusyBarPainter._SMALL_END_SIZE.width);

    public OracleBusyBarPainter(Painter wrappedPainter) {
        super(wrappedPainter, true);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 4;
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        Dimension preferredSize = super.getPreferredSize(context);
        int minimumHeight = this._getMinimumHeight(context);
        if (preferredSize.height < minimumHeight) {
            preferredSize.height = minimumHeight;
        }
        if (preferredSize.width < 80) {
            preferredSize.width = 80;
        }
        return preferredSize;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        Dimension minimumSize = super.getMinimumSize(context);
        int minimumHeight = this._getMinimumHeight(context);
        if (minimumSize.height < minimumHeight) {
            minimumSize.height = minimumHeight;
        }
        if (minimumSize.width < 80) {
            minimumSize.width = 80;
        }
        return minimumSize;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        if (this._hasContent(context)) {
            return _BIG_INSETS;
        }
        return _SMALL_INSETS;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color inactiveColor;
        boolean isRunning = this._isRunning(context);
        if (!isRunning) {
            return;
        }
        boolean useSmallStrip = !this._hasContent(context);
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Color bgColor = defaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        Color topColor = inactiveColor = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        Color bottomColor = inactiveColor;
        Color sideColor = inactiveColor;
        if (isRunning) {
            topColor = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK_LIGHT);
            bottomColor = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            sideColor = defaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        }
        ImageStrip scanStrip = _LARGE_SCANNERS;
        Dimension scanSize = _LARGE_SCAN_SIZE;
        int curveWidth = OracleBusyBarPainter._BIG_INSETS.left;
        if (useSmallStrip) {
            scanStrip = _SMALL_SCANNERS;
            scanSize = _SMALL_SCAN_SIZE;
            curveWidth = OracleBusyBarPainter._SMALL_INSETS.left;
        }
        int startX = x + curveWidth + 1;
        int endX = x + width - curveWidth - 1;
        int rWidth = width - 2 * curveWidth - 2;
        int stateCount = rWidth / 30;
        if (stateCount < 11) {
            stateCount = 11;
        }
        int pixelIncrement = (rWidth - scanSize.width) / (stateCount - 1);
        int startY = y + (height - scanSize.height) / 2;
        Integer stateIndex = (Integer)context.getPaintData(EWTBusyBarUI.STATE_KEY);
        int currState = stateIndex % stateCount;
        g.setColor(bgColor);
        g.fillRect(startX, startY, rWidth, scanSize.height);
        scanStrip.paintImage(0, g, startX + currState * pixelIncrement, startY, null);
        scanStrip.paintImage(1, g, endX - scanSize.width - currState * pixelIncrement, startY, null);
        g.setColor(topColor);
        g.drawLine(startX, startY - 1, startX + rWidth - 1, startY - 1);
        g.setColor(bottomColor);
        g.drawLine(startX, startY + scanSize.height, startX + rWidth - 1, startY + scanSize.height);
        if (useSmallStrip) {
            int baseState = context.getPaintState() & 4 | 2;
            _SMALL_ENDS.paintImage(baseState, g, x + 1, startY - 1, null);
            _SMALL_ENDS.paintImage(baseState + 1, g, endX, startY - 1, null);
        } else {
            OracleButtonPainter.drawSideCurve(g, topColor, topColor, sideColor, bottomColor, bottomColor, bgColor, x + curveWidth, startY - 1, startY + scanSize.height, 1);
            OracleButtonPainter.drawSideCurve(g, topColor, sideColor, bottomColor, bottomColor, bottomColor, bgColor, width - curveWidth, startY - 1, startY + scanSize.height, -1);
        }
        g.setColor(savedColor);
    }

    private boolean _hasContent(PaintContext context) {
        String text = (String)context.getPaintData(PaintContext.LABEL_KEY);
        return text != null && text.length() != 0;
    }

    private int _getMinimumHeight(PaintContext context) {
        Dimension scanSize = this._hasContent(context) ? _LARGE_SCAN_SIZE : _SMALL_SCAN_SIZE;
        return scanSize.height + 2;
    }

    private boolean _isRunning(PaintContext context) {
        return (Boolean)context.getPaintData(EWTBusyBarUI.IS_RUNNING_KEY);
    }
}

