/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TextPainter;

public class NonZeroWidthTextPainter
extends TextPainter {
    private int _replacementWidth;

    public NonZeroWidthTextPainter(int replacementWidth) {
        if (replacementWidth == 0) {
            throw new IllegalArgumentException("replacementWidth should be a non zero value");
        }
        this._replacementWidth = replacementWidth;
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this._checkSize(super.getPreferredSize(context), context);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return this._checkSize(super.getMinimumSize(context), context);
    }

    private Dimension _checkSize(Dimension dim, PaintContext context) {
        FontMetrics metrics;
        Font font;
        if (dim.width == 0) {
            dim.width = this._replacementWidth;
        }
        if (dim.height <= 0 && (font = context.getPaintFont()) != null && (metrics = context.getFontMetrics(font)) != null) {
            dim.height = metrics.getHeight() - metrics.getLeading();
        }
        return dim;
    }
}

