/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;

public final class ToggleMenuItemUIUtils {
    public static void doClick(MenuSelectionManager msm, JMenuItem menuItem, String commandSound) {
        if (!ToggleMenuItemUIUtils._sIsInternalFrameSystemMenu(menuItem)) {
            ToggleMenuItemUIUtils._sPlaySound(menuItem, commandSound);
        }
        menuItem.doClick(0);
        menuItem.setArmed(true);
    }

    public static void installActionMap(JMenuItem menuItem) {
        ActionMap map = new ActionMap();
        map.put("doClick", new Actions("doClick"));
        SwingUtilities.replaceUIActionMap(menuItem, map);
    }

    private static boolean _sIsInternalFrameSystemMenu(JMenuItem item) {
        String actionCommand = item.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    private static void _sPlaySound(JComponent c, Object actionKey) {
        Object[] audioStrings;
        Action audioAction;
        ActionMap map;
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof BasicLookAndFeel && (map = c.getActionMap()) != null && (audioAction = map.get(actionKey)) != null && (audioStrings = (Object[])UIManager.get("AuditoryCues.playList")) != null) {
            HashSet<Object> audioCues = new HashSet<Object>();
            for (int i = 0; i < audioStrings.length; ++i) {
                audioCues.add(audioStrings[i]);
            }
            String actionName = (String)audioAction.getValue("Name");
            if (audioCues.contains(actionName)) {
                audioAction.actionPerformed(new ActionEvent(laf, 1001, actionName));
            }
        }
    }

    private static final class Actions
    extends AbstractAction {
        private static final String CLICK = "doClick";

        public Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            menuItem.doClick();
            menuItem.setArmed(true);
        }
    }
}

