/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDropSupport;
import oracle.bali.ewt.dTree.DTreeDropTarget;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;

class JDKDropper
implements DropTargetListener {
    private DTreeDropSupport _dropSupport;
    private DropTarget _target;

    public JDKDropper(DTreeDropSupport support) {
        this._dropSupport = support;
        this._target = new DropTarget(support.getTree(), this);
    }

    public void dispose() {
        this._target.setComponent(null);
        this._target.removeDropTargetListener(this);
        this._target = null;
        this._dropSupport = null;
    }

    public boolean isEnabled() {
        DTree tree = this._dropSupport.getTree();
        DropTarget target = tree.getDropTarget();
        return target.isActive();
    }

    public void setEnabled(boolean enabled) {
        DTree tree = this._dropSupport.getTree();
        DropTarget target = tree.getDropTarget();
        target.setActive(enabled);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this._handleDrag(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this._handleDrag(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this._handleDrag(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        DTree tree = this._dropSupport.getTree();
        tree.setDropHighlightItem(null);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DTree tree = this._dropSupport.getTree();
        tree.setDropHighlightItem(null);
        Point location = dtde.getLocation();
        DTreeItem item = this._getItemAt(location);
        if (item != null) {
            Point itemPos;
            int dropIndex;
            int targetAction;
            DTreeItem dropItem;
            DTreeDropTarget dropTarget;
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            int sourceActions = dtde.getSourceActions();
            int dropAction = dtde.getDropAction();
            int dropStyle = this._getDropStyle(item, location, flavors, dropAction, sourceActions);
            if (dropStyle != 0 && (dropTarget = this._dropSupport.getDTreeDropTarget(dropItem = this._getDropItem(item, dropStyle))) != null && ((targetAction = dropTarget.getTargetAction(dropItem, dropIndex = this._getDropIndex(item, dropStyle), itemPos = this._convertOuterToItem(dropItem, location), flavors, dropAction, sourceActions)) & sourceActions) != 0) {
                dtde.acceptDrop(targetAction);
                boolean success = dropTarget.handleDrop(dropItem, dropIndex, itemPos, dtde.getTransferable(), targetAction);
                dtde.getDropTargetContext().dropComplete(success);
                return;
            }
        }
        dtde.rejectDrop();
    }

    private void _checkTargetAction(int targetAction, int sourceActions) {
    }

    private int _getDropStyle(DTreeItem item, Point location, DataFlavor[] flavors, int dropAction, int sourceActions) {
        boolean before;
        int dropStyle = 0;
        DTree tree = this._dropSupport.getTree();
        Point canvasPos = tree.convertOuterToCanvas(location.x, location.y);
        Point itemPos = new Point(canvasPos.x - item.getX(), canvasPos.y - item.getY());
        DTreeDropTarget itemTarget = this._dropSupport.getDTreeDropTarget(item);
        if (itemTarget != null) {
            int action = itemTarget.getTargetAction(item, -1, itemPos, flavors, dropAction, sourceActions);
            if (action != 0) {
                dropStyle = 1;
            }
        }
        if ((before = this._isDropBefore(item, itemPos)) || this._isDropAfter(item, itemPos) || dropStyle == 0) {
            Point parentPos;
            int action;
            int itemIndex = item.getIndex();
            int dropIndex = before ? itemIndex : itemIndex + 1;
            DTreeItem parent = item.getParent();
            DTreeDropTarget parentTarget = this._dropSupport.getDTreeDropTarget(parent);
            if (parentTarget != null && (action = parentTarget.getTargetAction(parent, dropIndex, parentPos = new Point(canvasPos.x - parent.getX(), canvasPos.y - parent.getY()), flavors, dropAction, sourceActions)) != 0) {
                int n = dropStyle = before ? 2 : 3;
            }
        }
        if (dropStyle != 0) {
            DTreeItem dropItem = dropStyle == 1 ? item : item.getParent();
            DTreeSelection dragItems = (DTreeSelection)tree.getClientProperty("_ewtDTreeDragItems");
            if (dragItems != null && dragItems.isItemDescendent(dropItem)) {
                return 0;
            }
        }
        return dropStyle;
    }

    private DTreeItem _getItemAt(Point location) {
        DTree tree = this._dropSupport.getTree();
        Point canvasPos = tree.convertOuterToCanvas(location.x, location.y);
        DTreeItem item = tree.getItemAt(canvasPos.x, canvasPos.y);
        if (item != null) {
            return item;
        }
        return null;
    }

    private void _handleDrag(DropTargetDragEvent dtde) {
        Point itemPos;
        int dropIndex;
        int targetAction;
        DTreeItem dropItem;
        DTreeDropTarget dropTarget;
        int sourceActions;
        int dropAction;
        DataFlavor[] flavors;
        int dropStyle;
        DTree tree = this._dropSupport.getTree();
        Point location = dtde.getLocation();
        tree.autoscroll(location);
        DTreeItem item = this._getItemAt(location);
        if (item != null && (dropStyle = this._getDropStyle(item, location, flavors = dtde.getCurrentDataFlavors(), dropAction = dtde.getDropAction(), sourceActions = dtde.getSourceActions())) != 0 && (dropTarget = this._dropSupport.getDTreeDropTarget(dropItem = this._getDropItem(item, dropStyle))) != null && ((targetAction = dropTarget.getTargetAction(dropItem, dropIndex = this._getDropIndex(item, dropStyle), itemPos = this._convertOuterToItem(dropItem, location), flavors, dropAction, sourceActions)) & sourceActions) != 0) {
            dtde.acceptDrag(targetAction);
            tree.setDropHighlightStyle(dropStyle);
            tree.setDropHighlightItem(item);
            return;
        }
        dtde.rejectDrag();
        tree.setDropHighlightItem(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _isDropBefore(DTreeItem item, Point location) {
        if (location.y < 0) return false;
        if (location.y >= 5) return false;
        return true;
    }

    private boolean _isDropAfter(DTreeItem item, Point location) {
        Dimension size = item.getSize();
        return location.y > size.height - 5 && location.y < size.height;
    }

    private int _getDropIndex(DTreeItem item, int dropStyle) {
        switch (dropStyle) {
            case 1: {
                return -1;
            }
            case 2: {
                return item.getIndex();
            }
            case 3: {
                return item.getIndex() + 1;
            }
        }
        return -1;
    }

    private DTreeItem _getDropItem(DTreeItem item, int dropStyle) {
        return dropStyle == 1 ? item : item.getParent();
    }

    private Point _convertOuterToItem(DTreeItem item, Point outerPos) {
        DTree tree = this._dropSupport.getTree();
        Point canvasPos = tree.convertOuterToCanvas(outerPos.x, outerPos.y);
        return new Point(canvasPos.x - item.getX(), canvasPos.y - item.getY());
    }
}

