/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferredChild;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeExpansionListener;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeSparseChildManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;

public abstract class DTreeDeferredParent
extends DTreeDeferredChild
implements DTreeDeferringParent,
OneDModelListener {
    private OneDModel _datasrc;
    private DTreeChildManager _childmgr;
    private boolean _expanded;

    protected DTreeDeferredParent(OneDModel model) {
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        this._datasrc = model;
        this._datasrc.addModelListener(this);
    }

    @Override
    public void childExpansionChanged(DTreeItem child) {
        this._childmgr.childExpansionChanged(this, child);
    }

    @Override
    public Object getChildData(int index) {
        return this._datasrc.getData(index);
    }

    @Override
    public int getChildHeight() {
        DTree tree = this.getTree();
        EWTTreeUI treeUI = tree.getUI();
        return treeUI.getDeferredChildHeight(tree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    @Override
    public int getChildX(int index) {
        return this._childmgr.getChildX(this, index);
    }

    @Override
    public int getChildY(int index) {
        return this._childmgr.getChildY(this, index);
    }

    @Override
    public OneDModel getModel() {
        return this._datasrc;
    }

    @Override
    public DTreeItem getItem(int index) {
        if (this._childmgr == null) {
            this._childmgr = this.createChildManager();
        }
        return this._childmgr.getItem(this, index);
    }

    @Override
    public DTreeItem getItemAt(int x, int y) {
        return this._childmgr.getItemAt(this, x, y);
    }

    @Override
    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    @Override
    public abstract DTreeItemFactory getItemFactory();

    @Override
    public DTreeItem getNextExpandedChild(DTreeItem child) {
        return this._childmgr.getNextExpandedChild(this, child);
    }

    @Override
    public DTreeItem getNextInstantiatedChild(DTreeItem child) {
        if (this._childmgr == null) {
            return null;
        }
        return this._childmgr.getNextInstantiatedChild(this, child);
    }

    @Override
    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight(this);
        }
        return this.getSize().height;
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void layout(int x, int y) {
        this._childmgr.layout(this, x, y);
    }

    public void setModel(OneDModel model) {
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        OneDModel oldModel = this.getModel();
        int oldCount = this.getItemCount();
        if (oldCount > 0) {
            this.itemsRemoved(new OneDModelEvent(oldModel, 2002, 0, oldCount));
        }
        oldModel.removeModelListener(this);
        this._datasrc = model;
        int newCount = model.getItemCount();
        if (newCount > 0) {
            this.itemsAdded(new OneDModelEvent(model, 2001, 0, newCount));
        }
        model.addModelListener(this);
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        if (isExpanded == this.isExpanded()) {
            return;
        }
        DTree tree = this.getTree();
        if (!DTreeDeferredParent.__fireExpansionChanging(tree, isExpanded, this)) {
            this._expanded = isExpanded;
            if (isExpanded && this._childmgr == null) {
                this._childmgr = this.createChildManager();
            }
            DTreeDeferredParent.__fireExpansionChanged(tree, isExpanded, this);
        }
    }

    @Override
    public void itemsAdded(OneDModelEvent evt) {
        DTree tree;
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsAdded(this, startIndex, count);
        }
        if ((tree = this.getTree()) != null) {
            tree.itemsAdded(this, startIndex, count);
        }
    }

    @Override
    public void itemsRemoved(OneDModelEvent evt) {
        DTree tree;
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsRemoved(this, startIndex, count);
        }
        if ((tree = this.getTree()) != null) {
            tree.itemsRemoved(this, startIndex, count);
        }
    }

    @Override
    public void invalidateItems(OneDModelEvent evt) {
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        DTree tree = this.getTree();
        if (tree != null) {
            tree.itemsInvalidated(this, startIndex, count);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager();
    }

    protected int getChildIconHeight() {
        return 18;
    }

    static boolean __fireExpansionChanging(DTree tree, boolean expanded, DTreeDeferringParent item) {
        OneDModel model;
        int evtID = expanded ? 2000 : 2002;
        DTreeItemValidateEvent evt = new DTreeItemValidateEvent(tree, evtID, item);
        if (tree != null) {
            tree.dispatchEvent(evt);
            if (evt.isCancelled()) {
                return true;
            }
        }
        if ((model = item.getModel()) instanceof DTreeExpansionListener) {
            DTreeExpansionListener listener = (DTreeExpansionListener)((Object)model);
            if (expanded) {
                listener.dTreeItemExpanding(evt);
            } else {
                listener.dTreeItemCollapsing(evt);
            }
            return evt.isCancelled();
        }
        return false;
    }

    static void __fireExpansionChanged(DTree tree, boolean expanded, DTreeDeferringParent item) {
        DTreeItem parent = item.getParent();
        if (parent instanceof DTreeDeferringParent) {
            ((DTreeDeferringParent)parent).childExpansionChanged(item);
        }
        int evtID = expanded ? 2001 : 2003;
        DTreeItemEvent evt = new DTreeItemEvent(tree, evtID, item);
        OneDModel model = item.getModel();
        if (model instanceof DTreeExpansionListener) {
            DTreeExpansionListener listener = (DTreeExpansionListener)((Object)model);
            if (expanded) {
                listener.dTreeItemExpanded(evt);
            } else {
                listener.dTreeItemCollapsed(evt);
            }
        }
        if (tree != null) {
            tree.dispatchEvent(evt);
        }
    }
}

