/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;

public class TitledPane
extends LWComponent
implements Accessible {
    private Component _title;
    private Component _content;
    private static final Border _sInnerBorder = new TitledBorder((String)null);
    private static final int _LABEL_INSET = 10;
    private static final int _COMPONENT_INSET = 5;

    public TitledPane() {
        this(null, null);
    }

    public TitledPane(Component title, Component content) {
        this.setTitle(title);
        this.setContent(content);
        super.setLayout(new Layout());
        this.setAlignmentX(0.0f);
    }

    public void setTitle(Component title) {
        if (title != this._title) {
            if (this._title != null) {
                this.remove(this._title);
                this._title = null;
            }
            if (title != null) {
                this._title = title;
                this.add(title);
            }
        }
    }

    public Component getTitle() {
        return this._title;
    }

    public void setContent(Component content) {
        if (content != this._content) {
            if (this._content != null) {
                this.remove(this._content);
                this._content = null;
            }
            if (content != null) {
                this._content = content;
                this.add(content);
            }
        }
    }

    public Component getContent() {
        return this._content;
    }

    @Override
    public void setLayout(LayoutManager layout) {
    }

    void __doLayout() {
        Dimension size = this.getSize();
        Dimension title = this._getSize(this._title, true);
        Insets insets = _sInnerBorder.getBorderInsets(this);
        int availableWidth = size.width - 30;
        int titleWidth = title.width;
        if (availableWidth < titleWidth) {
            titleWidth = availableWidth;
        }
        int titleX = 15 + (int)((float)(availableWidth - titleWidth) * this.getAlignmentX());
        if (this._title != null) {
            this._title.setBounds(titleX, 0, titleWidth, title.height);
        }
        if (this._content != null) {
            this._content.setBounds(insets.left, title.height, size.width - (insets.left + insets.right), size.height - (title.height + insets.bottom));
        }
        super.setBorder(new CompoundBorder(new EmptyBorder(title.height / 2, 0, 0, 0), _sInnerBorder));
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        Color savedColor = g.getColor();
        g.setColor(this.getBackground());
        if (this._title != null) {
            Rectangle r = this._title.getBounds();
            g.fillRect(r.x - 5, r.y, r.width + 10, r.height);
            g.setColor(savedColor);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != this._title && comp != this._content) {
            if (this._title == null) {
                this._title = comp;
            } else {
                Component content = this._content;
                if (content != null) {
                    this.remove(content);
                }
                this._content = comp;
            }
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    Dimension __calculateSize(Dimension title, Dimension content) {
        Insets insets = _sInnerBorder.getBorderInsets(this);
        return new Dimension(Math.max(content.width, title.width + 30) + insets.left + insets.right, title.height + content.height + insets.bottom);
    }

    Dimension _getSize(Component component, boolean usePref) {
        if (component == null) {
            return new Dimension(0, 0);
        }
        return usePref ? component.getPreferredSize() : component.getMinimumSize();
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension title = TitledPane.this._getSize(TitledPane.this.getTitle(), true);
            Dimension content = TitledPane.this._getSize(TitledPane.this.getContent(), true);
            return TitledPane.this.__calculateSize(title, content);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension title = TitledPane.this._getSize(TitledPane.this.getTitle(), false);
            Dimension content = TitledPane.this._getSize(TitledPane.this.getContent(), false);
            return TitledPane.this.__calculateSize(title, content);
        }

        @Override
        public void layoutContainer(Container parent) {
            TitledPane.this.__doLayout();
        }
    }

    protected class AccessibleTitledPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleTitledPane() {
            super(TitledPane.this);
        }

        @Override
        public String getAccessibleName() {
            String name;
            Component title;
            if (this.accessibleName == null && (title = TitledPane.this.getTitle()) instanceof Accessible && (name = ((Accessible)((Object)title)).getAccessibleContext().getAccessibleName()) != null) {
                return name;
            }
            return super.getAccessibleName();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.GROUP_BOX;
        }
    }
}

