/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.ui.ConsoleUIService;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.liquibase.core.CommandGenerator;
import oracle.dbtools.raptor.liquibase.exception.NoRollbackException;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.UnknownPropertySetNameException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.ArgumentTokenizer;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class LbCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    private final String LF = System.lineSeparator();
    private CommandHelp help;
    String colored_old;
    String colored_new;

    public void beginEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public void endEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public String getCommand() {
        return "Liquibase".toUpperCase();
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getCommandLongName() {
        return "Liquibase";
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return LBOptions.commandModel;
    }

    public String getCommandShortName() {
        return "lb";
    }

    public String getExtensionDescription() {
        return Messages.getString("LB_EXTENTION_DESC");
    }

    public String getExtensionName() {
        return "Liquibase";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        try {
            this.help = new CommandHelp(new ScriptRunnerContext(), LBOptions.class);
            ScriptRunnerContext theCtx = new ScriptRunnerContext();
            this.help = new CommandHelp(theCtx, LBOptions.class);
            CommandParser.loadParams((String)"lb.parameters", (String)"lb help", (ScriptRunnerContext)theCtx, LBOptions.class);
            return this.help.getCommandHelp();
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            return Messages.getString("HELP_ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean _help;
        if (!(cmd.getLoweredTrimmedSQL().replaceAll("^\"|\"$", "").startsWith("lb ") || cmd.getLoweredTrimmedSQL().replaceAll("^\"|\"$", "").toLowerCase().startsWith("liquibase") || "lb".equals(cmd.getLoweredTrimmedSQL()))) {
            return false;
        }
        LbUtils.setContext(ctx);
        LbUtils.getContext().getParameterInstance().putParameter("lb.parameters", "sqlclversion", (Object)LbUtils.getSqlClVersion());
        try {
            Connection con;
            if (cmd.getLoweredTrimmedSQL().contains("-log")) {
                Level logLevel = Level.INFO;
                if (cmd.getLoweredTrimmedSQL().contains("-debug")) {
                    logLevel = Level.FINEST;
                }
                LbFileUtils.configureLogging(logLevel, LbFileUtils.getLogFile(false));
            }
            this.help = new CommandHelp(ctx, LBOptions.class);
            try {
                CommandParser.loadParams((String)"lb.parameters", (String)ScriptUtils.checkforContinuationChars((String)cmd.getSql()), (ScriptRunnerContext)ctx, LBOptions.class, (boolean)true, (boolean)false, (boolean)true);
            }
            catch (InvalidParameterException | InvalidCommandException | ParameterFailedValidationException e) {
                this.colored_old = "";
                this.colored_new = "";
                String mappedcmd = this.parseOldWay(conn, ctx, ScriptUtils.checkforContinuationChars((String)cmd.getSql().replaceAll("^\"|\"$", "")));
                CommandParser.loadParams((String)"lb.parameters", (String)mappedcmd, (ScriptRunnerContext)ctx, LBOptions.class);
                ctx.write("\n" + Messages.getString("LB_REPARSED"));
                ctx.write("\nOld Syntax: " + this.colored_old);
                ctx.write("New Syntax: " + this.colored_new + "\n");
            }
            LbUtils.setContext(ctx);
            ctx.getParameterInstance().putParameter("lb.parameters", "sqlclversion", (Object)LbUtils.getSqlClVersion());
            String _command = LbUtils.getParameter(CommandParserConstants.COMMAND);
            _help = LbUtils.getBoolenParameter(CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                boolean bl = true;
                return bl;
            }
            System.setProperty("user.dir", LbUtils.getContext().prependCD(""));
            if (conn != null && "SYS".equals(conn.getSchema())) {
                throw new LiquibaseException(Messages.getString("SYS_UNSUPPORTED"));
            }
            if (LbUtils.getParameter("exptype") != null && LbUtils.getParameter("exptype").length() > 0) {
                List<String> types = Arrays.asList(LbUtils.getParameter("exptype").split(","));
                List sortedList = types.stream().sorted((lhs, rhs) -> {
                    if ("APPLICATION_SOURCE".equals(lhs)) {
                        return 1;
                    }
                    if ("APPLICATION_SOURCE".equals(rhs)) {
                        return -1;
                    }
                    return 0;
                }).collect(Collectors.toList());
                LbUtils.setParameter("exptype", String.join((CharSequence)",", sortedList));
            }
            if (conn != null) {
                LbUtils.getContext().getParameterInstance().putParameter("lb.parameters", "isSqlCl", (Object)"true");
                if (LbUtils.getContext().getParameterInstance().getParameters("ddl.parms") == null) {
                    SetDDLSettings.resetDDLParameters((ScriptRunnerContext)LbUtils.getContext());
                }
            }
            ConsoleUIService service = (ConsoleUIService)Scope.getCurrentScope().getUI();
            PrintStream stream = new PrintStream((OutputStream)ctx.getOutputStream(), true);
            service.setOutputStream(stream);
            service.setErrorStream(stream);
            LbUtils.resetErrors();
            Scope.getCurrentScope().getUI().sendMessage("--" + LbUtils.getBanner() + this.LF);
            LbUtils.log("Starting LB command: " + _command);
            if ("calculate-checksum".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.CalculateCheckSumCommand());
            } else if ("clear-checksums".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.ClearCheckSumsCommand();
            } else if ("version".equalsIgnoreCase(_command)) {
                ctx.write(LbUtils.getVersion());
            } else if ("history".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.HistoryCommand());
            } else if ("status".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.StatusCommand());
            } else if ("validate".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.ValidateCommand());
            } else if ("changelog-sync".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.ChangeLogSyncCommand();
            } else if ("changelog-sync-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.ChangeLogSyncSqlCommand());
            } else if ("changelog-sync-to-tag".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.ChangeLogSyncCommand();
            } else if ("changelog-sync-to-tag-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.ChangeLogSyncSqlCommand());
            } else if ("data".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.DataCommand());
            } else if ("diff".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.DiffCommand());
            } else if ("diff-changelog".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.DiffChangelogCommand());
            } else if ("db-doc".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.DbDocCommand();
            } else if ("future-rollback-count-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.FutureRollbackCountSqlCommand());
            } else if ("future-rollback-from-tag-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.FutureRollbackTagSqlCommand());
            } else if ("future-rollback-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.FutureRollbackSqlCommand());
            } else if ("generate-changelog".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.GenerateChangelogCommand());
            } else if ("generate-control-file".equalsIgnoreCase(_command)) {
                ctx.write(CommandGenerator.GenerateControlFileCommand());
            } else if ("generate-object".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(Messages.format("CHANGELOG_CREATED", CommandGenerator.GenerateDbObjectCommand(conn)));
            } else if ("generate-apex-object".equalsIgnoreCase(_command)) {
                con = ctx.cloneCLIConnection();
                LbUtils.checkConnection(con);
                ctx.write(CommandGenerator.GenerateApexObjectCommand(con));
                con.close();
            } else if ("generate-ords-module".equalsIgnoreCase(_command)) {
                con = ctx.cloneCLIConnection();
                LbUtils.checkConnection(con);
                ctx.write(Messages.format("CHANGELOG_CREATED", CommandGenerator.GenerateOrdsModuleCommand(con)));
                con.close();
            } else if ("generate-ords-schema".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(Messages.format("CHANGELOG_CREATED", CommandGenerator.GenerateOrdsSchemaCommand(conn)));
            } else if ("generate-schema".equalsIgnoreCase(_command)) {
                con = ctx.cloneCLIConnection();
                LbUtils.checkConnection(con);
                CommandGenerator.GenerateSchemaCommand(con);
                con.close();
            } else if ("list-locks".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.ListLocksCommand());
            } else if ("release-locks".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.ReleaseLocksCommand();
            } else if ("mark-next-changeset-ran".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.MarkNextChangesetRanCommand();
            } else if ("mark-next-changeset-ran-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.MarkNextChangesetRanSqlCommand());
            } else if ("rollback".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.RollbackCommand();
            } else if ("rollback-count".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.RollbackCountCommand();
            } else if ("rollback-count-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.RollbackCountSqlCommand());
            } else if ("rollback-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.RollbackSqlCommand());
            } else if ("rollback-to-date".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.RollbackToDateCommand();
            } else if ("rollback-to-date-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.RollbackToDateSqlCommand());
            } else if ("snapshot".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.SnapShotCommand());
            } else if ("tag-exists".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                if (CommandGenerator.TagExistsCommand()) {
                    ctx.write(Messages.format("LB_TAGCHECK_SUCCESS", LbUtils.getParameter("tag")));
                } else {
                    ctx.write(Messages.format("LB_TAGCHECK_FAIL", LbUtils.getParameter("tag")));
                }
            } else if ("tag".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.TagCommand();
            } else if ("unexpected-changesets".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.UnexpectedChangessetsCommand());
            } else if ("update".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.UpdateCommand();
            } else if ("update-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.UpdateSqlCommand());
            } else if ("update-count".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.UpdateCountCommand();
            } else if ("update-count-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.UpdateCountSqlCommand());
            } else if ("update-to-tag".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.UpdateToTagCommand();
            } else if ("update-to-tag-sql".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.UpdateToTagSqlCommand());
            } else if ("update-testing-rollback".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                ctx.write(CommandGenerator.UpdateTestingRollbackCommand());
            } else if ("drop-all".equalsIgnoreCase(_command)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.DropAllCommand();
            } else {
                ctx.write(Messages.getString("COMMAND_ERROR"));
            }
            LbUtils.log("Ending LB command: " + _command);
            if (LbUtils.getErrCount() == 0) {
                this.write_success(ctx);
            } else {
                ctx.write(this.LF);
                ctx.write("Process Completed. " + LbUtils.getErrCount() + " errors encountered.");
                ctx.write(this.LF);
            }
            String eLog = LbUtils.writeErrorLog();
            if (eLog != null && eLog != "") {
                ctx.write(Messages.format("LB_ERROR", eLog));
            }
        }
        catch (Exception e) {
            if (e instanceof NoRollbackException) {
                ctx.write(Messages.format("NO_ROLLBACK", new Object[0]) + this.LF);
                _help = true;
                return _help;
            }
            String eLog = LbUtils.writeErrorLog();
            if (eLog != null && eLog != "") {
                ctx.write(Messages.format("LB_ERROR", eLog));
            } else {
                LbUtils.report(e);
            }
            if (cmd.getSql().toLowerCase().contains("-debug")) {
                LbUtils.setParameter("debug", "true");
            }
            ScriptUtils.doWhenever((ScriptRunnerContext)ctx, (ISQLCommand)cmd, (Connection)conn, (boolean)true);
        }
        finally {
            LbUtils.log("Loggind Ended");
            LbFileUtils.cleanup();
        }
        if (LbUtils.getBoolenParameter("debug")) {
            ctx.getParameterInstance().printParametersAsRow("lb.parameters");
        }
        return true;
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return false;
    }

    private String parseOldWay(Connection conn, ScriptRunnerContext ctx, String cmd) throws InvalidParameterException, IOException, InvalidCommandException, ParameterFailedValidationException, UnknownPropertySetNameException {
        String newcmd = cmd;
        this.colored_old = cmd;
        this.colored_new = cmd;
        boolean genapex = false;
        boolean genords = false;
        List rawArgs = ArgumentTokenizer.tokenize((String)cmd, (boolean)false, (boolean)true);
        String[] _args = rawArgs.toArray(new String[0]);
        LinkedList<String> _argList = new LinkedList<String>(Arrays.asList(_args));
        for (String arg : _args) {
            while (arg.startsWith("-")) {
                arg = arg.substring(1).toLowerCase();
            }
            if ((genapex || genords) && "type".equals(arg.toLowerCase())) continue;
            if ("genobject".equals(arg.toLowerCase())) {
                if (_argList.indexOf("-type") <= 0) continue;
                String type = _argList.get(_argList.indexOf("-type") + 1).toUpperCase();
                if ("APEX".equals(type) || "ORDS".equals(type)) {
                    if ("APEX".equals(type)) {
                        genapex = true;
                        newcmd = newcmd.replace(arg, "generate-apex-object");
                        this.colored_old = this.colored_old.replace(arg, "\u001b[31m" + arg + "\u001b[0m");
                        this.colored_new = this.colored_new.replace(arg, "\u001b[32mgenerate-apex-object\u001b[0m");
                    } else if ("ORDS".equals(type)) {
                        genords = true;
                        newcmd = newcmd.replace(arg, "generate-ords-module");
                        this.colored_old = this.colored_old.replace(arg, "\u001b[31m" + arg + "\u001b[0m");
                        this.colored_new = this.colored_new.replace(arg, "\u001b[32mgenerate-ords-module\u001b[0m");
                    }
                    newcmd = newcmd.replaceAll("(?i)-type " + type, "");
                    this.colored_old = this.colored_old.replaceAll("(?i)-type " + type, "\u001b[31m-type " + _argList.get(_argList.indexOf("-type") + 1) + "\u001b[0m");
                    this.colored_new = this.colored_new.replaceAll("(?i)-type " + type, "");
                    continue;
                }
                newcmd = newcmd.replace(arg, "generate-object");
                this.colored_old = this.colored_old.replace(arg, "\u001b[31m" + arg + "\u001b[0m");
                this.colored_new = this.colored_new.replace(arg, "\u001b[32mgenerate-object\u001b[0m");
                continue;
            }
            if (genords && "name".equals(arg.toLowerCase())) {
                newcmd = newcmd.replace(arg, "module-name");
                this.colored_old = this.colored_old.replace(arg, "\u001b[31m" + arg + "\u001b[0m");
                this.colored_new = this.colored_new.replace(arg, "\u001b[32mmodule-name\u001b[0m");
                continue;
            }
            if (LBOptions.legacyCommandMapping.containsKey(arg.toLowerCase())) {
                newcmd = newcmd.replace(arg, LBOptions.legacyCommandMapping.get(arg.toLowerCase()));
                this.colored_old = this.colored_old.replace(arg, "\u001b[31m" + arg + "\u001b[0m");
                this.colored_new = this.colored_new.replace(arg, "\u001b[32m" + LBOptions.legacyCommandMapping.get(arg.toLowerCase()) + "\u001b[0m");
            }
            if (!LBOptions.legacyParamMapping.containsKey(arg.toLowerCase())) continue;
            newcmd = newcmd.replace(arg, LBOptions.legacyParamMapping.get(arg.toLowerCase()));
            this.colored_old = this.colored_old.replace("-" + arg, "\u001b[31m-" + arg + "\u001b[0m");
            this.colored_new = this.colored_new.replace("-" + arg, "\u001b[32m-" + LBOptions.legacyParamMapping.get(arg.toLowerCase()) + "\u001b[0m");
        }
        return newcmd;
    }

    private void write_success(ScriptRunnerContext ctx) {
        ctx.write(this.LF);
        if (LbUtils.getBoolenParameter("log")) {
            ctx.write("Produced logfile: " + LbFileUtils.getLog().toString() + this.LF);
        }
        ctx.write(Messages.getString("LB_OPERATION_SUCCESS"));
        ctx.write(this.LF);
    }
}

