/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import liquibase.exception.DatabaseException;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGeneratorUtils;
import oracle.dbtools.raptor.liquibase.util.ApexUtils;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.liquibase.util.StopWatch;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.UnknownPropertySetNameException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class SchemaGenerator {
    String sqlcl_save_capture = "YES".equals(System.getenv("sqlcl_save_capture")) ? "YES" : "";
    static DBUtil dbUtil;
    String DDL = "ddl";
    private final Connection conn;
    private final List<String> no_parse_files = new ArrayList<String>();
    public static final HashMap<String, String> ddlChangeTypes;
    public static LinkedHashMap<String, Integer> ordered_types_short;
    public static LinkedHashMap<String, Integer> ordered_types_long;
    public static final HashMap<String, String> typeNameTransform;
    boolean capture = false;

    public static String getMasterLog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n";
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkApexVersion", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException("APEX is not installed in DB or this connection has no access.");
        }
        Version source = new Version(version);
        return source.compareTo(new Version("19.2")) > 0;
    }

    public static void writeMasterLog(Path path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile()));
        writer.write(SchemaGenerator.getMasterLog());
        writer.close();
    }

    public SchemaGenerator(Connection _conn) {
        dbUtil = DBUtil.getInstance((Connection)_conn);
        this.conn = _conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> doSchemaExport(boolean createFiles) throws Exception {
        StringBuilder sb = null;
        if ("YES".equals(this.sqlcl_save_capture)) {
            this.capture = true;
        }
        HashMap<String, Object> params = LbUtils.getParameters();
        HashMap<String, Object> _ret = new HashMap<String, Object>();
        boolean pubSyns = Boolean.parseBoolean((String)params.get("synonyms"));
        boolean grants = Boolean.parseBoolean((String)params.get("grants"));
        if (!createFiles) {
            sb = new StringBuilder();
        }
        if (sb == null) {
            LbUtils.getContext().write("\n" + Messages.getString("LB_FLAGS") + "\n");
            LbUtils.getContext().write(Messages.getString("LB_GRANTS") + "\t\t" + grants + "\n");
            LbUtils.getContext().write(Messages.getString("LB_SYNS") + "\t\t" + pubSyns + "\n\n");
        } else {
            sb.append("\n").append(Messages.getString("LB_FLAGS")).append("\n");
            sb.append(Messages.getString("LB_GRANTS")).append("\t\t").append(grants).append("\n");
            sb.append(Messages.getString("LB_SYNS")).append("\t\t").append(pubSyns).append("\n");
        }
        SchemaGeneratorUtils.createCaptureObjects(this.conn);
        boolean split = false;
        if (params.get("split") != null) {
            split = Boolean.parseBoolean((String)params.get("split"));
        }
        try {
            this.loadCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(this.conn, "exp_load");
            }
            this.processCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(this.conn, "exp_process");
            }
            this.cleanupCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(this.conn, "exp_cleanup");
            }
            this.sortCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(this.conn, "exp_sort");
            }
            StopWatch stopWatch = new StopWatch("Method writeChangeLogs", sb);
            if (this.no_parse_files.size() > 0) {
                if (createFiles) {
                    LbUtils.getContext().write("\n" + Messages.getString("LB_NO_PARSE") + "\n");
                } else {
                    sb.append("\n").append(Messages.getString("LB_NO_PARSE")).append("\n");
                }
                for (String name : this.no_parse_files) {
                    if (createFiles) {
                        LbUtils.getContext().write(name + "\n");
                        continue;
                    }
                    sb.append(name).append("\n");
                }
            }
            LinkedList<String> includes = new LinkedList<String>();
            String writeFiles = QueryUtils.getXMLQueries().getQuery("writeCaptureTable", this.conn).getSql();
            PreparedStatement pstatement = this.conn.prepareStatement(writeFiles);
            ResultSet rs = pstatement.executeQuery();
            while (rs.next()) {
                try {
                    Object file;
                    LbUtils.setParameter("object-name", rs.getString(1));
                    String oType = rs.getString(2).toLowerCase();
                    Object filename = rs.getString(3).toLowerCase();
                    LbUtils.setParameter("object-type", oType.toUpperCase());
                    if (split) {
                        filename = oType + "/" + (String)filename;
                    }
                    LbUtils.setParameter("filename", (String)filename);
                    LbUtils.setParameter("ddl", LiquibaseStringUtils.clobToString(rs.getClob(4)));
                    if (createFiles) {
                        file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("filename"), this.getChangeLog());
                    } else {
                        file = filename;
                        _ret.put((String)file, this.getChangeLog());
                    }
                    includes.add((String)file);
                }
                catch (Exception e) {
                    LbUtils.log(e);
                    LbUtils.report("Error generating changelog");
                }
            }
            if (createFiles) {
                LbFileUtils.writeFile(LbUtils.getContext(), LBOptions.DEFAULT_CONTROLLER_NAME, this.genLbController(includes));
            } else {
                _ret.put(LBOptions.DEFAULT_CONTROLLER_NAME, this.genLbController(includes));
            }
            stopWatch.end(sb);
            if (sb == null) {
                LbUtils.getContext().write("\n");
            } else {
                _ret.put(LBOptions.DEFAULT_SCREEN_OUTPUT_NAME, sb.toString());
            }
            HashMap<String, Object> hashMap = _ret;
            return hashMap;
        }
        finally {
            SchemaGeneratorUtils.dropCaptureObjects(this.conn);
        }
    }

    public String genLbController(LinkedList<String> files) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genControllerHeader());
        for (String file : files) {
            sb.append(this.genControllerInclude(file));
        }
        sb.append(this.genControllerFooter());
        return sb.toString();
    }

    public String getChangeLog() throws DatabaseException, SQLException, NoSuchAlgorithmException, ObjectNotFoundException {
        this.cleanDdlParam();
        String oType = LbUtils.getParameter("object-type");
        String oName = LbUtils.getParameter("object-name");
        String ddlXml = LbUtils.getParameter("ddl");
        String context = LbUtils.getParameter("contexts");
        String label = LbUtils.getParameter("labels");
        boolean fail = LbUtils.getBoolenParameter("fail-on-error");
        boolean replace = LbUtils.getBoolenParameter("replace");
        boolean runonchange = LbUtils.getBoolenParameter("runonchange");
        boolean runalways = LbUtils.getBoolenParameter("runalways");
        boolean disableTrans = false;
        String rawChangeLogString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" %FAILONERROR% %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
        String change = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" %FAILONERROR% %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
        String schema = this.conn.getSchema();
        change = LiquibaseStringUtils.replaceVal("%ID%", this.getSha1fromString(ddlXml), change);
        change = LiquibaseStringUtils.replaceVal("%AUTHOR%", "(" + this.conn.getSchema() + ")-Generated", change);
        if (oName != null) {
            change = LiquibaseStringUtils.replaceVal("%OBJECT_NAME%", oName.replaceAll("\"", ""), change);
        }
        if (oType != null) {
            change = LiquibaseStringUtils.replaceVal("%OBJECT_TYPE%", oType, change);
        }
        if (schema != null) {
            change = LiquibaseStringUtils.replaceVal("%OWNER_NAME%", schema, change);
        }
        change = LiquibaseStringUtils.replaceVal("%SOURCE%", ddlXml.replaceAll("\\]\\]\\>", "]]]]><![CDATA[>"), change);
        if (DbmsMetaUtils.isSxmlType(oType.toUpperCase())) {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createSxmlObject", change);
        } else if ("COMMENT".equalsIgnoreCase(oType)) {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createOracleComment", change);
            change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
        } else if ("SCRIPT".equalsIgnoreCase(oType) && "ORDS".equals(oName)) {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOrdsScript", change);
            change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
        } else if ("SCRIPT".equalsIgnoreCase(oType) && "APEX".equals(oName)) {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runApexScript", change);
            change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
            disableTrans = true;
        } else if ("SCRIPT".equalsIgnoreCase(oType)) {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", change);
            change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
        } else {
            change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", ddlChangeTypes.get(oType.toUpperCase()), change);
        }
        change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "", change);
        if ("TRIGGER".equals(oType)) {
            change = change.replaceAll("END;\\nALTER TRIGGER", "END;\n/\nALTER TRIGGER");
        }
        change = fail ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", change) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"false\"", change);
        change = replace ? LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"true\"", change) : LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"false\"", change);
        change = context != null && !context.isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + context + "\"", change) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, change);
        change = label != null && !label.isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + label + "\"", change) : LiquibaseStringUtils.replaceVal("%LABELS%", null, change);
        Object runOptions = "";
        runOptions = runonchange ? "runOnChange=\"true\" " : "runOnChange=\"false\" ";
        runOptions = runalways ? (String)runOptions + "runAlways=\"true\" " : (String)runOptions + "runAlways=\"false\" ";
        if (disableTrans) {
            runOptions = (String)runOptions + "runInTransaction=\"true\" ";
        }
        change = runOptions != null && !((String)runOptions).isEmpty() ? LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", (String)runOptions, change) : LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", null, change);
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrdsModuleChangeLog() throws DatabaseException, NoSuchAlgorithmException, SQLException, IOException, ObjectNotFoundException {
        String module = LbUtils.getParameter("module-name");
        boolean enable = LbUtils.getBoolenParameter("include-enable-schema");
        boolean privs = LbUtils.getBoolenParameter("include-privs");
        CallableStatement stmt = null;
        try {
            String ordsQuery = "begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
            stmt = this.conn.prepareCall(ordsQuery);
            stmt.registerOutParameter(1, 2005);
            stmt.setString(2, module);
            stmt.setInt(3, enable ? 0 : 1);
            stmt.setInt(4, privs ? 0 : 1);
            stmt.execute();
            Clob script = stmt.getClob(1);
            LbUtils.setParameter("object-name", "ORDS");
            LbUtils.setParameter("object-type", "SCRIPT");
            LbUtils.setParameter("ddl", LiquibaseStringUtils.clobToString(script));
            String string = this.getChangeLog();
            return string;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrdsSchemaChangeLog() throws SQLException, IOException, DatabaseException, NoSuchAlgorithmException, ObjectNotFoundException {
        boolean enable = LbUtils.getBoolenParameter("include-enable-schema");
        boolean privs = LbUtils.getBoolenParameter("include-privs");
        CallableStatement stmt = null;
        try {
            String ordsQuery = "begin ? := ords_metadata.ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
            stmt = this.conn.prepareCall(ordsQuery);
            stmt.registerOutParameter(1, 2005);
            stmt.setInt(2, enable ? 0 : 1);
            stmt.setInt(3, privs ? 0 : 1);
            stmt.execute();
            Clob script = stmt.getClob(1);
            LbUtils.setParameter("object-name", "ORDS");
            LbUtils.setParameter("object-type", "SCRIPT");
            LbUtils.setParameter("ddl", LiquibaseStringUtils.clobToString(script));
            String string = this.getChangeLog();
            return string;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void cleanDdlParam() throws DatabaseException, ObjectNotFoundException {
        String ddl = LbUtils.getParameter("ddl");
        if (!(ddl != null && !ddl.isEmpty() || (ddl = DbmsMetaUtils.getObjectFromDb(this.conn, LbUtils.getParameter("object-type"), LbUtils.getParameter("object-name"))) != null && ddl.length() != 0)) {
            throw new ObjectNotFoundException(Messages.getString("LB_NO_OBJECT"));
        }
        if ("JOB".equalsIgnoreCase(LbUtils.getParameter("object-type"))) {
            ddl = ddl.replaceAll("\"", "");
        }
        if ("JOB".equalsIgnoreCase(LbUtils.getParameter("object-type")) && ddl.toUpperCase().contains("CREATE_PROGRAM")) {
            ddl = ddl.replaceFirst("BEGIN", Matcher.quoteReplacement(ddl));
        }
        if ("TRIGGER".equalsIgnoreCase(LbUtils.getParameter("object-type"))) {
            ddl = ddl.replace("\n\n/", "\n/");
        }
        LbUtils.setParameter("ddl", ddl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCaptureTable(StringBuilder sb) throws SQLException, UnknownPropertySetNameException, DatabaseException {
        StopWatch stopWatch = new StopWatch("Method cleanupCaptureTable", sb);
        String queryCaptureTableRecursion = QueryUtils.getXMLQueries().getQuery("queryCaptureTableRecursion", this.conn).getSql();
        String getRefConstraints = QueryUtils.getXMLQueries().getQuery("getRefConstraints", this.conn).getSql();
        PreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = this.conn.prepareStatement(queryCaptureTableRecursion);
            rs = pstatement.executeQuery();
            while (rs.next()) {
                ExportRec expRec = new ExportRec(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getClob(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getInt(8));
                HashMap ddls = LbUtils.getContext().getParameterInstance().getParameters("ddl.parms");
                for (String key : ddls.keySet()) {
                    SetDDLSettings.setDDLParameter((Connection)this.conn, (String)key, (String)ddls.get(key).toString());
                }
                SetDDLSettings.setDDLParameter((Connection)this.conn, (String)"REF_CONSTRAINTS", (String)SetDDLSettings.SET_DDL_OPTIONS.OFF.toString());
                expRec.setSource(DbmsMetaUtils.getObjectFromDb(this.conn, expRec.getObjType(), expRec.getObjName()));
                SetDDLSettings.setDDLParameter((Connection)this.conn, (String)"REF_CONSTRAINTS", (String)SetDDLSettings.SET_DDL_OPTIONS.ON.toString());
                HashMap<String, String> binds = new HashMap<String, String>();
                binds.put("ONAME", expRec.getObjName());
                ExportRec rRec = new ExportRec(expRec);
                rRec.setSeq(rRec.getSeq() * -1);
                rRec.setObjType("REF_CONSTRAINT");
                rRec.setSource(dbUtil.executeReturnOneCol(getRefConstraints, binds));
                rRec.setRank(100);
                rRec.setObjName(expRec.getObjName() + "_RC");
                rRec.setFileName(expRec.getObjName() + "_REF_CONSTRAINTS.xml");
                rRec = this.loadDeps(rRec);
                rRec.createRec();
                expRec.setDeps("");
                expRec.setDepCount(0);
                expRec.updateBySeq();
            }
        }
        catch (Exception e) {
            LbUtils.report(e);
        }
        finally {
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stopWatch.end(sb);
    }

    private String genControllerFooter() {
        return "</databaseChangeLog> \n";
    }

    private String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + ApexUtils.commentParamSettings("ddl.parms", ApexUtils.Position.TOP) + "\n" + ApexUtils.commentParamSettings("lb.parameters", ApexUtils.Position.BOTTOM) + "\n<databaseChangeLog \n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n";
    }

    private String genControllerInclude(String filename) {
        String cleanFileName = filename;
        if (filename.contains(LbUtils.getContext().prependCD(""))) {
            cleanFileName = filename.replace(LbUtils.getContext().prependCD(""), "");
        }
        String include = "  <include file=\"%FILE%\"/> \n";
        return LiquibaseStringUtils.replaceVal("%FILE%", cleanFileName, "  <include file=\"%FILE%\"/> \n");
    }

    private String getComments(String oName) throws IOException, SQLException {
        String querycomments = QueryUtils.getXMLQueries().getQuery("querycomments", this.conn).getSql();
        String ddlSetup = QueryUtils.getXMLQueries().getQuery("ddlSetup", this.conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Object clob;
            stmt = this.conn.prepareStatement(ddlSetup);
            stmt.executeQuery();
            stmt.close();
            stmt = this.conn.prepareStatement(querycomments);
            stmt.setString(1, oName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                clob = rs.getClob(1);
                String sql = LiquibaseStringUtils.clobToString((Clob)clob);
                sb.append(sql);
            }
            if (sb.toString().length() <= 0) {
                clob = null;
                return clob;
            }
            clob = sb.toString();
            return clob;
        }
        catch (SQLException e1) {
            if (e1.getErrorCode() == 31608) {
                String string = null;
                return string;
            }
            throw e1;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private final String getSha1fromString(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCaptureTable(StringBuilder sb) throws SQLException {
        ScriptRunnerContext ctx = LbUtils.getContext();
        boolean pubSyns = LbUtils.getBoolenParameter("synonyms");
        boolean grants = LbUtils.getBoolenParameter("grants");
        String filter = LbUtils.getParameter("filter");
        StopWatch stopWatch = new StopWatch("Method loadCaptureTable", sb);
        String callLoadCapture = QueryUtils.getXMLQueries().getQuery("callLoadCapture", this.conn).getSql();
        String key = "";
        try (CallableStatement statement = this.conn.prepareCall(callLoadCapture);){
            LinkedHashMap<String, Integer> ordered_types = ordered_types_short;
            for (Map.Entry<String, Integer> entry : ordered_types.entrySet()) {
                key = entry.getKey();
                if ("PUBLIC_SYNONYM".equals(key) && !pubSyns || ("OBJECT_GRANT".equals(key) || "SYSTEM_GRANT".equals(key) || "ROLE_GRANT".equals(key)) && !grants) continue;
                Integer rank = entry.getValue();
                statement.setString("otype", key);
                statement.setInt("rank", (int)rank);
                if (ctx.getParameterInstance().getParameters("ddl.parms") != null) {
                    statement.setString("inherit", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("INHERIT"));
                    statement.setString("sqlterminator", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("SQLTERMINATOR"));
                    statement.setString("specification", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("SPECIFICATION"));
                    statement.setString("size_byte_keyword", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("SIZE_BYTE_KEYWORD"));
                    statement.setString("pretty", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("PRETTY"));
                    statement.setString("force", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("FORCE"));
                    statement.setString("inserts", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("INSERT"));
                    statement.setString("body", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("BODY"));
                    statement.setString("constraints_as_alter", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("CONSTRAINTS_AS_ALTER"));
                    statement.setString("ref_constraints", (String)ctx.getParameterInstance().getParameters("ddl.parms").get("REF_CONSTRAINTS"));
                    if (filter != null) {
                        statement.setString("filter", filter.replaceAll("\"", ""));
                    } else {
                        statement.setString("filter", filter);
                    }
                }
                statement.execute();
                stopWatch.split("Type - " + key, sb);
            }
        }
        finally {
            stopWatch.end(sb);
        }
    }

    private ExportRec loadDeps(ExportRec expRec) throws SQLException, IOException {
        SqlRecognizer recognizer = new SqlRecognizer(expRec.getDDL());
        List names = recognizer.getObjectNames();
        List deps = recognizer.getReferencedTypes();
        LinkedList<String> cleandep = new LinkedList<String>();
        if (names != null && names.size() > 0) {
            expRec.setObjName(((String)names.get(0)).replaceAll("\"", ""));
        }
        for (String dep : deps) {
            dep = dep.toUpperCase().replace("\"", "");
            cleandep.add(dep);
        }
        String depList = Joiner.on((String)",").join(cleandep);
        if (depList.length() > 4000) {
            depList = depList.substring(0, 4000);
            depList = depList.substring(0, depList.lastIndexOf(","));
        }
        expRec.setDeps(depList);
        expRec.setDepCount(deps.size());
        return expRec;
    }

    private void processCaptureTable(StringBuilder sb) throws SQLException, IOException {
        StopWatch stopWatch = new StopWatch("Method processCaptureTable", sb);
        String queryCaptureTable = QueryUtils.getXMLQueries().getQuery("queryCaptureTable", this.conn).getSql();
        String checkRecursion = QueryUtils.getXMLQueries().getQuery("callCheckRecursion", this.conn).getSql();
        PreparedStatement pstatement = this.conn.prepareStatement(queryCaptureTable);
        ResultSet rs = pstatement.executeQuery();
        int counter = 0;
        int badFile = 0;
        while (rs.next()) {
            ExportRec expRec = new ExportRec(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getClob(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getInt(8));
            if ((expRec = this.loadDeps(expRec)).getObjName() != null) {
                expRec.setFileName((expRec.getObjName() + "_" + expRec.getObjType() + ".xml").toLowerCase());
            } else if ("REF_CONSTRAINT".equals(expRec.getObjType()) || "ROLE_GRANT".equals(expRec.getObjType()) || "OBJECT_GRANT".equals(expRec.getObjType()) || "SYSTEM_GRANT".equals(expRec.getObjType()) || "MATERIALIZED_VIEW_LOG".equals(expRec.getObjType())) {
                expRec.setObjName(expRec.getObjType().toLowerCase() + counter);
                expRec.setFileName((expRec.getObjType() + "_" + counter++ + ".xml").toLowerCase());
            } else {
                expRec.setFileName((expRec.getObjType() + "_NOPARSE_" + badFile++ + ".xml").toLowerCase());
                this.no_parse_files.add(expRec.getFileName());
            }
            expRec.updateBySeq();
            if (expRec.getObjName() == null || !"TABLE".equalsIgnoreCase(expRec.getObjType()) && !"VIEW".equalsIgnoreCase(expRec.getObjType())) continue;
            ExportRec cRec = new ExportRec();
            cRec.setRank(65);
            cRec.setSeq(expRec.getSeq());
            String comments = this.getComments(expRec.getObjName());
            if (comments == null) continue;
            cRec.setFileName((expRec.getObjName() + "_comments.xml").toLowerCase());
            cRec.setObjName(expRec.getObjName() + "_COMMENTS");
            cRec.setSource(comments);
            cRec.setObjType("COMMENT");
            cRec.setDeps(expRec.getObjName());
            cRec.setDepCount(1);
            cRec.createRec();
        }
        CallableStatement statement = this.conn.prepareCall(checkRecursion);
        statement.execute();
        stopWatch.end(sb);
    }

    private void sortCaptureTable(StringBuilder sb) throws SQLException {
        StopWatch stopWatch = new StopWatch("Method sortCaptureTable", sb);
        String query = QueryUtils.getXMLQueries().getQuery("callSortCapture", this.conn).getSql();
        try (CallableStatement statement = this.conn.prepareCall(query);){
            statement.execute();
            stopWatch.end(sb);
        }
        catch (SQLException e) {
            try {
                this.conn.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            LbUtils.log(e);
            throw e;
        }
    }

    static {
        ddlChangeTypes = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("CONSTRAINT", "createOracleConstraint");
                this.put("REF_CONSTRAINT", "createOracleRefConstraint");
                this.put("DIMENSION", "createOracleDimension");
                this.put("FUNCTION", "createOracleFunction");
                this.put("PROCEDURE", "createOracleProcedure");
                this.put("PACKAGE_SPEC", "createOraclePackageSpec");
                this.put("PACKAGE_BODY", "createOraclePackageBody");
                this.put("TYPE_SPEC", "createOracleTypeSpec");
                this.put("TYPE_BODY", "createOracleTypeBody");
                this.put("PUBLIC_SYNONYM", "createOraclePublicSynonym");
                this.put("SYNONYM", "createOracleSynonym");
                this.put("OBJECT_GRANT", "createOracleGrant");
                this.put("DB_LINK", "createOracleDbLink");
                this.put("TRIGGER", "createOracleTrigger");
                this.put("JOB", "createOracleJob");
                this.put("DIRECTORY", "createOracleDirectory");
                this.put("COMMENT", "createOracleComment");
            }
        };
        ordered_types_short = new LinkedHashMap<String, Integer>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("TYPE_SPEC", 10);
                this.put("TYPE_BODY", 13);
                this.put("SEQUENCE", 15);
                this.put("DIRECTORY", 17);
                this.put("CLUSTER", 19);
                this.put("TABLE", 21);
                this.put("MATERIALIZED_VIEW_LOG", 23);
                this.put("MATERIALIZED_VIEW", 25);
                this.put("VIEW", 27);
                this.put("DIMENSION", 31);
                this.put("FUNCTION", 33);
                this.put("PROCEDURE", 35);
                this.put("PACKAGE_SPEC", 37);
                this.put("DB_LINK", 39);
                this.put("SYNONYM", 41);
                this.put("INDEX", 42);
                this.put("TRIGGER", 45);
                this.put("PACKAGE_BODY", 47);
                this.put("JOB", 49);
                this.put("PUBLIC_SYNONYM", 51);
                this.put("OBJECT_GRANT", 53);
            }
        };
        ordered_types_long = new LinkedHashMap<String, Integer>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("TYPE_SPEC", 10);
                this.put("TYPE_BODY", 13);
                this.put("SEQUENCE", 15);
                this.put("DIRECTORY", 17);
                this.put("CLUSTER", 19);
                this.put("TABLE", 21);
                this.put("MATERIALIZED_VIEW_LOG", 23);
                this.put("MATERIALIZED_VIEW", 25);
                this.put("VIEW", 27);
                this.put("REF_CONSTRAINT", 29);
                this.put("DIMENSION", 31);
                this.put("FUNCTION", 33);
                this.put("PROCEDURE", 35);
                this.put("PACKAGE_SPEC", 37);
                this.put("DB_LINK", 39);
                this.put("SYNONYM", 41);
                this.put("INDEX", 42);
                this.put("TRIGGER", 45);
                this.put("PACKAGE_BODY", 47);
                this.put("JOB", 49);
                this.put("PUBLIC_SYNONYM", 51);
                this.put("OBJECT_GRANT", 53);
            }
        };
        typeNameTransform = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("PACKAGE_SPEC", "PACKAGE");
                this.put("PACKAGE_BODY", "PACKAGE BODY");
                this.put("TYPE_SPEC", "TYPE");
                this.put("TYPE_BODY", "TYPE BODY");
                this.put("MATERIALIZED_VIEW_LOG", "MATERIALIZED VIEW LOG");
                this.put("MATERIALIZED_VIEW", "MATERIALIZED VIEW");
                this.put("DB_LINK", "DATABASE LINK");
                this.put("PUBLIC_SYNONYM", "PUBLIC SYNONYM");
            }
        };
    }

    protected class ExportRec {
        int rank;
        String oType;
        int seq;
        Clob source;
        String oName;
        String fName;
        String deps;
        int dep_count;

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public String getObjType() {
            return this.oType;
        }

        public void setObjType(String oType) {
            this.oType = oType;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public Clob getSource() {
            return this.source;
        }

        public void setSource(String source) throws SQLException {
            Clob sourceClob = SchemaGenerator.this.conn.createClob();
            sourceClob.setString(1L, source);
            this.source = sourceClob;
        }

        public void setSource(Clob source) {
            this.source = source;
        }

        public String getObjName() {
            return this.oName;
        }

        public void setObjName(String oName) {
            this.oName = oName;
        }

        public String getFileName() {
            return this.fName;
        }

        public void setFileName(String fName) {
            this.fName = fName;
        }

        public String getDeps() {
            return this.deps;
        }

        public void setDeps(String deps) {
            this.deps = deps;
        }

        public int getDepCount() {
            return this.dep_count;
        }

        public void setDepCount(int dep_count) {
            this.dep_count = dep_count;
        }

        public ExportRec() {
        }

        public ExportRec(int rank, String oType, int seq, Clob source, String oName, String fName, String deps, int dep_count) {
            this.rank = rank;
            this.oType = oType;
            this.seq = seq;
            this.source = source;
            this.oName = oName;
            this.fName = fName;
            this.deps = deps;
            this.dep_count = dep_count;
        }

        public ExportRec(int rank, String oType, int seq, Clob source, String oName, String fName) {
            this.rank = rank;
            this.oType = oType;
            this.seq = seq;
            this.source = source;
            this.oName = oName;
            this.fName = fName;
        }

        public ExportRec(ExportRec rec) {
            this.rank = rec.getRank();
            this.oType = rec.getObjType();
            this.seq = rec.getSeq();
            this.source = rec.getSource();
            this.oName = rec.getObjName();
            this.fName = rec.getFileName();
            this.deps = rec.getDeps();
            this.dep_count = rec.getDepCount();
        }

        public void createRec() throws SQLException {
            String insertCaptureTable = QueryUtils.getXMLQueries().getQuery("insertCaptureTable", SchemaGenerator.this.conn).getSql();
            try (PreparedStatement insert = SchemaGenerator.this.conn.prepareStatement(insertCaptureTable);){
                insert.setInt(1, this.rank);
                insert.setString(2, this.oType);
                insert.setInt(3, this.seq);
                insert.setClob(4, this.source);
                insert.setString(5, this.oName);
                insert.setString(6, this.fName);
                insert.setString(7, this.deps);
                insert.setInt(8, this.dep_count);
                insert.executeUpdate();
                try {
                    SchemaGenerator.this.conn.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                LbUtils.log(e);
                try {
                    SchemaGenerator.this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
        }

        public String getDDL() throws SQLException, IOException {
            if (ddlChangeTypes.containsKey(this.oType)) {
                return LiquibaseStringUtils.trim(LiquibaseStringUtils.clobToString(this.source)).replace("REFERENCING FOR EACH ROW", "");
            }
            return DbmsMetaUtils.getDdlFromSxml(SchemaGenerator.this.conn, this.source.getSubString(1L, (int)this.source.length()).trim(), this.oType);
        }

        public void updateBySeq() throws SQLException {
            String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTablebySeq", SchemaGenerator.this.conn).getSql();
            try (PreparedStatement update = SchemaGenerator.this.conn.prepareStatement(updateCaptureTable);){
                update.setClob(1, this.source);
                update.setString(2, this.oName);
                update.setString(3, this.fName);
                update.setString(4, this.deps);
                update.setInt(5, this.dep_count);
                update.setString(6, this.oType);
                update.setInt(7, this.seq);
                update.executeUpdate();
                try {
                    SchemaGenerator.this.conn.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                LbUtils.log(e);
                try {
                    SchemaGenerator.this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
        }

        public void updateByName() throws SQLException {
            String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTablebyName", SchemaGenerator.this.conn).getSql();
            try (PreparedStatement update = SchemaGenerator.this.conn.prepareStatement(updateCaptureTable);){
                update.setInt(1, this.seq);
                update.setClob(2, this.source);
                update.setString(3, this.fName);
                update.setString(4, this.deps);
                update.setInt(5, this.dep_count);
                update.setString(6, this.oType);
                update.setString(7, this.oName);
                update.executeUpdate();
                try {
                    SchemaGenerator.this.conn.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                LbUtils.log(e);
                try {
                    SchemaGenerator.this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }
}

