/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.changelog.visitor.OracleActionChangeListener;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.util.StringUtil;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.exception.CreateDirectoryException;
import oracle.dbtools.raptor.liquibase.exception.NoRollbackException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.ApexUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.DateTimeValidator;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class CommandGenerator {
    public static final String APEX_PARMS = "apex.parms";

    public static String CalculateCheckSumCommand() throws Exception {
        return (String)Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                CheckSum checkSum = null;
                if (LbUtils.getParameter("changeset-identifier") != null && LbUtils.getParameter("changeset-identifier") != "") {
                    checkSum = lb.calculateCheckSum(LbUtils.getParameter("changeset-identifier"));
                }
                lb.close();
                CommandGenerator.clearSystemProps();
                return checkSum.toString();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void ChangeLogSyncCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                if ("".equals(LbUtils.getParameter("tag"))) {
                    lb.changeLogSync(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                } else {
                    lb.changeLogSync(LbUtils.getParameter("tag"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                }
                ((JdbcConnection)lb.getDatabase().getConnection()).getUnderlyingConnection().commit();
                lb.getDatabase().commit();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String ChangeLogSyncSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        return (String)Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                if ("".equals(LbUtils.getParameter("tag"))) {
                    lb.changeLogSync(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                } else {
                    lb.changeLogSync(LbUtils.getParameter("tag"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                }
                lb.close();
                CommandGenerator.clearSystemProps();
                if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
                    String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), out.toString());
                    return Messages.format("CHANGELOG_GENERATED", file);
                }
                return out.toString();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void ClearCheckSumsCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                lb.clearCheckSums();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String DataCommand() throws Exception {
        Charset charset = StandardCharsets.UTF_8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, charset.name());
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                DiffOutputControl diffOutputControl = new DiffOutputControl();
                diffOutputControl.setObjectChangeFilter(CommandGenerator.getObjectChangeFilter());
                diffOutputControl.setIncludeCatalog(false);
                diffOutputControl.setIncludeTablespace(false);
                diffOutputControl.setIncludeSchema(false);
                DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffOutputControl);
                lb.generateChangeLog(new CatalogAndSchema(LbUtils.getParameter("default-catalog-name"), LbUtils.getParameter("default-schema-name")), diffToChangeLog, ps, (Class[])CommandGenerator.getSnapshotTypes("data"));
                ps.flush();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
            finally {
                ps.close();
            }
        });
        String ret = new String(baos.toByteArray(), charset);
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String DbDocCommand() throws Exception {
        StringBuilder out = new StringBuilder();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                Object dir = LbUtils.getParameter("output-directory").replaceFirst("^~", System.getProperty("user.home"));
                if (!Paths.get((String)dir, new String[0]).isAbsolute()) {
                    dir = LbUtils.getContext().prependCD("") + (String)dir;
                }
                Path out_dir = Paths.get((String)dir, new String[0]);
                lb.generateDocumentation(out_dir.toString(), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                out.append(MessageFormat.format(Messages.getString("LB_DBDOC_DONE"), ".".equals(LbUtils.getParameter("output-directory")) || "".equals(LbUtils.getParameter("output-directory")) ? "current directory" : LbUtils.getParameter("output-directory")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        return out.toString();
    }

    public static String DiffChangelogCommand() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
        HashMap setDDLs = LbUtils.getContext().getParameterInstance().getParameters("ddl.parms");
        Database sourceDb = CommandGenerator.getSourceDb();
        Connection sConn = ((JdbcConnection)sourceDb.getConnection()).getUnderlyingConnection();
        Database targetDb = CommandGenerator.getTargetDb();
        Connection tConn = ((JdbcConnection)targetDb.getConnection()).getUnderlyingConnection();
        for (Map.Entry setDDL : setDDLs.entrySet()) {
            QueryUtils.setDDLParameter(sConn, (String)setDDL.getKey(), (String)setDDL.getValue());
            QueryUtils.setDDLParameter(tConn, (String)setDDL.getKey(), (String)setDDL.getValue());
        }
        QueryUtils.setDDLParameter(sConn, "INSERT", "OFF");
        QueryUtils.setDDLParameter(tConn, "INSERT", "OFF");
        QueryUtils.setDDLParameter(sConn, "CONSTRAINTS_AS_ALTER", "OFF");
        QueryUtils.setDDLParameter(tConn, "CONSTRAINTS_AS_ALTER", "OFF");
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                DiffResult diffResult = lb.diff(sourceDb, targetDb, new CompareControl(CommandGenerator.getSnapshotTypesSet(LbUtils.getParameter("diff-types"))));
                DiffOutputControl diffOutputControl = new DiffOutputControl();
                diffOutputControl.setObjectChangeFilter(CommandGenerator.getObjectChangeFilter());
                diffOutputControl.setIncludeCatalog(false);
                diffOutputControl.setIncludeTablespace(false);
                diffOutputControl.setIncludeSchema(false);
                DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
                diffToChangeLog.print(printStream);
                printStream.close();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        targetDb.close();
        sourceDb.close();
        String ret = out.toString("UTF-8");
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String DiffCommand() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
        HashMap setDDLs = LbUtils.getContext().getParameterInstance().getParameters("ddl.parms");
        Database sourceDb = CommandGenerator.getSourceDb();
        Connection sConn = ((JdbcConnection)sourceDb.getConnection()).getUnderlyingConnection();
        Database targetDb = CommandGenerator.getTargetDb();
        Connection tConn = ((JdbcConnection)targetDb.getConnection()).getUnderlyingConnection();
        for (Map.Entry setDDL : setDDLs.entrySet()) {
            QueryUtils.setDDLParameter(sConn, (String)setDDL.getKey(), (String)setDDL.getValue());
            QueryUtils.setDDLParameter(tConn, (String)setDDL.getKey(), (String)setDDL.getValue());
        }
        QueryUtils.setDDLParameter(sConn, "INSERT", "OFF");
        QueryUtils.setDDLParameter(tConn, "INSERT", "OFF");
        QueryUtils.setDDLParameter(sConn, "CONSTRAINTS_AS_ALTER", "OFF");
        QueryUtils.setDDLParameter(tConn, "CONSTRAINTS_AS_ALTER", "OFF");
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                DiffResult diffResult = lb.diff(sourceDb, targetDb, new CompareControl(CommandGenerator.getSnapshotTypesSet(LbUtils.getParameter("diff-types"))));
                DiffToReport diffToReport = new DiffToReport(diffResult, printStream);
                diffToReport.print();
                printStream.close();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        targetDb.close();
        sourceDb.close();
        String ret = out.toString("UTF-8");
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static void DropAllCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                lb.dropAll();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String FutureRollbackCountSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.futureRollbackSQL(Integer.valueOf(LbUtils.getIntParameter("count")), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String FutureRollbackSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.futureRollbackSQL(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String FutureRollbackTagSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                lb.futureRollbackSQL(LbUtils.getParameter("tag"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String GenerateApexObjectCommand(Connection conn) throws DatabaseException, NoSuchAlgorithmException, AppNotInstalledException, SQLException, IOException, InvalidParameterException, CreateDirectoryException, ObjectNotFoundException, InvalidApexExportException, OutputBufferNotInitialized {
        CommandGenerator.cloneParmsToApex();
        LinkedHashMap<String, APEXExport.RowDetails> changes = CommandGenerator.getApexChangeLogs(conn);
        LinkedList<String> cKeys = new LinkedList<String>(changes.keySet());
        LinkedList<APEXExport.RowDetails> install_files = new LinkedList<APEXExport.RowDetails>();
        APEXExport.RowDetails lastRow = changes.get(cKeys.get(0));
        File file = null;
        for (String key : changes.keySet()) {
            APEXExport.RowDetails curRow = changes.get(key);
            if (key.equals(LBOptions.DEFAULT_SCREEN_OUTPUT_NAME)) continue;
            file = LbFileUtils.getFile(LbUtils.getContext(), key, false);
            changes.get(key).setFileName(file.toString());
            LbFileUtils.writeFile(LbUtils.getContext(), file.toString(), changes.get(key).getContents());
            if (lastRow.getWorkId() != curRow.getWorkId()) {
                install_files.add(lastRow);
            }
            lastRow = curRow;
        }
        install_files.add(lastRow);
        return Messages.format("FILE_GENERATED", LbFileUtils.writeFile(LbUtils.getContext(), LBOptions.APEX_CONTROLLER_NAME, ApexUtils.genApexController(install_files, conn)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GenerateChangelogCommand() throws Exception {
        Charset charset = StandardCharsets.UTF_8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, charset.name());
        DiffOutputControl diffOutputControl = new DiffOutputControl(LbUtils.getBoolenParameter("include-catalog"), LbUtils.getBoolenParameter("include-schema"), LbUtils.getBoolenParameter("include-tablespace"), new CompareControl(CommandGenerator.getSnapshotTypesSet(LbUtils.getParameter("diff-types"))).getSchemaComparisons());
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffOutputControl);
        if (LbUtils.getParameter("data-output-directory") != null && LbUtils.getParameter("data-output-directory") != "") {
            diffOutputControl.setDataDir(LbUtils.getParameter("data-output-directory"));
        }
        try {
            Scope.child(CommandGenerator.getParameters(), () -> {
                Liquibase lb = null;
                try {
                    lb = CommandGenerator.GetLiquibase(null, LbUtils.getContext().prependCD(""), false, false);
                    lb.generateChangeLog(new CatalogAndSchema(LbUtils.getParameter("default-catalog-name"), LbUtils.getParameter("default-schema-name")), diffToChangeLog, ps, (Class[])CommandGenerator.getSnapshotTypes(LbUtils.getParameter("diff-types")));
                    ps.flush();
                    lb.close();
                    CommandGenerator.clearSystemProps();
                }
                catch (Exception e) {
                    if (lb != null) {
                        lb.close();
                    }
                    CommandGenerator.clearSystemProps();
                    throw e;
                }
            });
            if (LbUtils.getParameter("changelog-file") != null && !"".equals(LbUtils.getParameter("changelog-file"))) {
                String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("changelog-file"), new String(baos.toByteArray(), charset));
                String string = Messages.format("CHANGELOG_GENERATED", file);
                return string;
            }
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
        finally {
            ps.close();
        }
    }

    public static String GenerateControlFileCommand() throws LiquibaseException, IOException {
        StringWriter out = new StringWriter();
        Path path = LbFileUtils.getPath(LbUtils.getContext(), LbUtils.getParameter("changelog-file"), false);
        SchemaGenerator.writeMasterLog(path);
        out.append(Messages.format("CONTROLLER_CREATED", path.toString()));
        return out.toString();
    }

    public static String GenerateDbObjectCommand(Connection conn) throws DatabaseException, NoSuchAlgorithmException, SQLException, IOException, ObjectNotFoundException {
        if ("PACKAGE".equals(LbUtils.getParameter("object-type"))) {
            LbUtils.setParameter("object-type", "PACKAGE_SPEC");
        }
        SchemaGenerator gen = new SchemaGenerator(conn);
        String change = gen.getChangeLog();
        String fileName = (LbUtils.getParameter("object-name") + "_" + LbUtils.getParameter("object-type") + ".XML").toLowerCase();
        return LbFileUtils.writeFile(LbUtils.getContext(), fileName, change);
    }

    public static String GenerateOrdsModuleCommand(Connection conn) throws DatabaseException, NoSuchAlgorithmException, SQLException, IOException, ObjectNotFoundException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        String change = gen.getOrdsModuleChangeLog();
        String module = LbUtils.getParameter("module-name");
        String fileName = "ords_rest_module_" + module + ".xml";
        return Messages.format("FILE_GENERATED", LbFileUtils.writeFile(LbUtils.getContext(), fileName, change));
    }

    public static String GenerateOrdsSchemaCommand(Connection conn) throws DatabaseException, NoSuchAlgorithmException, SQLException, IOException, ObjectNotFoundException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        String change = gen.getOrdsSchemaChangeLog();
        String fileName = "ords_rest_schema.xml";
        return Messages.format("FILE_GENERATED", LbFileUtils.writeFile(LbUtils.getContext(), "ords_rest_schema.xml", change));
    }

    public static HashMap<String, Object> GenerateSchemaCommand(Connection conn) throws Exception {
        SchemaGenerator gen = new SchemaGenerator(conn);
        return gen.doSchemaExport(true);
    }

    public static Liquibase GetLiquibase(String changelog, String cwd, boolean checkActionLogTable, boolean showCount) throws Exception {
        String fileName;
        ArrayList<File> list = new ArrayList<File>();
        String rPath = "";
        Path cDir = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toAbsolutePath();
        list.add(cDir.toFile());
        if (changelog != null) {
            Path cLog = cDir.resolve((changelog = LiquibaseStringUtils.trim(changelog)).trim());
            if (!list.contains(cLog.getParent().toFile())) {
                list.add(cLog.getParent().toFile());
            }
            fileName = changelog.trim();
        } else {
            fileName = null;
        }
        StandardParameter sp = LBOptions.SEARCH_PATH_P;
        Class clazz = sp.getValidator();
        try {
            if (LbUtils.getParameter("search-path") != null && !"".equals(LbUtils.getParameter("search-path"))) {
                AbstractValidatorService validator = (AbstractValidatorService)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                validator.setupValidator(sp.isNullable(), sp.getAllowed(), sp.getDateFormat(), "search-path", LbUtils.getContext());
                validator.validate(LbUtils.getParameter("search-path").replaceAll("\"", ""));
                List paths = validator.StringToTypeList(LbUtils.getParameter("search-path").replaceAll("\"", ""));
                for (Object s : paths) {
                    try {
                        Path p = cDir.resolve(s.toString());
                        list.add(p.toFile());
                    }
                    catch (Exception p) {}
                }
            }
        }
        catch (Exception paths) {
            // empty catch block
        }
        File[] mypaths = new File[list.size()];
        ArrayList deDup = CommandGenerator.removeDuplicates(list);
        deDup.toArray(mypaths);
        String dir = "";
        SearchPathResourceAccessor spa = new SearchPathResourceAccessor(new ResourceAccessor[0]);
        for (File f : mypaths) {
            try {
                dir = f.toString();
                dir = dir.replaceAll("\\\\", "/");
                spa.addResourceAccessor(dir);
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) continue;
                LbUtils.getContext().write("search-dir path not found: " + dir + System.lineSeparator());
            }
        }
        Liquibase liquibase = null;
        JdbcConnection conn = CommandGenerator.cloneActiveConn();
        HashMap<String, Object> parms = CommandGenerator.getParameters();
        for (String key : parms.keySet()) {
            System.setProperty(key, parms.get(key).toString());
        }
        try {
            liquibase = new Liquibase(fileName, (ResourceAccessor)spa, (DatabaseConnection)conn);
        }
        catch (Exception e) {
            conn.close();
            liquibase.close();
        }
        liquibase.setChangeExecListener((ChangeExecListener)new OracleActionChangeListener());
        liquibase.setChangeLogSyncListener((ChangeLogSyncListener)new OracleActionChangeListener());
        for (String key : parms.keySet()) {
            liquibase.setChangeLogParameter(key, parms.get(key));
        }
        if (LbUtils.getParameter("liquibase-schema-name") != null && !"".equals(LbUtils.getParameter("liquibase-schema-name"))) {
            liquibase.getDatabase().setDefaultSchemaName(LbUtils.getParameter("liquibase-schema-name"));
            liquibase.getDatabase().setDefaultCatalogName(LbUtils.getParameter("liquibase-schema-name"));
        }
        if (LbUtils.getParameter("database-changelog-table-name") != null && !"".equals(LbUtils.getParameter("database-changelog-table-name"))) {
            liquibase.getDatabase().setDatabaseChangeLogTableName(LbUtils.getParameter("database-changelog-table-name"));
            liquibase.getDatabase().setDatabaseChangeLogLockTableName(LbUtils.getParameter("database-changelog-table-name") + "LOCK");
        }
        if (LbUtils.getParameter("output-default-schema") != null && !"".equals(LbUtils.getParameter("output-default-schema"))) {
            liquibase.getDatabase().setOutputDefaultSchema(LbUtils.getBoolenParameter("output-default-schema"));
        }
        if (checkActionLogTable) {
            LockService lockService = LockServiceFactory.getInstance().getLockService(liquibase.getDatabase());
            lockService.init();
            ActionLogTableManager tm = new ActionLogTableManager(liquibase.getDatabase());
            tm.createUpdateLogTable();
        }
        try {
            if (showCount) {
                if (liquibase.getDatabaseChangeLog() != null && liquibase.getDatabaseChangeLog().getChangeSets() != null) {
                    LbUtils.report("-- Loaded " + liquibase.getDatabaseChangeLog().getChangeSets().size() + " change(s)");
                } else {
                    LbUtils.report("-- Loaded no changes");
                }
            }
        }
        catch (LiquibaseException e) {
            if (liquibase.getResourceAccessor() != null) {
                SearchPathResourceAccessor ra = (SearchPathResourceAccessor)liquibase.getResourceAccessor();
                List paths = ra.describeLocations();
                rPath = String.join((CharSequence)",", paths);
            }
            String pathMsg = "path: " + System.lineSeparator() + rPath.replaceAll(",", "," + System.lineSeparator()) + System.lineSeparator();
            String eMessage = e.getMessage().trim();
            String message = eMessage.replace("path:\n", pathMsg);
            liquibase.close();
            throw new ChangeLogParseException(message);
        }
        liquibase.setChangeLogParameter("sqlclversion", (Object)LbUtils.getParameter("sqlclversion"));
        LbUtils.setLiquibase(liquibase);
        return liquibase;
    }

    public static String HistoryCommand() throws Exception {
        return (String)Scope.child(CommandGenerator.getParameters(), () -> {
            StringWriter sw = new StringWriter();
            PrintWriter output = new PrintWriter(sw);
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                Database database = lb.getDatabase();
                ChangeLogHistoryService historyService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
                DeploymentHistory deploymentHistory = new DeploymentHistory();
                DeploymentDetails deployment = null;
                output.write("Liquibase History for " + database.getConnection().getURL());
                output.write(System.lineSeparator());
                for (RanChangeSet ranChangeSet : historyService.getRanChangeSets()) {
                    String thisDeploymentId = ranChangeSet.getDeploymentId();
                    if (deployment == null || !Objects.equals(thisDeploymentId, deployment.getDeploymentId())) {
                        if (deployment != null) {
                            deployment.printReport(output);
                        }
                        deployment = new DeploymentDetails();
                        deploymentHistory.deployments.add(deployment);
                    }
                    deployment.changeSets.add(ranChangeSet);
                }
                if (deployment == null) {
                    output.println("No changesets deployed");
                } else {
                    deployment.printReport(output);
                }
                output.flush();
                lb.close();
                CommandGenerator.clearSystemProps();
                return sw.toString();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String ListLocksCommand() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                lb.reportLocks(printStream);
                lb.close();
                CommandGenerator.clearSystemProps();
                printStream.flush();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        return out.toString();
    }

    public static void MarkNextChangesetRanCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.markNextChangeSetRan(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String MarkNextChangesetRanSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.markNextChangeSetRan(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static void ReleaseLocksCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                lb.forceReleaseLocks();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void RollbackCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.rollback(LbUtils.getParameter("tag"), LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                lb.close();
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void RollbackCountCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.rollback(LbUtils.getIntParameter("count"), LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                if (e.getMessage().contains("liquibase.exception.RollbackImpossibleException: No inverse to liquibase.ext.ora.change")) {
                    throw new NoRollbackException();
                }
                throw e;
            }
        });
    }

    public static String RollbackCountSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.rollback(LbUtils.getIntParameter("count"), LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String RollbackSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.rollback(LbUtils.getParameter("tag"), LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static void RollbackToDateCommand() throws Exception {
        SimpleDateFormat dtFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                Date date = dtFmt.parse(LbUtils.getParameter("date").replaceAll("\"", ""));
                lb.rollback(date, LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String RollbackToDateSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                StandardParameter sp = LBOptions.DATE_P;
                Class clazz = sp.getValidator();
                DateTimeValidator validator = (DateTimeValidator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                validator.setupValidator(sp.isNullable(), sp.getAllowed(), sp.getDateFormat(), "date", LbUtils.getContext());
                Date date = (Date)validator.getCleanParm(LbUtils.getParameter("date"));
                lb.rollback(date, LbUtils.getParameter("rollback-script"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String SnapShotCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                CommandScope snapshotCommand = new CommandScope(new String[]{"internalSnapshot"});
                snapshotCommand.addArgumentValue(InternalSnapshotCommandStep.DATABASE_ARG, (Object)lb.getDatabase()).addArgumentValue(InternalSnapshotCommandStep.SCHEMAS_ARG, (Object)InternalSnapshotCommandStep.parseSchemas((Database)lb.getDatabase(), (String[])new String[]{CommandGenerator.getSchema(lb.getDatabase())})).addArgumentValue(InternalSnapshotCommandStep.SERIALIZER_FORMAT_ARG, (Object)LbUtils.getParameter("snapshot-format"));
                CommandResults commandResults = snapshotCommand.execute();
                String result = InternalSnapshotCommandStep.printSnapshot((CommandScope)snapshotCommand, (CommandResults)commandResults);
                out.write(result);
                out.flush();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String SnapShotReferenceCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                CommandScope snapshotCommand = new CommandScope(new String[]{"internalSnapshot"});
                snapshotCommand.addArgumentValue(InternalSnapshotCommandStep.DATABASE_ARG, (Object)lb.getDatabase()).addArgumentValue(InternalSnapshotCommandStep.SCHEMAS_ARG, (Object)InternalSnapshotCommandStep.parseSchemas((Database)lb.getDatabase(), (String[])new String[]{CommandGenerator.getSchema(lb.getDatabase())})).addArgumentValue(InternalSnapshotCommandStep.SERIALIZER_FORMAT_ARG, (Object)LbUtils.getParameter("snapshot-format"));
                CommandResults commandResults = snapshotCommand.execute();
                String result = InternalSnapshotCommandStep.printSnapshot((CommandScope)snapshotCommand, (CommandResults)commandResults);
                out.write(result);
                out.flush();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String StatusCommand() throws Exception {
        return (String)Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                StringWriter out = new StringWriter();
                lb.reportStatus(LbUtils.getBoolenParameter("verbose"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
                return out.toString();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void TagCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, false);
                lb.tag(LbUtils.getParameter("tag"));
                LbUtils.getContext().write(Messages.format("LB_TAG_SUCCESS", LbUtils.getParameter("tag"), lb.getDatabase().getConnection().getURL()));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static boolean TagExistsCommand() throws Exception {
        return (Boolean)Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, false);
                if (lb.tagExists(LbUtils.getParameter("tag"))) {
                    lb.close();
                    CommandGenerator.clearSystemProps();
                    return true;
                }
                lb.close();
                CommandGenerator.clearSystemProps();
                return false;
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String UnexpectedChangessetsCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.reportUnexpectedChangeSets(LbUtils.getBoolenParameter("verbose"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static void UpdateCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                lb.update(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static void UpdateCountCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                lb.update(LbUtils.getIntParameter("count"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String UpdateCountSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.update(LbUtils.getIntParameter("count"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String UpdateSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.getDatabase().setOutputDefaultSchema(LbUtils.getBoolenParameter("output-default-schema"));
                lb.update(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String UpdateTestingRollbackCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.updateTestingRollback(new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static void UpdateToTagCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(true, true);
                lb.update(LbUtils.getParameter("tag"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")));
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
    }

    public static String UpdateToTagSqlCommand() throws Exception {
        StringWriter out = new StringWriter();
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.update(LbUtils.getParameter("tag"), new Contexts(LbUtils.getParameter("contexts")), new LabelExpression(LbUtils.getParameter("labels")), (Writer)out);
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        String ret = out.toString();
        if (LbUtils.getParameter("output-file") != null && !"".equals(LbUtils.getParameter("output-file"))) {
            String file = LbFileUtils.writeFile(LbUtils.getContext(), LbUtils.getParameter("output-file"), ret);
            return Messages.format("FILE_GENERATED", file);
        }
        return ret;
    }

    public static String ValidateCommand() throws Exception {
        Scope.child(CommandGenerator.getParameters(), () -> {
            Liquibase lb = null;
            try {
                lb = CommandGenerator.getLiquibase(false, true);
                lb.validate();
                lb.close();
                CommandGenerator.clearSystemProps();
            }
            catch (Exception e) {
                if (lb != null) {
                    lb.close();
                }
                CommandGenerator.clearSystemProps();
                throw e;
            }
        });
        return Messages.getString("VALIDATE_PASS");
    }

    private static void clearSystemProps() {
        try {
            HashMap<String, Object> parms = CommandGenerator.getParameters();
            for (String key : parms.keySet()) {
                System.clearProperty(key);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static JdbcConnection cloneActiveConn() throws DatabaseException {
        try {
            JdbcConnection sourceConn = new JdbcConnection(LbUtils.getContext().cloneCLIConnection());
            if (LbUtils.getParameter("default-schema-name") != null && LbUtils.getParameter("default-schema-name") != "") {
                sourceConn.getUnderlyingConnection().setSchema(LbUtils.getParameter("default-schema-name"));
                sourceConn.setCatalog(LbUtils.getParameter("default-schema-name"));
            }
            return sourceConn;
        }
        catch (Exception e) {
            return new JdbcConnection(LbUtils.getContext().getCurrentConnection());
        }
    }

    private static void cloneParmsToApex() {
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "applicationid", (Object)LbUtils.getParameter("applicationid"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "workspaceid", (Object)LbUtils.getParameter("workspaceid"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "instance", (Object)LbUtils.getParameter("instance"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expworkspace", (Object)LbUtils.getParameter("expworkspace"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expminimal", (Object)LbUtils.getParameter("expminimal"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expfiles", (Object)LbUtils.getParameter("expfiles"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "exptype", (Object)LbUtils.getParameter("exptype"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "skipexportdate", (Object)LbUtils.getParameter("skipexportdate"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "exppubreports", (Object)LbUtils.getParameter("exppubreports"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expsavedreports", (Object)LbUtils.getParameter("expsavedreports"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expirnotif", (Object)LbUtils.getParameter("expirnotif"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "exptranslations", (Object)LbUtils.getParameter("exptranslations"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expfeedback", (Object)LbUtils.getParameter("expfeedback"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expteamdevdata", (Object)LbUtils.getParameter("expteamdevdata"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "deploymentsystem", (Object)LbUtils.getParameter("deploymentsystem"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expfeedbacksince", (Object)LbUtils.getParameter("expfeedbacksince"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "exporiginalids", (Object)LbUtils.getParameter("exporiginalids"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expnosubscriptions", (Object)LbUtils.getParameter("expnosubscriptions"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expsupportingobjects", (Object)LbUtils.getParameter("expsupportingobjects"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expaclassignments", (Object)LbUtils.getParameter("expaclassignments"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "dir", (Object)LbUtils.getParameter("dir"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "changessince", (Object)LbUtils.getParameter("changessince"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "changesby", (Object)LbUtils.getParameter("changesby"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "nochecksum", (Object)LbUtils.getParameter("nochecksum"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "split", (Object)LbUtils.getParameter("split"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "expcomponents", (Object)LbUtils.getParameter("expcomponents"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "debug", (Object)LbUtils.getParameter("debug"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "override-app-alias", (Object)LbUtils.getParameter("override-app-alias"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "override-app-id", (Object)LbUtils.getParameter("override-app-id"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "override-app-workspace", (Object)LbUtils.getParameter("override-app-workspace"));
        LbUtils.getContext().getParameterInstance().putParameter(APEX_PARMS, "override-app-schema", (Object)LbUtils.getParameter("override-app-schema"));
    }

    private static LinkedHashMap<String, APEXExport.RowDetails> getApexChangeLogs(Connection conn) throws AppNotInstalledException, SQLException, IOException, DatabaseException, NoSuchAlgorithmException, InvalidParameterException, ObjectNotFoundException, InvalidApexExportException, OutputBufferNotInitialized {
        APEXExport apexExport = new APEXExport(true);
        apexExport.setCtx(LbUtils.getContext());
        apexExport.setConnection(conn);
        apexExport.setCWD(LbUtils.getContext().prependCD(""));
        apexExport.setOutStream((OutputStream)LbUtils.getContext().getOutputStream());
        apexExport.doCapture();
        return apexExport.getResults();
    }

    private static Liquibase getLiquibase(boolean checkActionTable, boolean showCount) throws Exception {
        return CommandGenerator.GetLiquibase(LbUtils.getParameter("changelog-file"), LbUtils.getContext().prependCD(""), checkActionTable, showCount);
    }

    private static ObjectChangeFilter getObjectChangeFilter() throws LiquibaseException {
        String excludeObjects = LbUtils.getParameter("exclude-objects");
        String includeObjects = LbUtils.getParameter("include-objects");
        if (excludeObjects != null && includeObjects != null) {
            throw new LiquibaseException(Messages.getString("LB_BAD_FILTER"));
        }
        if (excludeObjects != null) {
            return new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, excludeObjects.toUpperCase());
        }
        if (includeObjects != null) {
            return new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, includeObjects.toUpperCase());
        }
        return new StandardObjectChangeFilter(null, "");
    }

    private static HashMap<String, Object> getParameters() throws IOException {
        HashMap<String, Object> parms = new HashMap<String, Object>();
        if (LbUtils.getParameter("database-changelog-table-name") != null && !"".equals(LbUtils.getParameter("database-changelog-table-name"))) {
            CommandGenerator.putParam("liquibase.databaseChangelogTableName", LbUtils.getParameter("database-changelog-table-name"), parms);
            CommandGenerator.putParam("liquibase.databaseChangelogLockTableName", LbUtils.getParameter("database-changelog-table-name") + "LOCK", parms);
        }
        CommandGenerator.putParam("sqlclversion", LbUtils.getParameter("sqlclversion"), parms);
        CommandGenerator.putParam("defaultsFile", LbUtils.getParameter("defaults-file"), parms);
        CommandGenerator.putParam("liquibase.liquibaseSchemaName", LbUtils.getParameter("liquibase-schema-name"), parms);
        CommandGenerator.putParam("liquibase.liquibaseCatalogName", LbUtils.getParameter("liquibase-catalog-name"), parms);
        CommandGenerator.putParam("liquibase.liquibaseTablespaceName", LbUtils.getParameter("liquibase-tablespace-name"), parms);
        if (LbUtils.getParameter("search-path") != null) {
            CommandGenerator.putParam("liquibase.searchPath", LbUtils.getParameter("search-path").replaceAll("\"", ""), parms);
        }
        CommandGenerator.putParam("liquibase.secureParsing", LbUtils.getParameter("secure-parsing"), parms);
        CommandGenerator.putParam("liquibase.command.changelogFile", LbUtils.getParameter("changelog-file"), parms);
        CommandGenerator.putParam("liquibase.command.changesetIdentifier", LbUtils.getParameter("changeset-identifier"), parms);
        CommandGenerator.putParam("liquibase.command.defaultSchemaName", LbUtils.getParameter("default-schema-name"), parms);
        CommandGenerator.putParam("liquibase.command.defaultCatalogName", LbUtils.getParameter("default-catalog-name"), parms);
        CommandGenerator.putParam("liquibase.command.contexts", LbUtils.getParameter("contexts"), parms);
        CommandGenerator.putParam("liquibase.command.labels", LbUtils.getParameter("labels"), parms);
        CommandGenerator.putParam("liquibase.command.outputDefaultCatalog", LbUtils.getParameter("output-default-schema"), parms);
        CommandGenerator.putParam("liquibase.command.outputDefaultSchema", LbUtils.getParameter("output-default-schema"), parms);
        CommandGenerator.putParam("liquibase.command.tag", LbUtils.getParameter("tag"), parms);
        CommandGenerator.putParam("liquibase.command.outputDirectory", LbUtils.getParameter("output-directory"), parms);
        CommandGenerator.putParam("liquibase.command.diffTypes", LbUtils.getParameter("diff-types"), parms);
        CommandGenerator.putParam("liquibase.command.excludeObjects", LbUtils.getParameter("exclude-objects"), parms);
        CommandGenerator.putParam("liquibase.command.includeObjects", LbUtils.getParameter("include-objects"), parms);
        CommandGenerator.putParam("liquibase.command.includeCatalog", LbUtils.getParameter("include-catalog"), parms);
        CommandGenerator.putParam("liquibase.command.includeSchema", LbUtils.getParameter("include-schema"), parms);
        CommandGenerator.putParam("liquibase.command.includeTablespace", LbUtils.getParameter("include-tablespace"), parms);
        CommandGenerator.putParam("liquibase.command.referenceUsername", LbUtils.getParameter("reference-username"), parms);
        CommandGenerator.putParam("liquibase.command.referencePassword", LbUtils.getParameter("reference-password"), parms);
        CommandGenerator.putParam("liquibase.command.referenceUrl", LbUtils.getParameter("reference-url"), parms);
        CommandGenerator.putParam("liquibase.command.referenceDefaultCatalogName", LbUtils.getParameter("reference-default-catalog-name"), parms);
        CommandGenerator.putParam("liquibase.command.referenceDefaultSchemaName", LbUtils.getParameter("reference-default-schema-name"), parms);
        CommandGenerator.putParam("liquibase.command.schemas", LbUtils.getParameter("schemas"), parms);
        CommandGenerator.putParam("liquibase.command.count", LbUtils.getParameter("count"), parms);
        CommandGenerator.putParam("liquibase.command.overwriteOutputFile", LbUtils.getParameter("overwrite-output-file"), parms);
        CommandGenerator.putParam("liquibase.command.verbose", LbUtils.getParameter("verbose"), parms);
        CommandGenerator.putParam("liquibase.command.changeExecListenerClass", LbUtils.getParameter("change-exec-listener-class"), parms);
        CommandGenerator.putParam("liquibase.command.changeExecListenerPropertiesFile", LbUtils.getParameter("change-exec-listener-properties-file"), parms);
        CommandGenerator.putParam("liquibase.command.rollbackScript", LbUtils.getParameter("rollback-script"), parms);
        CommandGenerator.putParam("date", LbUtils.getParameter("date"), parms);
        CommandGenerator.putParam("liquibase.command.snapshotFormat", LbUtils.getParameter("snapshot-format"), parms);
        CommandGenerator.putParam("liquibase.command.snapshotFormat", LbUtils.getParameter("snapshot-format"), parms);
        if (LbUtils.getParameter("defaults-file") != null && !"".equals(LbUtils.getParameter("defaults-file"))) {
            Map<String, Object> defParms = CommandGenerator.parseDefaultFileProperties(LbUtils.getParameter("defaults-file"));
            for (Map.Entry<String, Object> entry : defParms.entrySet()) {
                CommandGenerator.putParam(entry.getKey(), entry.getValue(), parms);
            }
        }
        return parms;
    }

    private static String getSchema(Database database) {
        String schemaParams = LbUtils.getParameter("default-schema-name");
        if (schemaParams == null || schemaParams.isEmpty()) {
            return database.getDefaultSchemaName();
        }
        return schemaParams;
    }

    private static Class<? extends DatabaseObject>[] getSnapshotTypes(String rawtypes) {
        Set<Class<? extends DatabaseObject>> types = CommandGenerator.getSnapshotTypesSet(rawtypes);
        Class[] returnTypes = new Class[types.size()];
        int i = 0;
        for (Class<? extends DatabaseObject> type : types) {
            returnTypes[i++] = type;
        }
        return returnTypes;
    }

    private static Set<Class<? extends DatabaseObject>> getSnapshotTypesSet(String rawtypes) {
        String[] snapshotTypes = CommandGenerator.splitAndTrim(rawtypes);
        if (snapshotTypes == null || snapshotTypes.length == 0 || snapshotTypes[0] == null) {
            return null;
        }
        return DatabaseObjectFactory.getInstance().parseTypes(StringUtil.join((String[])snapshotTypes, (String)","));
    }

    private static Database getSourceDb() throws DatabaseException, SQLException {
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)CommandGenerator.cloneActiveConn());
    }

    private static Database getTargetDb() throws DatabaseException, SQLException {
        JdbcConnection targetConn = new JdbcConnection(DriverManager.getConnection(LbUtils.getParameter("reference-url"), LbUtils.getParameter("reference-username"), LbUtils.getParameter("reference-password")));
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)targetConn);
    }

    private static void putParam(String key, Object value, HashMap<String, Object> map) {
        if (value != null && !"".equals(value)) {
            map.put(key, value);
        }
    }

    private static <T> ArrayList<T> removeDuplicates(ArrayList<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    private static String[] splitAndTrim(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        String[] result = string.split(",");
        int array_length = result.length;
        for (int i = 0; i < array_length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    protected static Map<String, Object> parseDefaultFileProperties(String propertyFileName) {
        try {
            HashMap<String, Object> changeLogParameters = new HashMap<String, Object>();
            File propertyFile = new File(propertyFileName);
            FileInputStream stream = new FileInputStream(propertyFile);
            Properties props = new Properties();
            props.load(stream);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
            }
            return changeLogParameters;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class DeploymentHistory {
        public final List<DeploymentDetails> deployments = new ArrayList<DeploymentDetails>();

        public String toString() {
            return this.deployments.size() + " past deployments";
        }
    }

    private static class DeploymentDetails {
        public List<RanChangeSet> changeSets = new ArrayList<RanChangeSet>();

        public String getDeploymentId() {
            if (this.changeSets.size() == 0) {
                return null;
            }
            return this.changeSets.get(0).getDeploymentId();
        }

        public void printReport(PrintWriter output) {
            DateFormat dateFormat = null;
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateTimeInstance(3, 3);
            }
            String executionTime = null;
            RanChangeSet firstChangeSet = this.changeSets.get(0);
            if (this.changeSets.size() > 1) {
                RanChangeSet last = this.changeSets.get(this.changeSets.size() - 1);
                long executionMs = last.getDateExecuted().getTime() - firstChangeSet.getDateExecuted().getTime();
                executionTime = (float)executionMs / 1000.0f + "s";
            }
            StringBuilder message = new StringBuilder("- Database updated at ").append(dateFormat.format(firstChangeSet.getDateExecuted())).append(". Applied ").append(this.changeSets.size()).append(" changeset(s)");
            if (executionTime != null) {
                message.append(" in ").append(executionTime);
            }
            message.append(", DeploymentId: ").append(firstChangeSet.getDeploymentId());
            output.println(message.toString());
            for (RanChangeSet changeSet : this.changeSets) {
                output.println("  " + changeSet.toString());
            }
            output.println("");
        }
    }
}

