/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.statement.AbstractCommonSxmlStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.generator.MetadataSqlGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public abstract class AbstractCommonSxmlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonSxmlStatement> {
    protected static final HashMap<String, String> typeChanges = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("PACKAGE SPEC", "PACKAGE");
            this.put("TYPE_SPEC", "TYPE");
            this.put("TYPE_BODY", "TYPE BODY");
            this.put("MATERIALIZED_VIEW_LOG", "MATERIALIZED VIEW LOG");
            this.put("MATERIALIZED_VIEW", "MATERIALIZED VIEW");
            this.put("DB_LINK", "DATABASE LINK");
        }
    };

    public abstract ACTIONS createOrDrop();

    public Sql[] generateSql(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        if (!(database instanceof OracleDatabase)) {
            return null;
        }
        Sql[] sqls = null;
        if (ACTIONS.CREATE.equals((Object)this.createOrDrop())) {
            try {
                sqls = MetadataSqlGenerator.getCreateSqlSxml(statement, database);
            }
            catch (Exception e) {
                LbUtils.log("SXML CREATE Generation FAILED");
                LbUtils.log(e);
            }
        } else {
            try {
                sqls = MetadataSqlGenerator.getDropSqlSxml(statement, database);
            }
            catch (Exception e) {
                LbUtils.log("SXML DROP Generation FAILED");
                LbUtils.log(e);
            }
        }
        return sqls;
    }

    public abstract boolean supports(AbstractCommonSxmlStatement var1, Database var2);

    public ValidationErrors validate(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        validationErrors.checkRequiredField("source", (Object)statement.getSource());
        return validationErrors;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

