/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.ext.ora.statement.RunOrdsScriptStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.generator.MetadataSqlGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public abstract class AbstractCommonPlSqlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonPlSqlStatement> {
    public abstract ACTIONS createOrDrop();

    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        if (!(database instanceof OracleDatabase)) {
            return null;
        }
        Sql[] sqls = null;
        if (ACTIONS.CREATE.equals((Object)this.createOrDrop())) {
            try {
                sqls = MetadataSqlGenerator.getCreateSqlPlSql(statement, database);
            }
            catch (Exception e) {
                LbUtils.log("PL/SQL CREATE Generation FAILED");
                LbUtils.log(e);
            }
        } else {
            try {
                sqls = MetadataSqlGenerator.getDropSqlPlSql(statement, database);
            }
            catch (Exception e) {
                LbUtils.log("PL/SQL DROP Generation FAILED");
                LbUtils.log(e);
            }
        }
        return sqls;
    }

    public abstract boolean supports(AbstractCommonPlSqlStatement var1, Database var2);

    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        if (statement instanceof AbstractCommonPlSqlStatement && ((Object)((Object)statement)).getClass().getSimpleName().startsWith("Create")) {
            validationErrors.checkRequiredField("source", (Object)statement.getSource());
        }
        if (statement instanceof RunOracleScriptStatement || statement instanceof RunApexScriptStatement || statement instanceof RunOrdsScriptStatement) {
            if (statement.getSourceType() != null && "STRING".equals(statement.getSourceType().toUpperCase())) {
                validationErrors.checkRequiredField("source", (Object)statement.getSource());
            } else if (statement.getSourceType() != null && "FILE".equals(statement.getSourceType().toUpperCase())) {
                Path cwd = null;
                Path file = null;
                Path path = null;
                if ("true".equals(statement.getRelativeToChangelogFile().toLowerCase())) {
                    cwd = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toAbsolutePath();
                    file = cwd.resolve(statement.getFile().trim());
                    statement.setFile(file.toString().trim());
                    path = cwd.resolve(file.getParent()).resolve(statement.getSource().trim());
                    statement.setSource(path.toString().trim());
                } else {
                    cwd = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toAbsolutePath();
                    path = cwd.resolve(statement.getSource());
                }
                if (Files.notExists(path, new LinkOption[0])) {
                    validationErrors.addError("Generate Sql Validation unable to find and load file, check paths");
                }
            } else if (statement.getSourceType() != null && "URL".equals(statement.getSourceType().toUpperCase())) {
                URL url = null;
                URI uri = null;
                URL fileURL = null;
                try {
                    url = new URL(statement.getSource());
                    uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    fileURL = uri.toURL();
                    BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                    in.close();
                }
                catch (Exception e) {
                    validationErrors.addError("generateSql unable to find and load file, check urls");
                }
            } else {
                validationErrors.addError("Invalid source type :" + statement.getSourceType());
            }
        }
        return validationErrors;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

