/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;

public class OracleSkippedChangeVisitor
implements ChangeSetVisitor,
SkippedChangeSetVisitor {
    private String dep_id = null;
    private final LinkedHashMap<ChangeSet, ChangeSetStatus> changeSetStatuses = new LinkedHashMap();
    private final List<RanChangeSet> ranChangeSets;

    public OracleSkippedChangeVisitor(String deployment, Database database) throws DatabaseException {
        this.ranChangeSets = new ArrayList<RanChangeSet>(ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getRanChangeSets());
        this.dep_id = deployment;
    }

    private void LogSkippedChangeset(Database database, ChangeSet changeSet) throws LiquibaseException {
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        String id = null;
        String author = null;
        String filename = null;
        if (database instanceof OracleDatabase) {
            for (Change change : changeSet.getChanges()) {
                if (!(change instanceof AbstractOracleChange)) {
                    return;
                }
                AbstractOracleChange chg = (AbstractOracleChange)change;
                id = chg.getId();
                author = chg.getAuthor();
                filename = chg.getFile();
                try {
                    QueryUtils.runSqlReturnResult("insert into DATABASECHANGELOG_ACTIONS (id,author,filename,sql,sxml,deployment_id,status) values ('" + id + "','" + author + "','" + filename + "', null, null,'" + this.dep_id + "','SKIPPED')", conn);
                }
                catch (Exception e) {
                    LbUtils.log(e);
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (e instanceof LiquibaseException) {
                        throw (LiquibaseException)e;
                    }
                    throw new LiquibaseException((Throwable)e);
                }
            }
            try {
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new LiquibaseException((Throwable)e);
            }
        }
    }

    protected ChangeSetStatus addStatus(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) throws LiquibaseException {
        ChangeSetStatus status = new ChangeSetStatus(changeSet);
        RanChangeSet ranChangeSetToRemove = null;
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.isSameAs(changeSet)) continue;
            status.setPreviouslyRan(true);
            status.setDateLastExecuted(ranChangeSet.getDateExecuted());
            status.setStoredCheckSum(ranChangeSet.getLastCheckSum());
            status.setRanChangeSet(ranChangeSet);
            ranChangeSetToRemove = ranChangeSet;
            break;
        }
        if (ranChangeSetToRemove != null) {
            this.ranChangeSets.remove(ranChangeSetToRemove);
        }
        this.changeSetStatuses.put(changeSet, status);
        return status;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void skipped(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        this.LogSkippedChangeset(database, changeSet);
        ChangeSetStatus status = this.addStatus(changeSet, databaseChangeLog, database);
        status.setWillRun(false);
        status.setFilterResults(filterResults);
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        ChangeSetStatus status = this.addStatus(changeSet, databaseChangeLog, database);
        status.setWillRun(true);
        status.setFilterResults(filterResults);
    }
}

