/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.ext.ora.change.AbstractOracleChange;
import liquibase.ext.ora.change.CreateInternalSxmlChange;
import liquibase.ext.ora.change.DropInternalSxmlChange;
import liquibase.ext.ora.change.LogOracleActionChange;
import liquibase.ext.ora.change.LogOracleSyncChange;
import liquibase.ext.ora.change.RunInternalScriptChange;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.sql.Sql;
import liquibase.sql.visitor.ReplaceSqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public class OracleActionChangeListener
extends AbstractChangeExecListener
implements ChangeExecListener,
ChangeLogSyncListener {
    public void markedRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange)) continue;
            try {
                Change logChange = this.getCreateLogStmt(change, database);
                if (logChange != null) {
                    database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
                }
                if ((logChange = this.getUpdateLogStmt(change, database, "RAN")) == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
                database.commit();
            }
            catch (LiquibaseException e) {
                LbUtils.log((Exception)((Object)e));
            }
        }
    }

    public void preconditionErrored(PreconditionErrorException error, PreconditionContainer.ErrorOption onError) {
    }

    public void preconditionFailed(PreconditionFailedException error, PreconditionContainer.FailOption onFail) {
    }

    public void ran(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.ExecType execType) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) continue;
            try {
                Change logChange = this.getUpdateLogStmt(change, database, "RAN");
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void rollbackFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) continue;
            try {
                Change logChange = this.getUpdateLogStmt(change, database, "rollbackFailed");
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) continue;
            try {
                Change logChange = this.getDropLogStmt(change, database, "rolledBack");
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) continue;
            try {
                Change logChange = this.getUpdateLogStmt(change, database, "runFailed");
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void willRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) continue;
            try {
                Change logChange = this.getUpdateLogStmt(change, database, "willRollback0-");
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
        ReplaceSqlVisitor repVisitor = new ReplaceSqlVisitor();
        repVisitor.setReplace("CREATE OR REPLACE");
        repVisitor.setWith("CREATE");
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange)) continue;
            if (!((AbstractOracleChange)change).getReplaceIfExists().booleanValue()) {
                changeSet.getSqlVisitors().add(repVisitor);
            }
            if (!this.shouldLog(change)) continue;
            try {
                Change logChange = this.getCreateLogStmt(change, database);
                if (logChange == null) continue;
                database.executeStatements(logChange, databaseChangeLog, changeSet.getSqlVisitors());
                database.getConnection().commit();
            }
            catch (LiquibaseException e) {
                e.printStackTrace();
            }
        }
    }

    private Change getCreateLogStmt(Change change, Database database) {
        if (!(change instanceof AbstractOracleChange) || !this.shouldLog(change)) {
            return null;
        }
        String actionLogging = "";
        try {
            ActionLogTableManager tm = new ActionLogTableManager(database);
            SqlStatement[] statements = change.generateStatements(database);
            SqlStatement statement = statements[0];
            Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(statement, database);
            actionLogging = tm.getActionLogSql(statement, sqls[0].toSql());
            LogOracleActionChange log = new LogOracleActionChange();
            log.setSource(actionLogging);
            log.setSourceType("STRING");
            return log;
        }
        catch (DatabaseException e) {
            LbUtils.log("ACTION LOGGING Generation FAILED");
            LbUtils.log((Exception)((Object)e));
            return null;
        }
    }

    private Change getDropLogStmt(Change change, Database database, String status) {
        String schema = Scope.getCurrentScope().getDatabase().getDefaultSchemaName();
        if (change instanceof AbstractOracleChange && this.shouldLog(change)) {
            AbstractOracleChange oraChange = null;
            oraChange = (AbstractOracleChange)change;
            Object sql = "delete from %USER_NAME%.%DATABASECHANGELOG%_ACTIONS where id = '" + oraChange.getId() + "' and sequence = (select max(sequence) from %USER_NAME%.%DATABASECHANGELOG%_ACTIONS where id = '" + oraChange.getId() + "')";
            sql = ((String)sql).replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
            sql = ((String)sql).replaceAll("%USER_NAME%", schema);
            LogOracleActionChange log = new LogOracleActionChange();
            log.setSource((String)sql);
            log.setSourceType("STRING");
            return log;
        }
        return null;
    }

    private Change getUpdateLogStmt(Change change, Database database, String status) {
        String schema = Scope.getCurrentScope().getDatabase().getDefaultSchemaName();
        if (change instanceof AbstractOracleChange && this.shouldLog(change)) {
            AbstractOracleChange oraChange = null;
            oraChange = (AbstractOracleChange)change;
            Object sql = "update %USER_NAME%.%DATABASECHANGELOG%_ACTIONS set status = '" + status + "' where id = '" + oraChange.getId() + "' and sequence = (select max(sequence) from %USER_NAME%.%DATABASECHANGELOG%_ACTIONS where id = '" + oraChange.getId() + "')";
            sql = ((String)sql).replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
            sql = ((String)sql).replaceAll("%USER_NAME%", schema);
            LogOracleActionChange log = new LogOracleActionChange();
            log.setSource((String)sql);
            log.setSourceType("STRING");
            return log;
        }
        return null;
    }

    private boolean shouldLog(Change change) {
        return !(change instanceof CreateInternalSxmlChange) && !(change instanceof RunInternalScriptChange) && !(change instanceof DropInternalSxmlChange) && !(change instanceof LogOracleSyncChange) && !(change instanceof LogOracleActionChange);
    }
}

