/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.jsonp;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;

public class JsonParser
implements AutoCloseable {
    private Reader reader;
    private Event event = null;
    private int lineNumber = 1;
    private int columnNumber = 0;
    private Stack<Event> nestedStack = new Stack();
    private StringBuilder name = new StringBuilder();
    private StringBuilder value = new StringBuilder();
    private StringBuilder string = new StringBuilder();
    private Character lastChar;
    private boolean fraction;
    private boolean exponent;
    private boolean allowUnquotedFieldNames;
    private boolean escapeNonAscii;

    public JsonParser(Reader reader) {
        if (reader == null) {
            throw new JsonException("reader can't be null");
        }
        this.reader = reader;
    }

    public void setAllowUnquotedFieldNames(boolean bl) {
        this.allowUnquotedFieldNames = bl;
    }

    public boolean hasNext() {
        if (this.event == null) {
            if (this.lastChar != null) {
                return true;
            }
            try {
                this.lastChar = Character.valueOf(this.nextChar());
            }
            catch (JsonException jsonException) {
                return false;
            }
        }
        if (this.lastChar != null) {
            return true;
        }
        return !this.nestedStack.isEmpty();
    }

    private char nextChar() {
        try {
            int n = this.reader.read();
            if (n == -1) {
                throw new JsonException("EOF reached");
            }
            char c = (char)n;
            switch (c) {
                case '\n': {
                    ++this.lineNumber;
                    this.columnNumber = 0;
                    break;
                }
                default: {
                    ++this.columnNumber;
                }
            }
            return c;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException.getMessage(), iOException);
        }
    }

    public Event next() throws JsonParsingException {
        this.name.setLength(0);
        this.value.setLength(0);
        if (this.event == null) {
            char c = this.consumeWhitespace();
            if (c == '{') {
                this.event = Event.START_OBJECT;
                this.nestedStack.push(this.event);
            } else if (c == '[') {
                this.event = Event.START_ARRAY;
                this.nestedStack.push(this.event);
            } else {
                this.lastChar = Character.valueOf(c);
                this.event = this.readValue();
            }
            return this.event;
        }
        switch (this.event) {
            case END_OBJECT: {
                try {
                    this.nestedStack.peek();
                }
                catch (EmptyStackException emptyStackException) {
                    throw new JsonParsingException("End of document reached");
                }
                char c = this.consumeWhitespace();
                switch (c) {
                    case '}': {
                        if (this.nestedStack.peek() != Event.START_OBJECT) {
                            throw new JsonParsingException("Expected ']'");
                        }
                        this.nestedStack.pop();
                        this.event = Event.END_OBJECT;
                        return this.event;
                    }
                    case ']': {
                        if (this.nestedStack.peek() != Event.START_ARRAY) {
                            throw new JsonParsingException("Expected '}'");
                        }
                        this.nestedStack.pop();
                        this.event = Event.END_ARRAY;
                        return this.event;
                    }
                    case ',': {
                        this.event = this.nestedStack.peek() == Event.START_ARRAY ? this.readValue() : this.readName();
                        return this.event;
                    }
                }
                throw new JsonParsingException("Expected ','");
            }
            case START_OBJECT: {
                this.event = this.readName();
                return this.event;
            }
            case KEY_NAME: {
                this.event = this.readValue();
                return this.event;
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case END_ARRAY: {
                if (this.nestedStack.peek() == Event.START_ARRAY) {
                    char c = this.consumeWhitespace();
                    switch (c) {
                        case ',': {
                            this.event = this.readValue();
                            break;
                        }
                        case ']': {
                            this.nestedStack.pop();
                            this.event = Event.END_ARRAY;
                        }
                    }
                    return this.event;
                }
                char c = this.consumeWhitespace();
                switch (c) {
                    case ',': {
                        this.event = this.readName();
                        if (this.event != Event.KEY_NAME) {
                            throw new JsonParsingException("Expected '\"'");
                        }
                        return this.event;
                    }
                    case '}': {
                        if (this.nestedStack.peek() != Event.START_OBJECT) {
                            throw new JsonParsingException("Expected ']'");
                        }
                        this.nestedStack.pop();
                        this.event = Event.END_OBJECT;
                        return this.event;
                    }
                }
                throw new JsonParsingException("Expected ','");
            }
            case START_ARRAY: {
                this.event = this.readValue();
                return this.event;
            }
        }
        throw new JsonParsingException("");
    }

    private Event readValue() throws JsonParsingException {
        try {
            char c = this.consumeWhitespace();
            switch (c) {
                case '\"': {
                    this.value.append(this.readString());
                    return Event.VALUE_STRING;
                }
                case '[': {
                    this.nestedStack.push(Event.START_ARRAY);
                    return Event.START_ARRAY;
                }
                case ']': {
                    if (this.nestedStack.peek() != Event.START_ARRAY) {
                        throw new IllegalStateException();
                    }
                    this.nestedStack.pop();
                    return Event.END_ARRAY;
                }
                case '{': {
                    this.nestedStack.push(Event.START_OBJECT);
                    return Event.START_OBJECT;
                }
                case 't': {
                    c = this.nextChar();
                    if (c != 'r') {
                        throw new JsonParsingException("Expected 'r'");
                    }
                    c = this.nextChar();
                    if (c != 'u') {
                        throw new JsonParsingException("Expected 'u'");
                    }
                    c = this.nextChar();
                    if (c != 'e') {
                        throw new JsonParsingException("Expected 'e");
                    }
                    this.value.append("true");
                    return Event.VALUE_TRUE;
                }
                case 'f': {
                    c = this.nextChar();
                    if (c != 'a') {
                        throw new IllegalStateException();
                    }
                    c = this.nextChar();
                    if (c != 'l') {
                        throw new IllegalStateException();
                    }
                    c = this.nextChar();
                    if (c != 's') {
                        throw new IllegalStateException();
                    }
                    c = this.nextChar();
                    if (c != 'e') {
                        throw new IllegalStateException();
                    }
                    this.value.append("false");
                    return Event.VALUE_FALSE;
                }
                case 'n': {
                    c = this.nextChar();
                    if (c != 'u') {
                        throw new IllegalStateException();
                    }
                    c = this.nextChar();
                    if (c != 'l') {
                        throw new IllegalStateException();
                    }
                    c = this.nextChar();
                    if (c != 'l') {
                        throw new IllegalStateException();
                    }
                    this.value.append("null");
                    return Event.VALUE_NULL;
                }
            }
            this.readNumber(c);
            return Event.VALUE_NUMBER;
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonParsingException("Expected tokens are '{','[','\"',numeric,TRUE,FALSE,NULL");
        }
    }

    private char consumeWhitespace() {
        char c;
        if (this.lastChar != null) {
            c = this.lastChar.charValue();
            this.lastChar = null;
        } else {
            c = this.nextChar();
        }
        while (true) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return c;
                }
            }
            c = this.nextChar();
        }
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private char validateHexDigit(char c) throws JsonParsingException {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            return c;
        }
        throw new JsonParsingException("Expected hexadecimal digit");
    }

    private void readNumber(char c) throws JsonParsingException {
        char c2;
        if (!this.isDigit(c) && c != '-') {
            throw new IllegalStateException();
        }
        this.value.append(c);
        this.fraction = false;
        this.exponent = false;
        block4: while (true) {
            if (this.isDigit(c2 = this.nextChar())) {
                this.value.append(c2);
                continue;
            }
            switch (c2) {
                case '.': {
                    if (this.fraction || this.exponent) {
                        throw new JsonParsingException("");
                    }
                    this.value.append('.');
                    this.fraction = true;
                    continue block4;
                }
                case 'E': 
                case 'e': {
                    if (this.exponent) {
                        throw new JsonParsingException("");
                    }
                    this.value.append('E');
                    c2 = this.nextChar();
                    if (c2 == '-' || c2 == '+') {
                        this.value.append(c2);
                        continue block4;
                    }
                    if (this.isDigit(c2)) {
                        this.value.append(c2);
                        continue block4;
                    }
                    throw new JsonParsingException("Expected tokens are '-','+',DIGIT");
                }
            }
            break;
        }
        this.lastChar = Character.valueOf(c2);
    }

    public String[] readStringArray() throws JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        block5: while (bl) {
            switch (this.next()) {
                case END_ARRAY: {
                    bl = false;
                    continue block5;
                }
                case START_ARRAY: {
                    arrayList.add(this.readJSONArray());
                    continue block5;
                }
                case START_OBJECT: {
                    arrayList.add(this.readJSONObject());
                    continue block5;
                }
            }
            arrayList.add(this.getString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[][] readArrayOfStringArray() throws JsonException, JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        boolean bl = true;
        block4: while (bl) {
            switch (this.next()) {
                case START_ARRAY: {
                    arrayList.add(this.readStringArray());
                    continue block4;
                }
                case END_ARRAY: {
                    bl = false;
                    continue block4;
                }
            }
            throw new JsonParsingException("Expected ']'");
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public double[] readDoubleArray() throws JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.next() != Event.END_ARRAY) {
            arrayList.add(this.getString());
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)arrayList.get(i));
        }
        return dArray;
    }

    public double[][] readArrayOfDoubleArray() throws JsonException, JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        boolean bl = true;
        block4: while (bl) {
            switch (this.next()) {
                case START_ARRAY: {
                    arrayList.add(this.readDoubleArray());
                    continue block4;
                }
                case END_ARRAY: {
                    bl = false;
                    continue block4;
                }
            }
            throw new JsonParsingException("Expected ']'");
        }
        return (double[][])arrayList.toArray((T[])new double[arrayList.size()][]);
    }

    public int[] readIntArray() throws JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.next() != Event.END_ARRAY) {
            arrayList.add(this.getString());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt((String)arrayList.get(i));
        }
        return nArray;
    }

    public long[] readLongArray() throws JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("Must be at START_ARRAY");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.next() != Event.END_ARRAY) {
            arrayList.add(this.getString());
        }
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Long.parseLong((String)arrayList.get(i));
        }
        return lArray;
    }

    private String readString() throws JsonParsingException {
        this.string.setLength(0);
        block14: while (true) {
            char c = this.nextChar();
            switch (c) {
                case '\n': {
                    this.string.append('\n');
                    continue block14;
                }
                case '\\': {
                    c = this.nextChar();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            this.string.append(c);
                            continue block14;
                        }
                        case 'b': {
                            this.string.append('\b');
                            continue block14;
                        }
                        case 'f': {
                            this.string.append('\f');
                            continue block14;
                        }
                        case 'n': {
                            this.string.append('\n');
                            continue block14;
                        }
                        case 'r': {
                            this.string.append('\r');
                            continue block14;
                        }
                        case 't': {
                            this.string.append('\t');
                            continue block14;
                        }
                        case 'u': {
                            this.string.append((char)Integer.parseInt("" + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()), 16));
                            continue block14;
                        }
                    }
                    throw new JsonParsingException("Expected token are '\"','\\','b','f','n','r','t','u'");
                }
                case '\"': {
                    return this.string.toString();
                }
            }
            this.string.append(c);
        }
    }

    private String readUnquoatedFieldName(char c) throws JsonParsingException {
        this.string.setLength(0);
        char c2 = c;
        block14: while (true) {
            switch (c2) {
                case '\n': {
                    this.string.append('\n');
                    continue block14;
                }
                case '\\': {
                    c2 = this.nextChar();
                    switch (c2) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            this.string.append(c2);
                            continue block14;
                        }
                        case 'b': {
                            this.string.append('\b');
                            continue block14;
                        }
                        case 'f': {
                            this.string.append('\f');
                            continue block14;
                        }
                        case 'n': {
                            this.string.append('\n');
                            continue block14;
                        }
                        case 'r': {
                            this.string.append('\r');
                            continue block14;
                        }
                        case 't': {
                            this.string.append('\t');
                            continue block14;
                        }
                        case 'u': {
                            this.string.append((char)Integer.parseInt("" + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()) + this.validateHexDigit(this.nextChar()), 16));
                            continue block14;
                        }
                    }
                    throw new JsonParsingException("Expected token are '\"','\\','b','f','n','r','t','u'");
                }
                case ':': {
                    return this.string.toString().trim();
                }
            }
            this.string.append(c2);
            c2 = this.nextChar();
        }
    }

    private Event readName() throws JsonParsingException {
        char c = this.consumeWhitespace();
        switch (c) {
            case '}': {
                if (this.nestedStack.peek() != Event.START_OBJECT) {
                    throw new JsonParsingException("Expected ']'");
                }
                this.nestedStack.pop();
                return Event.END_OBJECT;
            }
            case '\"': {
                this.name.append(this.readString());
                c = this.consumeWhitespace();
                if (c != ':') {
                    throw new JsonParsingException("Expected token ':'");
                }
                return Event.KEY_NAME;
            }
        }
        if (this.allowUnquotedFieldNames) {
            this.name.append(this.readUnquoatedFieldName(c));
            return Event.KEY_NAME;
        }
        throw new JsonParsingException("Expected '\"' or '}'");
    }

    public String getString() {
        if (this.event == Event.KEY_NAME) {
            return this.name.toString();
        }
        if (this.event == Event.VALUE_NULL) {
            return null;
        }
        return this.value.toString();
    }

    public String getStringValue() throws JsonParsingException {
        if (this.event == Event.KEY_NAME) {
            this.next();
        }
        return this.value.toString();
    }

    public boolean isIntegralNumber() {
        if (this.event != Event.VALUE_NUMBER) {
            return false;
        }
        return this.value.indexOf(".") == -1 && this.value.indexOf("e") == -1;
    }

    public int getInt() throws JsonParsingException {
        if (this.event != Event.VALUE_NUMBER) {
            throw new JsonParsingException("Event is not a number");
        }
        return Integer.parseInt(this.getString());
    }

    public long getLong() throws JsonParsingException {
        if (this.event != Event.VALUE_NUMBER) {
            throw new JsonParsingException("Event is not a number");
        }
        return Long.parseLong(this.getString());
    }

    public double getDouble() throws JsonParsingException {
        if (this.event != Event.VALUE_NUMBER) {
            throw new JsonParsingException("Event is not a number");
        }
        return Double.parseDouble(this.getString());
    }

    public boolean getBoolean() throws JsonParsingException {
        if (this.event != Event.VALUE_TRUE && this.event != Event.VALUE_FALSE) {
            throw new JsonParsingException("Event is not a VALUE_TRUE or VALUE_FALSE");
        }
        return this.event == Event.VALUE_TRUE;
    }

    public BigDecimal getBigDecimal() throws JsonParsingException {
        if (this.event != Event.VALUE_NUMBER) {
            throw new JsonParsingException("Event is not a number");
        }
        return new BigDecimal(this.getString());
    }

    public String readJSONArray() throws JsonParsingException {
        if (this.event != Event.START_ARRAY) {
            throw new JsonParsingException("event must be START_ARRAY");
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        boolean bl2 = true;
        block5: while (bl) {
            switch (this.next()) {
                case END_ARRAY: {
                    stringBuilder.append("]");
                    bl = false;
                    continue block5;
                }
                case START_ARRAY: {
                    if (!bl || bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.readJSONArray());
                    continue block5;
                }
                case START_OBJECT: {
                    if (!bl || bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.readJSONObject());
                    continue block5;
                }
            }
            if (!bl || bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            this.readJSON(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void readJSON(StringBuilder stringBuilder) {
        switch (this.event) {
            case KEY_NAME: {
                stringBuilder.append('\"').append(this.getString()).append('\"').append(':');
                break;
            }
            case VALUE_STRING: {
                stringBuilder.append('\"').append(this.getString()).append('\"');
                break;
            }
            case VALUE_NUMBER: {
                stringBuilder.append(this.getString());
                break;
            }
            case VALUE_TRUE: {
                stringBuilder.append("true");
                break;
            }
            case VALUE_FALSE: {
                stringBuilder.append("false");
                break;
            }
            case VALUE_NULL: {
                stringBuilder.append("null");
            }
        }
    }

    public String readJSONObject() throws JsonParsingException {
        if (this.event != Event.START_OBJECT) {
            throw new JsonParsingException("event must be START_OBJECT");
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean bl = true;
        boolean bl2 = true;
        block5: while (bl) {
            switch (this.next()) {
                case END_OBJECT: {
                    stringBuilder.append('}');
                    bl = false;
                    continue block5;
                }
                case START_OBJECT: {
                    if (this.event == Event.KEY_NAME) {
                        if (bl2) {
                            bl2 = false;
                        } else {
                            stringBuilder.append(',');
                        }
                    }
                    stringBuilder.append(this.readJSONObject());
                    continue block5;
                }
                case START_ARRAY: {
                    if (this.event == Event.KEY_NAME) {
                        if (bl2) {
                            bl2 = false;
                        } else {
                            stringBuilder.append(',');
                        }
                    }
                    stringBuilder.append(this.readJSONArray());
                    continue block5;
                }
            }
            if (this.event == Event.KEY_NAME) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(',');
                }
            }
            this.readJSON(stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() {
        this.name = null;
        this.value = null;
        this.reader = null;
    }

    public JsonLocation getLocation() {
        return new JsonLocation(this.lineNumber, this.columnNumber);
    }

    public class JsonException
    extends RuntimeException {
        private static final long serialVersionUID = 8195480277551995830L;
        private JsonLocation location;

        private JsonException(String string) {
            super(string);
            this.location = new JsonLocation(JsonParser.this.lineNumber, JsonParser.this.columnNumber);
        }

        private JsonException(String string, Throwable throwable) {
            super(string, throwable);
            this.location = new JsonLocation(JsonParser.this.lineNumber, JsonParser.this.columnNumber);
        }

        public JsonLocation getLocation() {
            return this.location;
        }

        @Override
        public String getMessage() {
            return "Invalid character" + this.getLocation() + ". " + super.getMessage();
        }
    }

    public class JsonParsingException
    extends Exception {
        private static final long serialVersionUID = 8195480277551995830L;
        private JsonLocation location;

        private JsonParsingException(String string) {
            super(string);
            this.location = new JsonLocation(JsonParser.this.lineNumber, JsonParser.this.columnNumber);
        }

        private JsonParsingException(String string, Throwable throwable) {
            super(string, throwable);
            this.location = new JsonLocation(JsonParser.this.lineNumber, JsonParser.this.columnNumber);
        }

        public JsonLocation getLocation() {
            return this.location;
        }

        @Override
        public String getMessage() {
            return "Invalid character" + this.getLocation() + ". " + super.getMessage();
        }
    }

    public static class JsonLocation {
        private final int lineNumber;
        private final int columnNumber;

        protected JsonLocation(int n, int n2) {
            this.lineNumber = n;
            this.columnNumber = n2;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public String toString() {
            return " at line no:" + this.lineNumber + ", column no:" + this.columnNumber;
        }
    }

    public static enum Event {
        START_ARRAY,
        START_OBJECT,
        KEY_NAME,
        VALUE_STRING,
        VALUE_NUMBER,
        VALUE_TRUE,
        VALUE_FALSE,
        VALUE_NULL,
        END_OBJECT,
        END_ARRAY;

    }
}

