/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.type.SdoNumberArray;
import oracle.spatial.util.Util;
import oracle.sql.BLOB;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class TIN2Contours {
    private static void addContourOneAboveTwoBelow(ContoursAtElevation contoursAtElevation, int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, double d) {
        double d2 = (d - dArray[2]) / (dArray2[2] - dArray[2]);
        double d3 = (d - dArray[2]) / (dArray3[2] - dArray[2]);
        double d4 = dArray[0] + d2 * (dArray2[0] - dArray[0]);
        double d5 = dArray[0] + d3 * (dArray3[0] - dArray[0]);
        double d6 = dArray[1] + d2 * (dArray2[1] - dArray[1]);
        double d7 = dArray[1] + d3 * (dArray3[1] - dArray[1]);
        contoursAtElevation.addContour(new Contour(n, n2, n3, n4, d4, d6, d, n, n2, n5, n6, d5, d7, d));
    }

    private static void addContourOneBelowTwoAbove(ContoursAtElevation contoursAtElevation, int n, int n2, double[] dArray, int n3, int n4, double[] dArray2, int n5, int n6, double[] dArray3, double d) {
        double d2 = (d - dArray[2]) / (dArray2[2] - dArray[2]);
        double d3 = (d - dArray[2]) / (dArray3[2] - dArray[2]);
        double d4 = dArray[0] + d2 * (dArray2[0] - dArray[0]);
        double d5 = dArray[0] + d3 * (dArray3[0] - dArray[0]);
        double d6 = dArray[1] + d2 * (dArray2[1] - dArray[1]);
        double d7 = dArray[1] + d3 * (dArray3[1] - dArray[1]);
        contoursAtElevation.addContour(new Contour(n, n2, n5, n6, d5, d7, d, n, n2, n3, n4, d4, d6, d));
    }

    public static void generateContours(STRUCT sTRUCT, String string, long l, double[] dArray, STRUCT sTRUCT2, String string2) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Contours contours = new Contours();
        HashSet<Double> hashSet = new HashSet<Double>();
        double d = 1.0E-6;
        for (int i = 0; i < dArray.length; ++i) {
            hashSet.add(new Double(dArray[i]));
            contours.addContoursAtElevation(new ContoursAtElevation(dArray[i]));
        }
        OracleConnection oracleConnection = sTRUCT.getInternalConnection();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement("create table " + Util.enquoteTableName((Connection)oracleConnection, string2) + " (\n  contour_id number,\n  elevation  number,\n  contour    sdo_geometry,\n  constraint " + Util.enquoteNameSQLName((Connection)oracleConnection, string2 + "_pk") + " primary key (contour_id))");
        oraclePreparedStatement.executeUpdate();
        oraclePreparedStatement.close();
        oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement("select\n  blk_id,\n  num_points,\n  points,\n  num_triangles,\n  triangles\nfrom table(\n  sdo_tin_pkg.clip_tin(\n    inp => :inp,\n    qry => :qry,\n    qry_min_res => 0,\n    qry_max_res => 1))\norder by\n  obj_id,\n  blk_id");
        oraclePreparedStatement.setSTRUCT(1, sTRUCT);
        oraclePreparedStatement.setSTRUCT(2, sTRUCT2);
        ResultSet resultSet = oraclePreparedStatement.executeQuery();
        while (resultSet.next()) {
            long l2 = resultSet.getLong(1);
            long l3 = resultSet.getLong(2);
            long l4 = resultSet.getLong(4);
            object3 = (BLOB)resultSet.getBlob(3);
            object2 = (BLOB)resultSet.getBlob(5);
            object = object3.getBytes(1L, (int)object3.length());
            byte[] byArray = object2.getBytes(1L, (int)object2.length());
            object3.close();
            object2.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
            if ((long)((byte[])object).length != l3 * 32L) {
                throw new RuntimeException("POINTS BLOB for obj_id = " + l + ", blk_id = " + l2 + " has length " + ((byte[])object).length + " bytes, expected #pts * 32 = " + l3 + " * 32 = " + l3 * 32L + ".");
            }
            if ((long)byArray.length != l4 * 24L) {
                throw new RuntimeException("TRIANGLES BLOB for obj_id = " + l + ", blk_id = " + l2 + " has length " + byArray.length + " bytes, expected #trs * 24 = " + l4 + " * 24 = " + l4 * 24L + ".");
            }
            try {
                int n;
                int n2;
                HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
                int n3 = 0;
                while ((long)n3 < l3) {
                    double d2 = dataInputStream.readDouble();
                    double d3 = dataInputStream.readDouble();
                    double d4 = dataInputStream.readDouble();
                    if (hashSet.contains(new Double(d4))) {
                        d4 += d;
                    }
                    n2 = dataInputStream.readInt();
                    n = dataInputStream.readInt();
                    hashMap.put(Contour.getPointTag(n2, n), new double[]{d2, d3, d4});
                    ++n3;
                }
                n3 = 0;
                while ((long)n3 < l4) {
                    n2 = dataInputStream2.readInt();
                    int n4 = dataInputStream2.readInt();
                    n = dataInputStream2.readInt();
                    int n5 = dataInputStream2.readInt();
                    int n6 = dataInputStream2.readInt();
                    int n7 = dataInputStream2.readInt();
                    double[] dArray2 = (double[])hashMap.get(Contour.getPointTag(n2, n4));
                    double[] dArray3 = (double[])hashMap.get(Contour.getPointTag(n, n5));
                    double[] dArray4 = (double[])hashMap.get(Contour.getPointTag(n6, n7));
                    Iterator<ContoursAtElevation> iterator = contours.getContours();
                    while (iterator.hasNext()) {
                        ContoursAtElevation contoursAtElevation = iterator.next();
                        double d5 = contoursAtElevation.getElevation();
                        if (dArray2[2] == d5 || dArray3[2] == d5 || dArray4[2] == d5) {
                            throw new RuntimeException("Point elevation exception");
                        }
                        if (dArray2[2] < d5) {
                            if (dArray3[2] < d5) {
                                if (!(dArray4[2] > d5)) continue;
                                TIN2Contours.addContourOneAboveTwoBelow(contoursAtElevation, n6, n7, dArray4, n2, n4, dArray2, n, n5, dArray3, d5);
                                continue;
                            }
                            if (!(dArray3[2] > d5)) continue;
                            if (dArray4[2] < d5) {
                                TIN2Contours.addContourOneAboveTwoBelow(contoursAtElevation, n, n5, dArray3, n6, n7, dArray4, n2, n4, dArray2, d5);
                                continue;
                            }
                            if (!(dArray4[2] > d5)) continue;
                            TIN2Contours.addContourOneBelowTwoAbove(contoursAtElevation, n2, n4, dArray2, n, n5, dArray3, n6, n7, dArray4, d5);
                            continue;
                        }
                        if (!(dArray2[2] > d5)) continue;
                        if (dArray3[2] < d5) {
                            if (dArray4[2] < d5) {
                                TIN2Contours.addContourOneAboveTwoBelow(contoursAtElevation, n2, n4, dArray2, n, n5, dArray3, n6, n7, dArray4, d5);
                                continue;
                            }
                            if (!(dArray4[2] > d5)) continue;
                            TIN2Contours.addContourOneBelowTwoAbove(contoursAtElevation, n, n5, dArray3, n6, n7, dArray4, n2, n4, dArray2, d5);
                            continue;
                        }
                        if (!(dArray3[2] > d5) || !(dArray4[2] < d5)) continue;
                        TIN2Contours.addContourOneBelowTwoAbove(contoursAtElevation, n6, n7, dArray4, n2, n4, dArray2, n, n5, dArray3, d5);
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        resultSet.close();
        oraclePreparedStatement.close();
        oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement("insert into " + Util.enquoteTableName((Connection)oracleConnection, string2) + " (\n  contour_id,\n  elevation,\n  contour)\nvalues (\n  :contour_id,\n  :elevation,\n  :contour)");
        Iterator<ContoursAtElevation> iterator = contours.getContours();
        long l5 = 0L;
        while (iterator.hasNext()) {
            ContoursAtElevation contoursAtElevation = iterator.next();
            double d6 = contoursAtElevation.getElevation();
            object3 = contoursAtElevation.getSortedContours();
            while (object3.hasNext()) {
                object2 = (Contour)object3.next();
                object = ((Contour)object2).getGeom();
                oraclePreparedStatement.setLong(1, l5++);
                oraclePreparedStatement.setDouble(2, d6);
                oraclePreparedStatement.setObject(3, (Object)JGeometry.store((JGeometry)object, (Connection)oracleConnection));
                oraclePreparedStatement.executeUpdate();
            }
        }
        oracleConnection.commit();
    }

    public static void generateContours(STRUCT sTRUCT, String string, NUMBER nUMBER, SdoNumberArray sdoNumberArray, STRUCT sTRUCT2, String string2) throws SQLException {
        long l = nUMBER.longValue();
        NUMBER[] nUMBERArray = sdoNumberArray.getArray();
        double[] dArray = new double[nUMBERArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = nUMBERArray[i].doubleValue();
        }
        TIN2Contours.generateContours(sTRUCT, string, l, dArray, sTRUCT2, string2);
    }

    public static void generateContours(STRUCT sTRUCT, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, STRUCT sTRUCT2, String string2) throws SQLException {
        long l = nUMBER.longValue();
        double d = nUMBER2.doubleValue();
        double d2 = nUMBER4.doubleValue();
        double d3 = nUMBER3.doubleValue();
        double[] dArray = new double[(int)Math.floor((d2 - d) / d3) + 1];
        int n = 0;
        for (double d4 = d; d4 <= d2; d4 += d3) {
            dArray[n] = d4;
            ++n;
        }
        TIN2Contours.generateContours(sTRUCT, string, l, dArray, sTRUCT2, string2);
    }

    private static class Contours {
        private Vector<ContoursAtElevation> m_contours = new Vector();

        public void addContoursAtElevation(ContoursAtElevation contoursAtElevation) {
            this.m_contours.add(contoursAtElevation);
        }

        public Iterator<ContoursAtElevation> getContours() {
            return this.m_contours.iterator();
        }
    }

    private static class ContoursAtElevation {
        private final double m_elevation;
        private HashMap<String, Contour> m_contoursByFirstTag;
        private HashMap<String, Contour> m_contoursByLastTag;

        public ContoursAtElevation(double d) {
            this.m_elevation = d;
            this.m_contoursByFirstTag = new HashMap();
            this.m_contoursByLastTag = new HashMap();
        }

        public double getElevation() {
            return this.m_elevation;
        }

        public void addContour(Contour contour) {
            Contour contour2 = this.m_contoursByLastTag.get(contour.getFirstVertexTag());
            Contour contour3 = this.m_contoursByFirstTag.get(contour.getLastVertexTag());
            if (contour2 != null) {
                if (contour3 != null && contour2 != contour3) {
                    this.m_contoursByFirstTag.remove(contour3.getFirstVertexTag());
                    this.m_contoursByLastTag.remove(contour3.getLastVertexTag());
                    this.m_contoursByLastTag.remove(contour2.getLastVertexTag());
                    contour2.appendContour(contour);
                    contour2.appendContour(contour3);
                    this.m_contoursByLastTag.put(contour2.getLastVertexTag(), contour2);
                } else {
                    this.m_contoursByLastTag.remove(contour2.getLastVertexTag());
                    contour2.appendContour(contour);
                    this.m_contoursByLastTag.put(contour2.getLastVertexTag(), contour2);
                }
            } else if (contour3 != null) {
                this.m_contoursByFirstTag.remove(contour3.getFirstVertexTag());
                contour3.prependContour(contour);
                this.m_contoursByFirstTag.put(contour3.getFirstVertexTag(), contour3);
            } else {
                this.m_contoursByFirstTag.put(contour.getFirstVertexTag(), contour);
                this.m_contoursByLastTag.put(contour.getLastVertexTag(), contour);
            }
            if (this.m_contoursByFirstTag.size() != this.m_contoursByLastTag.size()) {
                throw new RuntimeException("Different hashmap sizes (1)");
            }
        }

        public Iterator<Contour> getContours() {
            return this.m_contoursByFirstTag.values().iterator();
        }

        public Iterator<Contour> getSortedContours() {
            return new TreeSet<Contour>(this.m_contoursByFirstTag.values()).iterator();
        }
    }

    private static class Contour
    implements Comparable {
        private Vector<double[]> m_coords = new Vector();
        private int m_topPointIndex;
        private String m_firstVertexTag;
        private String m_lastVertexTag;

        public Contour(int n, int n2, int n3, int n4, double d, double d2, double d3, int n5, int n6, int n7, int n8, double d4, double d5, double d6) {
            this.m_coords.add(new double[]{d, d2, d3});
            this.m_coords.add(new double[]{d4, d5, d6});
            this.m_firstVertexTag = Contour.getEdgeTag(n, n2, n3, n4);
            this.m_lastVertexTag = Contour.getEdgeTag(n5, n6, n7, n8);
            this.m_topPointIndex = Contour.getTopPointIndex(d, d2, d4, d5) - 1;
        }

        private static int getTopPointIndex(double d, double d2, double d3, double d4) {
            if (d2 > d4) {
                return 1;
            }
            if (d2 < d4) {
                return 2;
            }
            if (d > d3) {
                return 1;
            }
            if (d < d3) {
                return 2;
            }
            return 2;
        }

        public int compareTo(Object object) {
            Contour contour = (Contour)object;
            if (this.m_coords.get(this.m_topPointIndex)[1] > contour.m_coords.get(contour.m_topPointIndex)[1]) {
                return 1;
            }
            if (this.m_coords.get(this.m_topPointIndex)[1] < contour.m_coords.get(contour.m_topPointIndex)[1]) {
                return -1;
            }
            if (this.m_coords.get(this.m_topPointIndex)[0] > contour.m_coords.get(contour.m_topPointIndex)[0]) {
                return 1;
            }
            if (this.m_coords.get(this.m_topPointIndex)[0] < contour.m_coords.get(contour.m_topPointIndex)[0]) {
                return -1;
            }
            return 0;
        }

        private static String getPointTag(int n, int n2) {
            return n + ":" + n2;
        }

        private static String getEdgeTag(int n, int n2, int n3, int n4) {
            boolean bl = false;
            if (n3 < n) {
                bl = true;
            }
            if (n == n3 && n4 < n2) {
                bl = true;
            }
            if (bl) {
                return Contour.getPointTag(n3, n4) + "-" + Contour.getPointTag(n, n2);
            }
            return Contour.getPointTag(n, n2) + "-" + Contour.getPointTag(n3, n4);
        }

        public void appendContour(Contour contour) {
            if (Contour.getTopPointIndex(this.m_coords.get(this.m_topPointIndex)[0], this.m_coords.get(this.m_topPointIndex)[1], contour.m_coords.get(contour.m_topPointIndex)[0], contour.m_coords.get(contour.m_topPointIndex)[1]) == 2) {
                this.m_topPointIndex = contour.m_topPointIndex + this.m_coords.size() - 1;
            }
            if (!this.getLastVertexTag().equals(contour.getFirstVertexTag())) {
                throw new RuntimeException("Concatenated contours do not match.");
            }
            this.m_lastVertexTag = contour.getLastVertexTag();
            contour.m_coords.remove(0);
            this.m_coords.addAll(contour.m_coords);
        }

        public void prependContour(Contour contour) {
            this.m_topPointIndex = Contour.getTopPointIndex(this.m_coords.get(this.m_topPointIndex)[0], this.m_coords.get(this.m_topPointIndex)[1], contour.m_coords.get(contour.m_topPointIndex)[0], contour.m_coords.get(contour.m_topPointIndex)[1]) == 2 ? contour.m_topPointIndex : this.m_topPointIndex + contour.m_coords.size() - 1;
            if (!this.getFirstVertexTag().equals(contour.getLastVertexTag())) {
                throw new RuntimeException("Concatenated contours do not match.");
            }
            this.m_firstVertexTag = contour.getFirstVertexTag();
            this.m_coords.remove(0);
            this.m_coords.addAll(0, contour.m_coords);
        }

        public String getFirstVertexTag() {
            return this.m_firstVertexTag;
        }

        public String getLastVertexTag() {
            return this.m_lastVertexTag;
        }

        public boolean isClosed() {
            int n = this.m_coords.size() - 1;
            return this.m_coords.get(0)[0] == this.m_coords.get(n)[0] && this.m_coords.get(0)[1] == this.m_coords.get(n)[1];
        }

        public JGeometry getGeom() {
            int n = this.isClosed() ? this.m_topPointIndex : 0;
            double[] dArray = new double[3 * this.m_coords.size()];
            for (int i = 0; i < this.m_coords.size(); ++i) {
                double[] dArray2 = this.isClosed() ? this.m_coords.get((i + n) % (this.m_coords.size() - 1)) : this.m_coords.get(i);
                dArray[3 * i + 0] = (double)Math.round(dArray2[0] * 100000.0) / 100000.0;
                dArray[3 * i + 1] = (double)Math.round(dArray2[1] * 100000.0) / 100000.0;
                dArray[3 * i + 2] = (double)Math.round(dArray2[2] * 100000.0) / 100000.0;
            }
            return new JGeometry(2002, 0, new int[]{1, 2, 1}, dArray);
        }

        public String toString() {
            return "(" + this.m_coords.get(0)[0] + ", " + this.m_coords.get(0)[1] + ", " + this.m_coords.get(0)[2] + ") - (" + this.m_coords.get(this.m_coords.size() - 1)[0] + ", " + this.m_coords.get(this.m_coords.size() - 1)[1] + ", " + this.m_coords.get(this.m_coords.size() - 1)[2] + "), " + this.m_coords.size() + " vertices";
        }
    }
}

