/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.sql.BLOB;

public class PcBlk2Pnts {
    private static void writeUnsignedIntLittleEndian(DataOutputStream dataOutputStream, long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
        dataOutputStream.write(byArray, 0, 4);
    }

    public static void writeIntLittleEndian(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
        dataOutputStream.writeByte(n >> 16 & 0xFF);
        dataOutputStream.writeByte(n >> 24 & 0xFF);
    }

    public static void writeFloatLittleEndian(DataOutputStream dataOutputStream, float f) throws IOException {
        PcBlk2Pnts.writeIntLittleEndian(dataOutputStream, Float.floatToRawIntBits(f));
    }

    private static void tfm4327To4328(double[] dArray, double[] dArray2) {
        double d = dArray[0] * Math.PI / 180.0;
        double d2 = dArray[1] * Math.PI / 180.0;
        double d3 = dArray[2];
        double d4 = 6378137.0;
        double d5 = 0.0033528106647474805;
        double d6 = Math.sqrt(d5 * (2.0 - d5));
        double d7 = 0.0;
        double d8 = d4 / Math.sqrt(1.0 - d6 * d6 * Math.sin(d2) * Math.sin(d2));
        double d9 = d + d7;
        if (d9 < -Math.PI) {
            d9 += Math.PI * 2;
        }
        if (d9 > Math.PI) {
            d9 -= Math.PI * 2;
        }
        double d10 = (d8 + d3) * Math.cos(d2) * Math.cos(d9);
        double d11 = (d8 + d3) * Math.cos(d2) * Math.sin(d9);
        double d12 = ((1.0 - d6 * d6) * d8 + d3) * Math.sin(d2);
        dArray2[0] = d10;
        dArray2[1] = d11;
        dArray2[2] = d12;
    }

    public static Blob pcBlk2Pnts(Blob blob, long l, int n, int n2) throws IOException, SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection:");
        int n3 = 100;
        String string = String.format("%-" + n3 + "s", "{\"POINTS_LENGTH\": " + l + ",\"POSITION\": {\"byteOffset\": 0 } }");
        String string2 = null;
        long l2 = 12L;
        byte[] byArray = null;
        long l3 = 28L;
        long l4 = string.length();
        long l5 = l * l2;
        long l6 = string2 == null ? 0 : string2.length();
        long l7 = byArray == null ? 0 : byArray.length;
        long l8 = l3 + l4 + l5 + l6 + l7;
        byte[] byArray2 = blob.getBytes(1L, (int)blob.length());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        BLOB bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        bLOB.open(1);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 131072);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        dataOutputStream.writeBytes("pnts");
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, 1L);
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, l8);
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, l4);
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, l5);
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, l6);
        PcBlk2Pnts.writeUnsignedIntLittleEndian(dataOutputStream, l7);
        dataOutputStream.writeBytes(string);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int n4 = 0;
        while ((long)n4 < l) {
            dArray[0] = dataInputStream.readDouble();
            dArray[1] = dataInputStream.readDouble();
            dArray[2] = dataInputStream.readDouble();
            PcBlk2Pnts.tfm4327To4328(dArray, dArray2);
            PcBlk2Pnts.writeFloatLittleEndian(dataOutputStream, (float)dArray2[0]);
            PcBlk2Pnts.writeFloatLittleEndian(dataOutputStream, (float)dArray2[1]);
            PcBlk2Pnts.writeFloatLittleEndian(dataOutputStream, (float)dArray2[2]);
            dataInputStream.readDouble();
            ++n4;
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string2);
        }
        if (byArray != null) {
            dataOutputStream.write(byArray, 0, byArray.length);
        }
        dataOutputStream.close();
        outputStream.close();
        bLOB.close();
        return bLOB;
    }
}

