/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.spatial.util.Las2SqlLdr;
import oracle.spatial.util.Util;

public class Las2SqlLdrIndep {
    public static void main(String[] stringArray) throws SQLException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        String string8 = stringArray[7];
        String string9 = stringArray[8];
        String string10 = stringArray[9];
        System.out.printf("Connecting to %s...\n", string6);
        Connection connection = DriverManager.getConnection(string6, string7, string8);
        connection.setAutoCommit(false);
        System.out.println("Commit Interval: " + string10 + " blocks, " + string5 + " points each");
        long l = System.currentTimeMillis();
        Las2SqlLdrIndep.loadLasIntoBlockTable(Integer.parseInt(string), string2, string3, string4, Integer.parseInt(string5), Integer.parseInt(string9), connection, Integer.parseInt(string10));
        long l2 = System.currentTimeMillis();
        System.out.printf("Time elapsed......................... %,8.3f s\n", (double)(l2 - l) / 1000.0);
    }

    private static PreparedStatement prepareInsertStm(Connection connection, String string) throws SQLException {
        return connection.prepareStatement("  insert into " + Util.enquoteNameSQLName(connection, string) + " (\n    obj_id,\n    blk_id,\n    blk_extent,\n    blk_domain,\n    pcblk_min_res,\n    pcblk_max_res,\n    num_points,\n    num_unsorted_points,\n    pt_sort_dim,\n    points)\n  values (\n    ?,\n    ?,\n    sdo_geometry(\n      2003,\n      null,\n      null,\n      sdo_elem_info_array(1, 1003, 3),\n      sdo_ordinate_array(?, ?, ?, ?)),\n    null,\n    1,\n    1,\n    ?,\n    ?,\n    null,\n    ?)");
    }

    public static void loadLasIntoBlockTable(int n, String string, String string2, String string3, int n2, int n3, Connection connection, int n4) {
        try {
            long l;
            boolean bl = false;
            int n5 = 0;
            PreparedStatement preparedStatement = connection.prepareStatement("select " + Util.enquoteNameSQLName(connection, string2) + ".NEXTVAL from dual");
            PreparedStatement preparedStatement2 = Las2SqlLdrIndep.prepareInsertStm(connection, string);
            byte[] byArray = new byte[n2 * 32];
            Las2SqlLdr.PointData.MBR mBR = new Las2SqlLdr.PointData.MBR();
            Las2SqlLdr.PointData pointData = new Las2SqlLdr.PointData(n3, string3);
            long l2 = -1L;
            long l3 = -1L;
            long l4 = System.currentTimeMillis();
            long l5 = 0L;
            Las2SqlLdr.PointData.SinglePoint singlePoint = new Las2SqlLdr.PointData.SinglePoint();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (pointData.getNumPointsRemaining() > 0) {
                l3 = singlePoint.m_hilbert;
                pointData.subtractPointWithLowestHilbert(singlePoint);
                if (n8 == 0) {
                    mBR.initMBR(singlePoint);
                    l2 = singlePoint.m_hilbert;
                    l3 = -1L;
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n5 = resultSet.getInt(1);
                        ++n6;
                    }
                } else {
                    mBR.updateMBR(singlePoint);
                }
                Las2SqlLdrIndep.writePointToByteArray(byArray, 32 * n8, singlePoint.m_x, singlePoint.m_y, singlePoint.m_z, n5, n8 + 1);
                if (n8 > n2 / 10 && l3 - l2 > 0L && singlePoint.m_hilbert - l2 > (l3 - l2) * 4L) {
                    bl = true;
                }
                if (n8 == n2 - 1 || pointData.getNumPointsRemaining() == 0 || bl) {
                    preparedStatement2.setInt(1, n);
                    preparedStatement2.setInt(2, n5);
                    preparedStatement2.setDouble(3, mBR.m_minX);
                    preparedStatement2.setDouble(4, mBR.m_minY);
                    preparedStatement2.setDouble(5, mBR.m_maxX);
                    preparedStatement2.setDouble(6, mBR.m_maxY);
                    preparedStatement2.setInt(7, n8 + 1);
                    preparedStatement2.setInt(8, n8 + 1);
                    preparedStatement2.setBlob(9, new ByteArrayInputStream(byArray), 32 * (n8 + 1));
                    preparedStatement2.execute();
                    if (n6 % n4 == 0) {
                        connection.commit();
                    }
                    n8 = -1;
                    bl = false;
                    if (pointData.m_morePointsToReadFromLasFile && pointData.getNumPointsRemaining() < n2) {
                        l = System.currentTimeMillis();
                        l5 += l - l4;
                        System.out.printf(" Writing: %,8.3f s\n", (double)(l - l4) / 1000.0);
                        pointData.loadMoreFromLas();
                        l4 = System.currentTimeMillis();
                    }
                }
                ++n7;
                ++n8;
            }
            connection.commit();
            l = System.currentTimeMillis();
            l5 += l - l4;
            System.out.printf(" Writing: %,8.3f s\n", (double)(l - l4) / 1000.0);
            System.out.printf("------------------------------------------------------------------------------------------\n", new Object[0]);
            System.out.printf("Read    %,19d points...", n7);
            System.out.printf(" %,8.3f s. ", (double)pointData.m_lasFileStream.m_totalReadingTime / 1000.0);
            System.out.printf("Sorting:", new Object[0]);
            System.out.printf(" %,8.3f s.", (double)pointData.m_totalSortingTime / 1000.0);
            System.out.printf(" Writing: %,8.3f s\n", (double)l5 / 1000.0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void loadLasIntoBlockTable(int n, String string, String string2, String string3, int n2, int n3, int n4) {
        try {
            Las2SqlLdrIndep.loadLasIntoBlockTable(n, string, string2, string3, n2, n3, DriverManager.getConnection("jdbc:default:connection:"), n4);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private static void writePointToByteArray(byte[] byArray, int n, double d, double d2, double d3, int n2, int n3) {
        Las2SqlLdrIndep.writeDoubleToByteArray(byArray, n + 0, d);
        Las2SqlLdrIndep.writeDoubleToByteArray(byArray, n + 8, d2);
        Las2SqlLdrIndep.writeDoubleToByteArray(byArray, n + 16, d3);
        Las2SqlLdrIndep.writeIntToByteArray(byArray, n + 24, n2);
        Las2SqlLdrIndep.writeIntToByteArray(byArray, n + 28, n3);
    }

    protected static void writeDoubleToByteArray(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 7] = (byte)l;
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    private static void writeIntToByteArray(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)n2;
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }
}

