/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Struct;
import java.util.ArrayList;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;

public class Generalization3D {
    public J3D_Geometry groundPlanSimplification(J3D_Geometry j3D_Geometry, Connection connection, int n, double d) throws Exception {
        double d2 = 7.0;
        int n2 = 0;
        J3D_Geometry j3D_Geometry2 = null;
        JGeometry jGeometry = Generalization3D.getGroundPlan(j3D_Geometry, connection, d);
        if (n == 1) {
            j3D_Geometry2 = Generalization3D.extruding(j3D_Geometry, jGeometry, connection, d);
        } else if (n == 0) {
            J3D_Geometry j3D_Geometry3;
            double d3 = 0.0;
            J3D_Geometry j3D_Geometry4 = Generalization3D.convert2Dto3D(jGeometry);
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry4, 0, 2, 3, false);
            int[] nArray = new int[]{0};
            int n3 = jGeometry.getOrdinatesArray().length / 2 - 1;
            while ((j3D_Geometry3 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    throw new Exception("54501");
                }
                double d4 = j3D_Geometry3.length(d);
                d3 += d4;
            }
            if (n3 >= 6) {
                for (n2 = 1; n2 <= 10; ++n2) {
                    d2 = d3 * 0.01 * (double)n2;
                    JGeometry jGeometry2 = jGeometry.simplify(d2);
                    double d5 = jGeometry2.getOrdinatesArray().length / 2 - 1;
                    double d6 = Math.ceil(100.0 * (((double)n3 - d5) / (double)n3));
                    if (!(d5 <= 6.0) && !(d6 >= 40.0) && n2 != 10) continue;
                    j3D_Geometry2 = Generalization3D.extruding(j3D_Geometry, jGeometry2, connection, d);
                    break;
                }
            } else {
                j3D_Geometry2 = Generalization3D.extruding(j3D_Geometry, jGeometry, connection, d);
            }
        } else {
            throw new Exception("Invalid parameter for simplification");
        }
        return j3D_Geometry2;
    }

    private static J3D_Geometry extruding(J3D_Geometry j3D_Geometry, JGeometry jGeometry, Connection connection, double d) throws Exception {
        double[] dArray;
        int[] nArray;
        JGeometry jGeometry2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[]{0.0, 0.0, 1.0};
        d3 = 0.0;
        for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length; ++i) {
            if ((i + 1) % 3 != 0) continue;
            d3 += j3D_Geometry.getOrdinatesArray()[i];
        }
        d3 = Math.ceil(d3 / (double)(j3D_Geometry.getOrdinatesArray().length / 3));
        J3D_Geometry j3D_Geometry2 = Generalization3D.convert2Dto3D(jGeometry);
        Generalization3D.planeEquation(dArray3, dArray2, j3D_Geometry2);
        double d4 = Generalization3D.dotProduct(dArray3, dArray4);
        if (d4 <= 0.0) {
            nArray = new int[]{1, 1003, 1};
            dArray = new double[jGeometry.getOrdinatesArray().length];
            for (int i = 0; i < jGeometry.getOrdinatesArray().length / 2; ++i) {
                dArray[2 * i] = jGeometry.getOrdinatesArray()[jGeometry.getOrdinatesArray().length - 2 * i - 2];
                dArray[2 * i + 1] = jGeometry.getOrdinatesArray()[jGeometry.getOrdinatesArray().length - 2 * i - 1];
            }
            jGeometry = new JGeometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray);
        }
        jGeometry2 = J3D_Geometry.extrusion((JGeometry)jGeometry, (double)d2, (double)d3, (Connection)connection, (double)d, (int)0);
        nArray = new int[jGeometry2.getElemInfo().length];
        System.arraycopy(jGeometry2.getElemInfo(), 0, nArray, 0, jGeometry2.getElemInfo().length);
        dArray = new double[jGeometry2.getOrdinatesArray().length];
        System.arraycopy(jGeometry2.getOrdinatesArray(), 0, dArray, 0, jGeometry2.getOrdinatesArray().length);
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), nArray, dArray);
        return j3D_Geometry3;
    }

    private static JGeometry convert3Dto2D(JGeometry jGeometry) throws Exception {
        int n = 0;
        int[] nArray = new int[jGeometry.getElemInfo().length];
        double[] dArray = new double[jGeometry.getOrdinatesArray().length / 3 * 2];
        for (n = 0; n < jGeometry.getElemInfo().length; ++n) {
            nArray[n] = n % 3 == 0 ? (jGeometry.getElemInfo()[n] - 1) / 3 * 2 + 1 : jGeometry.getElemInfo()[n];
        }
        int n2 = 0;
        for (n = 0; n < jGeometry.getOrdinatesArray().length; ++n) {
            if ((n + 1) % 3 == 0) continue;
            dArray[n2] = jGeometry.getOrdinatesArray()[n];
            ++n2;
        }
        JGeometry jGeometry2 = new JGeometry(jGeometry.getType(), 0, nArray, dArray);
        return jGeometry2;
    }

    private static J3D_Geometry convert2Dto3D(JGeometry jGeometry) throws Exception {
        int n = 0;
        int[] nArray = new int[jGeometry.getElemInfo().length];
        double[] dArray = new double[jGeometry.getOrdinatesArray().length / 2 * 3];
        for (n = 0; n < jGeometry.getElemInfo().length; ++n) {
            nArray[n] = n % 3 == 0 ? (jGeometry.getElemInfo()[n] - 1) / 2 * 3 + 1 : jGeometry.getElemInfo()[n];
        }
        int n2 = 0;
        for (n = 0; n < jGeometry.getOrdinatesArray().length; ++n) {
            if ((n + 1) % 2 == 0) {
                dArray[n2] = jGeometry.getOrdinatesArray()[n];
                dArray[++n2] = 0.0;
                ++n2;
                continue;
            }
            dArray[n2] = jGeometry.getOrdinatesArray()[n];
            ++n2;
        }
        J3D_Geometry j3D_Geometry = new J3D_Geometry(jGeometry.getType(), 0, nArray, dArray);
        return j3D_Geometry;
    }

    private static double dotProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static ArrayList getGroundPlan_old(ArrayList arrayList, double d) throws Exception {
        int n = 0;
        int n2 = 0;
        double d2 = 1.0E-16;
        boolean bl = true;
        ArrayList<JGeometry> arrayList2 = new ArrayList<JGeometry>();
        for (n = 0; n < arrayList.size(); ++n) {
            bl = true;
            JGeometry jGeometry = (JGeometry)arrayList.get(n);
            for (n2 = 0; n2 < jGeometry.getOrdinatesArray().length / 3; ++n2) {
                if (!(Math.abs(jGeometry.getOrdinatesArray()[3 * n2 + 2]) > d2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList2.add(jGeometry);
        }
        return arrayList2;
    }

    private static JGeometry getGroundPlan(J3D_Geometry j3D_Geometry, Connection connection, double d) throws Exception {
        JGeometry jGeometry = null;
        JGeometry jGeometry2 = null;
        CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_geom.sdo_g3dconv(?)}");
        callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
        callableStatement.setObject(2, (Object)JGeometry.store((JGeometry)j3D_Geometry, (Connection)connection));
        callableStatement.execute();
        Object object = (Struct)callableStatement.getObject(1);
        if (object == null) {
            throw new Exception("Building has no ground plan because it does not touch the ground!");
        }
        jGeometry2 = JGeometry.loadJS((Struct)object);
        callableStatement.close();
        callableStatement = Generalization3D.convert3Dto2D(jGeometry2);
        callableStatement.setType(2006);
        object = connection.prepareCall("{ ? = call mdsys.sdo_geom.sdo_union(?,?,?)}");
        object.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
        object.setObject(2, JGeometry.store((JGeometry)callableStatement, (Connection)connection));
        object.setObject(3, JGeometry.store((JGeometry)callableStatement, (Connection)connection));
        object.setDouble(4, d);
        object.execute();
        Object object2 = (Struct)object.getObject(1);
        jGeometry = JGeometry.loadJS((Struct)object2);
        object.close();
        object = new int[]{1, 1003, 1};
        object2 = new double[jGeometry.getOrdinatesArray().length];
        System.arraycopy(jGeometry.getOrdinatesArray(), 0, object2, 0, jGeometry.getOrdinatesArray().length);
        JGeometry jGeometry3 = new JGeometry(2003, jGeometry.getSRID(), (int[])object, (double[])object2);
        return jGeometry3;
    }

    private static int planeEquation(double[] dArray, double[] dArray2, J3D_Geometry j3D_Geometry) {
        int n = j3D_Geometry.getOrdinatesArray().length / 3;
        double[][] dArray3 = new double[n][3];
        for (int i = 0; i < n; ++i) {
            dArray3[i][0] = j3D_Geometry.getOrdinatesArray()[3 * i];
            dArray3[i][1] = j3D_Geometry.getOrdinatesArray()[3 * i + 1];
            dArray3[i][2] = j3D_Geometry.getOrdinatesArray()[3 * i + 2];
        }
        return Generalization3D.planeEquation(dArray, dArray2, dArray3);
    }

    private static int planeEquation(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3 = dArray3.length - 1;
        int n4 = 3;
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = (n2 + 1) % n3;
            dArray[0] = dArray[0] + (dArray3[n2][1] - dArray3[n][1]) * (dArray3[n2][2] + dArray3[n][2]);
            dArray[1] = dArray[1] + (dArray3[n2][2] - dArray3[n][2]) * (dArray3[n2][0] + dArray3[n][0]);
            dArray[2] = dArray[2] + (dArray3[n2][0] - dArray3[n][0]) * (dArray3[n2][1] + dArray3[n][1]);
        }
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        n = 0;
        while (n < n4) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / d;
        }
        double[] dArray4 = new double[n4];
        n = 0;
        while (n < n4) {
            dArray4[n] = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n] = dArray4[n] + dArray3[n2][n];
            }
            int n6 = n++;
            dArray4[n6] = dArray4[n6] / (double)n3;
        }
        dArray2[0] = -1.0 * (dArray[0] * dArray4[0] + dArray[1] * dArray4[1] + dArray[2] * dArray4[2]);
        double d2 = Math.abs(dArray[0]);
        double d3 = Math.abs(dArray[1]);
        double d4 = Math.abs(dArray[2]);
        int n7 = 3;
        if (d2 > d3) {
            if (d2 > d4) {
                n7 = 1;
            }
        } else if (d3 > d4) {
            n7 = 2;
        }
        return n7;
    }

    private static void main(String[] stringArray) throws Exception {
        Object var1_1 = null;
        Object var2_2 = null;
        int n = 3;
        double d = 1.0E-9;
    }
}

