/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Vector;
import oracle.spatial.util.BufferedRandomAccessFile;
import oracle.spatial.util.DBFFileCodePage;
import oracle.spatial.util.DBFieldDesc;
import oracle.spatial.util.DBFileHdr;
import oracle.spatial.util.Logger;

public class DBFReaderJGeom
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(DBFReaderJGeom.class.getName());
    private static final DBFFileCodePage DEFAULT_CODE_PAGE = DBFFileCodePage.CP28591_ISO_8859_1;
    private static final byte TERMINATOR = 13;
    private static final byte DELETED = 42;
    BufferedRandomAccessFile mainBIS;
    DBFieldDesc[] fields;
    DBFileHdr file_hdr;
    int n_fields;
    int n_records;
    int record_sz;
    boolean big_endian;
    byte[] recordBuffer;
    String namePrefix;
    String codePage;
    final Charset charsetFound;
    String[] fieldNamesLowerCache;
    byte[] fieldTypesCache;

    void init() {
        this.record_sz = 0;
        this.n_records = 0;
        this.n_fields = 0;
        this.fields = null;
        this.recordBuffer = null;
        this.file_hdr = new DBFileHdr();
        this.big_endian = true;
        this.codePage = null;
    }

    public DBFReaderJGeom() {
        this.init();
        this.charsetFound = DEFAULT_CODE_PAGE.toCharset();
    }

    public DBFReaderJGeom(String string) throws IOException {
        this(string, null);
    }

    public DBFReaderJGeom(String string, Charset charset) throws IOException {
        this.init();
        this.readCodePage(string);
        this.openDBF(string);
        this.charsetFound = this.deriveCharset(charset);
    }

    private Charset deriveCharset(Charset charset) {
        Object object;
        Object object2;
        if (charset != null) {
            LOGGER.finest("Charset " + charset.name() + " was specified in the constructor.");
            return charset;
        }
        if (this.codePage != null) {
            object2 = DBFFileCodePage.lookupJVMCharset(this.codePage);
            if (object2 != null) {
                LOGGER.finest("Charset " + ((Charset)object2).name() + " was extracted from Shapefile .cpg file.");
                return object2;
            }
            object = DBFFileCodePage.fromCharsetName(this.codePage);
            if (object != null) {
                try {
                    Charset charset2 = object.toCharset();
                    LOGGER.finest("DBFFileCodePage found. Charset " + object.name() + " was extracted from Shapefile .cpg file.");
                    return charset2;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    LOGGER.finest("Could not find any Charset match for the Code page extracted from Shapefile .cpg file");
                }
            }
        }
        if ((object2 = this.file_hdr.getCodePage()) != null) {
            try {
                object = ((DBFFileCodePage)((Object)object2)).toCharset();
                LOGGER.finest("DBFFileCodePage found. Charset " + ((Charset)object).name() + " was extracted from Shapefile DBF file header.");
                return object;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                LOGGER.finest("Could not find any Charset match for the Code Page Mark extracted from Shapefile .dbf file header.");
            }
        }
        LOGGER.finest("No charset found. Using default " + DEFAULT_CODE_PAGE.toCharset().name());
        return DEFAULT_CODE_PAGE.toCharset();
    }

    public void readCodePage(String string) throws IOException {
        this.codePage = null;
        File file = new File(string);
        if (!file.isFile()) {
            return;
        }
        int n = string.lastIndexOf(".dbf");
        String string2 = n < 0 ? string + ".cpg" : string.substring(0, n) + ".cpg";
        try (FileReader fileReader = new FileReader(string2);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string3 = bufferedReader.readLine();
            if (string3 != null && !(string3 = string3.trim()).isEmpty()) {
                this.codePage = string3;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.finest(fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.warn(iOException);
        }
    }

    public void openDBF(String string) throws IOException {
        String string2;
        this.namePrefix = string;
        if (string.lastIndexOf(".dbf") < 0) {
            string2 = string + ".dbf";
            this.namePrefix = string;
        } else {
            string2 = string;
            this.namePrefix = string.substring(0, string.lastIndexOf(".dbf"));
        }
        this.mainBIS = new BufferedRandomAccessFile(string2);
        byte[] byArray = new byte[32];
        this.mainBIS.read(byArray, 0, 32);
        this.file_hdr.fromBuffer(byArray);
        this.n_records = this.file_hdr.n_records;
        this.record_sz = this.file_hdr.record_sz;
        this.n_fields = (this.file_hdr.header_sz - 1 - 32) / 32;
        this.recordBuffer = new byte[this.record_sz];
        if (this.record_sz > this.mainBIS.bufferSize()) {
            long l = this.mainBIS.getFilePointer();
            this.closeDBF();
            this.mainBIS = new BufferedRandomAccessFile(string2, this.record_sz);
            this.mainBIS.read(this.recordBuffer, 0, (int)l);
        }
        byte[] byArray2 = new byte[this.n_fields * 32];
        this.mainBIS.read(byArray2, 0, byArray2.length);
        this.fields = new DBFieldDesc[this.n_fields];
        for (int i = 0; i < this.n_fields; ++i) {
            DBFieldDesc dBFieldDesc = new DBFieldDesc();
            dBFieldDesc.fromBuffer(byArray2);
            this.fields[i] = dBFieldDesc;
            System.arraycopy(byArray2, 32, byArray2, 0, (this.n_fields - i - 1) * 32);
        }
    }

    public void closeDBF() throws IOException {
        if (this.mainBIS != null) {
            this.mainBIS.close();
        }
    }

    @Override
    public void close() throws Exception {
        this.closeDBF();
    }

    public int numRecords() {
        return this.n_records;
    }

    public int numFields() {
        return this.n_fields;
    }

    public int recordSize() {
        return this.record_sz;
    }

    public byte[] getRecord(int n) {
        int n2 = 32 + this.n_fields * 32 + 1 + n * this.record_sz;
        try {
            this.mainBIS.seek(n2);
            int n3 = this.mainBIS.read(this.recordBuffer, 0, this.record_sz);
            if (n3 == -1) {
                return null;
            }
        }
        catch (IOException iOException) {
            System.out.println("read error: bad record");
            return null;
        }
        if (this.recordBuffer[0] == 42) {
            System.err.println("Record " + n + " has been deleted.");
            return null;
        }
        return this.recordBuffer;
    }

    public String getFieldData(int n, byte[] byArray) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index");
            return null;
        }
        if (byArray == null) {
            return null;
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 += this.fields[i].field_len;
        }
        try {
            return new String(byArray, n2, (int)this.fields[n].field_len, this.charsetFound).trim();
        }
        catch (Exception exception) {
            return new String(byArray, n2, (int)this.fields[n].field_len).trim();
        }
    }

    DBFieldDesc getFieldDesc(int n) {
        if (n < 0 || n >= this.n_fields) {
            return null;
        }
        return this.fields[n];
    }

    public int getFieldLength(int n) {
        if (n < 0 || n >= this.n_fields) {
            return -1;
        }
        return this.fields[n].field_len;
    }

    public String getFieldName(int n) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index !");
            return null;
        }
        String string = new String(this.fields[n].name);
        int n2 = string.indexOf(0);
        return string.substring(0, n2);
    }

    private void ensureFieldsCache() {
        if (this.fieldNamesLowerCache != null && this.fieldTypesCache != null) {
            return;
        }
        if (this.mainBIS == null) {
            throw new IllegalStateException("DBF is not opened yet.");
        }
        String[] stringArray = new String[this.n_fields];
        byte[] byArray = new byte[this.n_fields];
        for (int i = 0; i < this.n_fields; ++i) {
            stringArray[i] = this.getFieldName(i).toLowerCase();
            byArray[i] = this.getFieldType(i);
        }
        this.fieldNamesLowerCache = stringArray;
        this.fieldTypesCache = byArray;
    }

    public String[] getFieldNames() {
        this.ensureFieldsCache();
        return Arrays.copyOf(this.fieldNamesLowerCache, this.fieldNamesLowerCache.length);
    }

    public byte[] getFieldTypes() {
        this.ensureFieldsCache();
        return Arrays.copyOf(this.fieldTypesCache, this.fieldTypesCache.length);
    }

    public byte getFieldType(int n) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index !");
            return 0;
        }
        int n2 = this.fields[n].field_type;
        if (n2 == 78 && this.fields[n].decimal_cnt == 0) {
            n2 = 73;
        }
        return (byte)n2;
    }

    public void print() {
        System.out.println("\nDBF attributes: ");
        int n = 0;
        int n2 = 0;
        while (n < this.n_fields) {
            System.out.print(new String(this.fields[n].name) + " [" + (char)this.fields[n].field_type + "," + this.fields[n].field_len + "], ");
            if (n2 == 4) {
                n2 = 0;
                System.out.print("\n");
            }
            ++n;
            ++n2;
        }
        System.out.print("\n");
        System.out.println("record_sz=" + this.record_sz + ", #records=" + this.n_records + ", #fields=" + this.n_fields);
    }

    public String getCodePage() {
        return this.codePage;
    }

    public byte getCodePageMark() {
        DBFileHdr dBFileHdr = this.file_hdr;
        if (dBFileHdr != null) {
            return dBFileHdr.codePageMark;
        }
        return 0;
    }

    public Charset getCharset() {
        return this.charsetFound;
    }

    public static class LogicalColumn
    extends RecordColumn {
        public LogicalColumn(byte[] byArray) {
            super(byArray);
        }

        @Override
        public byte getType() {
            return 76;
        }

        @Override
        public int getLength() {
            return 1;
        }
    }

    public static class NumericColumn
    extends RecordColumn {
        protected int columnLength;
        protected int columnDecimalDigits;

        public NumericColumn(byte[] byArray, int n, int n2) {
            super(byArray);
            this.columnLength = n;
            this.columnDecimalDigits = n2;
        }

        @Override
        public int getDecimalDigits() {
            return this.columnDecimalDigits;
        }

        @Override
        public byte getType() {
            return 78;
        }

        @Override
        public int getLength() {
            return this.columnLength;
        }
    }

    public static class DateColumn
    extends RecordColumn {
        public DateColumn(byte[] byArray) {
            super(byArray);
        }

        @Override
        public byte getType() {
            return 68;
        }

        @Override
        public int getLength() {
            return 8;
        }
    }

    public static class CharacterColumn
    extends RecordColumn {
        protected int columnLength;

        public CharacterColumn(byte[] byArray, int n) {
            super(byArray);
            this.columnLength = n;
        }

        @Override
        public byte getType() {
            return 67;
        }

        @Override
        public int getLength() {
            return this.columnLength;
        }
    }

    public static abstract class RecordColumn {
        protected byte[] columnName;
        protected Vector values;

        public RecordColumn(byte[] byArray) {
            if (byArray.length == 11) {
                this.columnName = byArray;
            } else {
                int n;
                byte[] byArray2 = new byte[11];
                for (n = 0; n < byArray.length && n < 10; ++n) {
                    byArray2[n] = byArray[n];
                }
                while (n < 11) {
                    byArray2[n] = 0;
                    ++n;
                }
                this.columnName = byArray2;
            }
            this.values = new Vector();
        }

        public void addValue(byte[] byArray) {
            if (byArray.length == this.getLength()) {
                this.values.addElement(byArray);
            } else {
                int n;
                byte[] byArray2 = new byte[this.getLength()];
                for (n = 0; n < byArray.length; ++n) {
                    byArray2[n] = byArray[n];
                }
                while (n < this.getLength()) {
                    byArray2[n] = 32;
                    ++n;
                }
                this.values.addElement(byArray2);
            }
        }

        public byte[] getValue(int n) {
            return (byte[])this.values.elementAt(n);
        }

        public byte[] getName() {
            return this.columnName;
        }

        public int getNumValues() {
            return this.values.size();
        }

        public byte getType() {
            return 32;
        }

        public int getLength() {
            return 0;
        }

        public int getDecimalDigits() {
            return 0;
        }
    }
}

