/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum DBFFileCodePage {
    CP28591_ISO_8859_1(28591, "cp28591_ISO_8859_1_ISO_LATIN_1", 0, "ISO-8859-1"),
    CP20127_7_BIT_US_ASCII(20127, "cp20127_7_bit_US_ASCII", new int[0], new String[]{"US-ASCII", "IBM367"}),
    CP65001_UTF_8(65001, "cp65001_UTF_8", 240, "UTF-8"),
    CP437_OEM(437, "Cp437_OEM", new int[]{1, 9, 11, 13, 15, 17, 21, 24, 25, 27}, new String[]{"IBM437"}),
    CP850_OEM(850, "Cp850_OEM", new int[]{2, 10, 14, 29, 16, 18, 20, 22, 26, 37, 55}, new String[]{"IBM850"}),
    CP1252_WINDOWS_ANSI(1252, "cp1252_Windows_ANSI", new int[]{3, 87, 88, 89}, new String[]{"windows-1252"}),
    MAC_ROMAN_STANDARD_MACINTOSH(1000, "mac_roman_Standard_Macintosh", 4, "x-MacRoman"),
    CP865_OEM(865, "cp865_OEM", new int[]{8, 23, 102}, new String[]{"IBM865"}),
    CP932_JAPANESE_SHIFT_JIS(932, "MS932_Japanese_Shift_JIS", new int[]{19, 123}, new String[]{"Shift_JIS"}),
    CP863_OEM(863, "cp863_OEM", new int[]{28, 108}, new String[]{"IBM863"}),
    CP852_OEM(852, "cp852_OEM", new int[]{31, 34, 35, 64, 100, 135}, new String[]{"IBM852"}),
    CP860_PORTUGUESE_OEM(860, "cp860_Portuguese_OEM", 36, "IBM860"),
    CP866_RUSSIAN_OEM(866, "cp866_Russian_OEM", new int[]{38, 101}, new String[]{"IBM866"}),
    CP936_CHINESE_SIMPLIFIED_WINDOWS(936, "cp936_Chinese_Simplified_Windows", new int[]{122, 77}, new String[]{"GBK", "CP936", "windows-936"}),
    CP950_TRADITIONAL_CHINESE_WINDOWS(950, "cp950_Traditional_Chinese_Windows", new int[]{120, 79}, new String[]{"x-IBM950", "ibm950"}),
    CP874_THAI_ANSI_OEM(874, "cp874_Thai_ANSI_OEM", new int[]{80, 124}, new String[]{"x-IBM874", "ibm874"}),
    CP861_ICELANDIC_MS_DOS(861, "cp861_Icelandic_MS_DOS", 103, "IBM861"),
    KAMENICKY_CZECH_MS_DOS(895, "Kamenicky_Czech_MS_DOS", 104, new String[]{"JIS_X0201", "JIS0201", "csHalfWidthKatakana"}),
    MAZOVIA_POLISH_MS_DOS(620, "Mazovia_Polish_MS_DOS", 105, new String[]{"cp667", "cp790", "cp991", "MAZ"}),
    CP737_GREEK_MS_DOS_437G(737, "cp737_Greek_MS_DOS_437G", new int[]{106, 134}, new String[]{"x-IBM737", "ibm737"}),
    CP857_TURKISH_OEM(857, "cp857_Turkish_OEM", new int[]{136, 107}, new String[]{"IBM857"}),
    CP949_KOREAN_WINDOWS(949, "cp949_Korean_Windows", new int[]{121, 78}, new String[]{"x-IBM949", "ibm949"}),
    CP1255_HEBREW_WINDOWS(1255, "cp1255_Hebrew_Windows", 125, "windows-1255"),
    CP1256_ARABIC_WINDOWS(1256, "cp1256_Arabic_Windows", 126, "windows-1256"),
    MAC_CYRILLIC_RUSSIAN_MACINTOSH(10007, "mac_cyrillic_Russian_Macintosh", 150, new String[]{"cp1283", "x-mac-cyrillic", "x-MacCyrillic"}),
    MAC_LATIN2_MACINTOSH_EE(10029, "mac_latin2_Macintosh_CE", 151, new String[]{"x-mac-ce", "x-MacCentralEurope"}),
    MAC_GREEK_MACINTOSH(10006, "mac_Greek_Macintosh", 152, "x-MacGreek"),
    CP1250_EASTERN_EUROPEAN_WINDOWS(1250, "cp1250_Eastern_European_Windows", 200, new String[]{"windows-1250", "cp5346"}),
    CP1251_RUSSIAN_WINDOWS(1251, "cp1251_Russian_Windows", 201, new String[]{"windows-1251", "cp5347"}),
    CP1254_TURKISH_WINDOWS(1254, "cp1254_Turkish_Windows", 202, new String[]{"windows-1254", "cp5350"}),
    CP1253_GREEK_WINDOWS(1253, "cp1253_Greek_Windows", 203, new String[]{"windows-1253", "cp5349"}),
    CP1257_BALTIC_WINDOWS(1257, "cp1257_Baltic_Windows", 204, new String[]{"windows-1257", "cp5353"});

    private static final DBFFileCodePage[] reverseLookupsByCodePageMark;
    private static final Map<String, DBFFileCodePage> reverseLookupsByCharsetAliases;
    private final int codePage;
    private final String platform;
    private final int[] codePageMarks;
    private final String[] charsetAliases;
    private Charset charsetCache;

    private static void validateUniqueCodePages() {
        HashMap<Integer, DBFFileCodePage> hashMap = new HashMap<Integer, DBFFileCodePage>();
        for (DBFFileCodePage dBFFileCodePage : DBFFileCodePage.values()) {
            int n = dBFFileCodePage.codePage;
            DBFFileCodePage dBFFileCodePage2 = hashMap.putIfAbsent(n, dBFFileCodePage);
            if (dBFFileCodePage2 != null) {
                throw new AssertionError((Object)("Enum item " + dBFFileCodePage.name() + " contains a Code Page used by " + dBFFileCodePage2.name() + ": " + n));
            }
        }
    }

    private static void validateUniqueCodePageMarks() {
        HashMap<Integer, DBFFileCodePage> hashMap = new HashMap<Integer, DBFFileCodePage>();
        for (DBFFileCodePage dBFFileCodePage : DBFFileCodePage.values()) {
            for (int n : dBFFileCodePage.codePageMarks) {
                DBFFileCodePage dBFFileCodePage2 = hashMap.putIfAbsent(n, dBFFileCodePage);
                if (dBFFileCodePage2 != null) {
                    throw new AssertionError((Object)("Enum item " + dBFFileCodePage.name() + " contains a Code Page Mark used by " + dBFFileCodePage2.name() + ": 0x" + n + " (dec " + n + ")"));
                }
            }
        }
    }

    private static void validateUniqueCharsetAliases() {
        HashMap<String, DBFFileCodePage> hashMap = new HashMap<String, DBFFileCodePage>();
        for (DBFFileCodePage dBFFileCodePage : DBFFileCodePage.values()) {
            for (String string : dBFFileCodePage.charsetAliases) {
                DBFFileCodePage dBFFileCodePage2 = hashMap.putIfAbsent(string.toLowerCase(Locale.ENGLISH), dBFFileCodePage);
                if (dBFFileCodePage2 != null && dBFFileCodePage2 != dBFFileCodePage) {
                    throw new AssertionError((Object)("Enum item " + dBFFileCodePage.name() + " contains a Charset alias used by " + dBFFileCodePage2.name() + ": " + string));
                }
            }
        }
    }

    private static DBFFileCodePage[] generateLookupsByCodePageMark() {
        DBFFileCodePage[] dBFFileCodePageArray = new DBFFileCodePage[256];
        for (DBFFileCodePage dBFFileCodePage : DBFFileCodePage.values()) {
            for (int n : dBFFileCodePage.codePageMarks) {
                dBFFileCodePageArray[n] = dBFFileCodePage;
            }
        }
        return dBFFileCodePageArray;
    }

    private static Map<String, DBFFileCodePage> generateLookupsByCharsetAliases() {
        HashMap<String, DBFFileCodePage> hashMap = new HashMap<String, DBFFileCodePage>();
        for (DBFFileCodePage dBFFileCodePage : DBFFileCodePage.values()) {
            for (String string : dBFFileCodePage.charsetAliases) {
                hashMap.put(string.toLowerCase(Locale.ENGLISH), dBFFileCodePage);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private DBFFileCodePage(int n2, String string2, int n3, String string3) {
        String[] stringArray;
        if (string3 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        this(n2, string2, n3, stringArray);
    }

    private DBFFileCodePage(int n2, String string2, int n3, String[] stringArray) {
        this(n2, string2, new int[]{n3}, stringArray);
    }

    private DBFFileCodePage(int n2, String string2, int[] nArray, String[] stringArray) {
        this.validateArgs(n2, string2, nArray, stringArray);
        this.codePage = n2;
        this.platform = string2;
        this.codePageMarks = nArray;
        this.charsetAliases = DBFFileCodePage.buildAliases(n2, stringArray);
    }

    private static String[] buildAliases(int n, String[] stringArray) {
        boolean bl = stringArray != null && stringArray.length > 0;
        String[] stringArray2 = new String[2 + (bl ? stringArray.length : 0)];
        stringArray2[0] = DBFFileCodePage.toCodePageName_cp(n);
        stringArray2[1] = DBFFileCodePage.toCodePageName_Cp(n);
        if (bl) {
            System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        }
        return stringArray2;
    }

    private static String toCodePageName_cp(int n) {
        return "cp" + n;
    }

    private static String toCodePageName_Cp(int n) {
        return "Cp" + n;
    }

    public static DBFFileCodePage fromCodePageMark(byte by) {
        return reverseLookupsByCodePageMark[DBFFileCodePage.toUnsignedByte(by)];
    }

    private static int toUnsignedByte(byte by) {
        return by & 0xFF;
    }

    public static DBFFileCodePage fromCharsetName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("'charsetName' cannot be null or empty");
        }
        return reverseLookupsByCharsetAliases.get(string.toLowerCase(Locale.ENGLISH));
    }

    public static DBFFileCodePage fromCodePage(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("'codePage' must be greater than zero");
        }
        DBFFileCodePage dBFFileCodePage = DBFFileCodePage.fromCharsetName(DBFFileCodePage.toCodePageName_cp(n));
        return dBFFileCodePage != null ? dBFFileCodePage : DBFFileCodePage.fromCharsetName(DBFFileCodePage.toCodePageName_Cp(n));
    }

    private void validateArgs(int n, String string, int[] nArray, String[] stringArray) {
        if (n <= 0) {
            throw new AssertionError((Object)("Enum contains negative Code Page for '" + n + " - " + string + "'"));
        }
        if (string == null || string.trim().isEmpty()) {
            throw new AssertionError((Object)("Enum contains null or blank platform for '" + n + "'"));
        }
        if (nArray == null) {
            throw new AssertionError((Object)"Enum has null codePageMarks array");
        }
        for (int n3 : nArray) {
            if (n3 < 0 || n3 > 255) {
                throw new AssertionError((Object)("Enum contains a Code Page Mark outside of byte boundaries for '" + n + " - " + string + "': 0x" + Integer.toHexString(n3) + " (dec " + n3 + ")"));
            }
        }
        if (stringArray == null) {
            throw new AssertionError((Object)"Enum has null charsetAliases array");
        }
        for (String string2 : stringArray) {
            if (string2 == null || string2.trim().isEmpty()) {
                throw new AssertionError((Object)("Enum contains a null or blank Charset alias '" + n + " - " + string + "'"));
            }
        }
    }

    public int getCodePage() {
        return this.codePage;
    }

    public String getPlatform() {
        return this.platform;
    }

    public byte[] getCodePageMarks() {
        byte[] byArray = new byte[this.codePageMarks.length];
        for (int i = 0; i < this.codePageMarks.length; ++i) {
            byArray[i] = (byte)this.codePageMarks[i];
        }
        return byArray;
    }

    public String[] getCharsetAliases() {
        return Arrays.copyOf(this.charsetAliases, this.charsetAliases.length);
    }

    public Charset toCharset() {
        if (this.charsetCache == null) {
            for (String string : this.charsetAliases) {
                Charset charset = DBFFileCodePage.lookupJVMCharset(string);
                if (charset == null) continue;
                this.charsetCache = charset;
                return this.charsetCache;
            }
            throw new UnsupportedCharsetException(Arrays.toString(this.charsetAliases));
        }
        return this.charsetCache;
    }

    static Charset lookupJVMCharset(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'charsetName' cannot be null");
        }
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new AssertionError((Object)unsupportedCharsetException);
            }
        }
        return null;
    }

    static {
        DBFFileCodePage.validateUniqueCodePages();
        DBFFileCodePage.validateUniqueCodePageMarks();
        DBFFileCodePage.validateUniqueCharsetAliases();
        reverseLookupsByCodePageMark = DBFFileCodePage.generateLookupsByCodePageMark();
        reverseLookupsByCharsetAliases = DBFFileCodePage.generateLookupsByCharsetAliases();
    }
}

