/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends BufferedInputStream {
    public static final int DEFAULT_BUFFER_SIZE_BYTES = 8192;
    private static final String READ_ONLY_MODE = "r";
    private final RandomAccessFile randomAccessFile;
    private final int bufferSize;
    private long lastPosition;

    public BufferedRandomAccessFile(String string) throws IOException {
        this(string != null ? new File(string) : null, 8192);
    }

    public BufferedRandomAccessFile(String string, int n) throws IOException {
        this(string != null ? new File(string) : null, n);
    }

    public BufferedRandomAccessFile(File file) throws IOException {
        this(file, 8192);
    }

    public BufferedRandomAccessFile(File file, int n) throws IOException {
        this(file, n, null);
    }

    private BufferedRandomAccessFile(File file, int n, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile = new RandomAccessFile(file, READ_ONLY_MODE);
        super(BufferedRandomAccessFile.openFileAsInputStream(BufferedRandomAccessFile.validateParams(file, n), randomAccessFile), n);
        this.randomAccessFile = randomAccessFile;
        this.bufferSize = n;
        this.lastPosition = 0L;
        this.resetBufferPositions();
    }

    private static Object validateParams(File file, int n) {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("'bufferSize' must be greater than zero.");
        }
        return null;
    }

    private static InputStream openFileAsInputStream(Object object, RandomAccessFile randomAccessFile) throws IOException {
        try {
            return new FileInputStream(randomAccessFile.getFD());
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error when creating FileInputStream from RandomAccessFile", exception);
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException2) {
                iOException.addSuppressed(iOException2);
            }
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (Exception exception) {
            iOException = new IOException(exception);
        }
        try {
            this.randomAccessFile.close();
        }
        catch (Exception exception) {
            if (iOException == null) {
                iOException = new IOException(exception);
            }
            iOException.addSuppressed(exception);
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public long getFilePointer() throws IOException {
        return this.pos;
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public void seek(long l) throws IOException {
        if (this.lastPosition == l) {
            return;
        }
        this.randomAccessFile.seek(l);
        this.resetBufferPositions();
        this.lastPosition = l;
    }

    public void resetBufferPositions() {
        this.pos = 0;
        this.count = 0;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.lastPosition;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n != -1) {
            this.lastPosition += (long)n;
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.lastPosition += (long)n3;
        }
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.lastPosition += l2;
        }
        return l2;
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }
}

