/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlWrappedComponentImpl;
import oracle.javatools.ui.Borders;

public class XmlTableCellRenderer
extends DefaultTableCellRenderer {
    private XmlComponentWrapper _xmlComponentWrapper;
    private int _column;
    private ArrayList<XmlComponentWrapper> _columnXmlComponentWrapperList;

    public XmlTableCellRenderer(XmlComponentWrapper xmlComponentWrapper, int column, ArrayList<XmlComponentWrapper> columnXmlComponentWrapperList) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        this._column = column;
        this._columnXmlComponentWrapperList = columnXmlComponentWrapperList;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent tableCellRendererComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        tableCellRendererComponent.setBorder(null);
        tableCellRendererComponent.setToolTipText(null);
        XmlComponentWrapper columnXmlComponentWrapper = this._columnXmlComponentWrapperList.get(this._column);
        Component tableCellComponent = this._columnXmlComponentWrapperList.get(this._column).getXmlWrappedComponent().getWrappedComponent();
        if (tableCellComponent instanceof JToggleButton) {
            tableCellRendererComponent = (JComponent)tableCellComponent;
            this.renderToggleButton(tableCellRendererComponent, value);
        }
        int modelIndex = table.convertRowIndexToModel(row);
        XmlComponentModel cellXmlComponentModel = AbstractXmlTableEditor.getCellXmlComponentModel(this._xmlComponentWrapper.getXmlComponentModel(), columnXmlComponentWrapper, modelIndex);
        if (cellXmlComponentModel != null) {
            cellXmlComponentModel.checkForErrorsAndWarnings();
            if (cellXmlComponentModel.modelValueContainsError() || cellXmlComponentModel.modelValueContainsWarning()) {
                XmlTableCellRenderer.highlightErrorOrWarning(tableCellRendererComponent, cellXmlComponentModel);
                return tableCellRendererComponent;
            }
            XmlTableCellRenderer.highlightRequiredValue(tableCellRendererComponent, value, cellXmlComponentModel, columnXmlComponentWrapper);
        }
        tableCellRendererComponent.setEnabled(table.isEnabled());
        return tableCellRendererComponent;
    }

    public void renderToggleButton(JComponent tableCellRendererComponent, Object value) {
        JToggleButton jToggleButton = (JToggleButton)tableCellRendererComponent;
        if (value != null) {
            if ("true".equals(value)) {
                jToggleButton.setSelected(true);
            } else {
                jToggleButton.setSelected(false);
            }
        } else {
            jToggleButton.setSelected(false);
        }
    }

    public static void highlightErrorOrWarning(Object tableCellComponent, XmlComponentModel tableCellXmlComponentModel) {
        if (tableCellXmlComponentModel != null) {
            if (tableCellXmlComponentModel.modelValueContainsError()) {
                Borders.attachErrorBorder((JComponent)((JComponent)tableCellComponent));
                String errorMessage = tableCellXmlComponentModel.getCurrentErrorMessage();
                if (errorMessage != null) {
                    ((JComponent)tableCellComponent).setToolTipText(errorMessage);
                }
            } else if (tableCellXmlComponentModel.modelValueContainsWarning()) {
                Borders.attachWarningBorder((JComponent)((JComponent)tableCellComponent));
                String warningMessage = tableCellXmlComponentModel.getCurrentWarningMessage();
                if (warningMessage != null) {
                    ((JComponent)tableCellComponent).setToolTipText(warningMessage);
                }
            }
        }
    }

    public static void highlightRequiredValue(Object tableCellComponent, Object value, XmlComponentModel tableCellXmlComponentModel, XmlComponentWrapper columnXmlComponentWrapper) {
        String stringValue;
        boolean missingValue = false;
        if (value == null) {
            missingValue = true;
        } else if (value instanceof String && (stringValue = (String)value).length() == 0) {
            missingValue = true;
        }
        if (missingValue && tableCellXmlComponentModel.isRequired().booleanValue()) {
            Borders.attachErrorBorder((JComponent)((JComponent)tableCellComponent));
            String errorMessage = XmlWrappedComponentImpl.createRequiredValueMessage(columnXmlComponentWrapper);
            if (errorMessage != null) {
                ((JComponent)tableCellComponent).setToolTipText(errorMessage);
            }
        } else {
            Borders.restoreBorder((JComponent)((JComponent)tableCellComponent));
            ((JComponent)tableCellComponent).setToolTipText(null);
        }
    }
}

