/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableToolbar;

public class XmlGenericTableAdapter
extends AbstractXmlTableAdapter {
    private TableToolbar _toolBar;

    public XmlGenericTableAdapter(XmlTableEditor xmlTableEditor) {
        super(xmlTableEditor);
    }

    @Override
    protected DefaultTableModel createTableModel() {
        return new ElementTableModel();
    }

    @Override
    protected JTable createTable() {
        EditCellAtDelegateTable editCellAtDelegateTable = new EditCellAtDelegateTable(this.getXmlTableEditor().getTableModel());
        editCellAtDelegateTable.setEditCellAtDelegate(new EditCellAtDelegate(editCellAtDelegateTable, this.getXmlTableEditor()));
        return editCellAtDelegateTable;
    }

    @Override
    protected JPanel createTablePanel() {
        JScrollPane tableScrollPane = new JScrollPane(this.getTable());
        ResizeComponent rc = new ResizeComponent((JComponent)tableScrollPane);
        ReorderableTableWithTitleBar tablePanel = new ReorderableTableWithTitleBar(this.getXmlTableEditor().getTable(), (JComponent)rc, this.getXmlTableEditor().getShowReorderableRowButtons(), true);
        this.configureGenericTable();
        this.configureToolbar(tablePanel);
        return tablePanel;
    }

    protected void configureGenericTable() {
        GenericTable genericTable = (GenericTable)this.getXmlTableEditor().getTable();
        TableHelper.installTableTransferHandler((JTable)genericTable, (boolean)true);
        genericTable.setRowHeader(genericTable.createDefaultRowHeader());
        genericTable.setSelectAllEnabled(true);
        genericTable.setColumnSelectorAvailable(false);
        genericTable.setSelectColumnsAction((Action)new AbstractAction("Select Columns...", OracleIcons.getIcon((String)"table.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)XmlGenericTableAdapter.this.getTable()), "Customize Table Columns");
                d.setContent((Component)new JLabel("Client Specific Option. This is just a demo"));
                d.pack();
                d.runDialog();
            }
        });
        genericTable.setPreferredVisibleRowCount(this.getTable().getRowCount());
        this.getTable().setPreferredScrollableViewportSize(new Dimension(this.getMinWidth(), this.getTable().getPreferredScrollableViewportSize().height));
    }

    protected void configureToolbar(ReorderableTableWithTitleBar tablePanel) {
        this.setToolBar(tablePanel.getTableToolbar());
        this.getToolBar().setLabel(this.getXmlTableEditor().getXmlComponentModel().getShortDisplayName());
        this.getToolBar().setAddVisible(true);
        this.getToolBar().setDefaultAddAction(this.getXmlTableEditor().createAddAction());
        this.getToolBar().setEditVisible(false);
        this.getToolBar().setDefaultEditAction((Action)new EditAction());
        this.getToolBar().setDeleteVisible(true);
        this.getToolBar().setDefaultDeleteAction(this.getXmlTableEditor().createDeleteAction());
        this.getToolBar().setClearVisible(false);
        this.getToolBar().setDefaultClearAction(this.getToolBar().getDefaultAction(TableToolbar.ToolAction.CLEAR));
        this.getToolBar().setCopyVisible(false);
        this.getToolBar().setDefaultCopyAction(this.getToolBar().getDefaultAction(TableToolbar.ToolAction.COPY));
        this.getToolBar().setPasteVisible(false);
        this.getToolBar().setDefaultPasteAction(this.getToolBar().getDefaultAction(TableToolbar.ToolAction.PASTE));
        this.getToolBar().setDuplicateVisible(false);
        this.getToolBar().setDefaultDuplicateAction(this.getToolBar().getDefaultAction(TableToolbar.ToolAction.DUPLICATE_ROW));
    }

    protected TableToolbar getToolBar() {
        return this._toolBar;
    }

    protected void setToolBar(TableToolbar toolBar) {
        this._toolBar = toolBar;
    }

    @Override
    public void updateAddDeleteButtons() {
        this.getToolBar().setAddVisible(true);
        this.getToolBar().setDeleteVisible(true);
        this.getToolBar().setDeleteEnabled(this.getTableModel().getRowCount() > 0 && this.getTable().getSelectedRow() > -1);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getXmlTableEditor().getTablePanel() instanceof ReorderableTableWithTitleBar) {
            ReorderableTableWithTitleBar tableParentContainer = (ReorderableTableWithTitleBar)this.getXmlTableEditor().getTablePanel();
            tableParentContainer.getTableContainer().setEnabled(enabled);
            tableParentContainer.getTableToolbar().setEnabled(enabled);
            tableParentContainer.getTableToolbar().setAddEnabled(enabled);
            if (enabled) {
                tableParentContainer.getTableToolbar().setDeleteEnabled(this.getTableModel().getRowCount() > 0 && this.getTable().getSelectedRow() > -1);
            } else {
                tableParentContainer.getTableToolbar().setDeleteEnabled(enabled);
            }
            this._enableTitle((Container)tableParentContainer.getTableToolbar(), enabled);
        }
        this.getTable().setEnabled(enabled);
    }

    private void _enableTitle(Container container, boolean enabled) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JLabel) {
                ((JLabel)component).setEnabled(enabled);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this._enableTitle((Container)component, enabled);
        }
    }

    public class EditCellAtDelegateTable
    extends ElementTable {
        private EditCellAtDelegate _editCellAtDelegate;

        public EditCellAtDelegateTable(TableModel tableModel) {
            super(tableModel);
        }

        public boolean superEditCellAt(int row, int column, EventObject e) {
            return super.editCellAt(row, column, e);
        }

        public void superRemoveEditor() {
            super.removeEditor();
        }

        public void superRemoveNotify() {
            super.removeNotify();
        }

        public void setEditCellAtDelegate(EditCellAtDelegate editCellAtDelegate) {
            this._editCellAtDelegate = editCellAtDelegate;
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            if (this._editCellAtDelegate != null) {
                return this._editCellAtDelegate.editCellAt(row, column, e);
            }
            return super.editCellAt(row, column, e);
        }

        public void removeEditor() {
            if (this._editCellAtDelegate != null) {
                this._editCellAtDelegate.removeEditor();
                return;
            }
            super.removeEditor();
        }

        public void removeNotify() {
            if (this._editCellAtDelegate != null) {
                this._editCellAtDelegate.removeEditor();
                return;
            }
            super.removeNotify();
        }
    }

    public class EditCellAtDelegate {
        private CellEditorRemover _editorRemover = null;
        private EditCellAtDelegateTable _table;
        private XmlTableEditor _xmlTableEditor;

        public EditCellAtDelegate(EditCellAtDelegateTable table, XmlTableEditor xmlTableEditor) {
            this._table = table;
            this._xmlTableEditor = xmlTableEditor;
        }

        public EditCellAtDelegateTable getTable() {
            return this._table;
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            if (this._editorRemover == null) {
                KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this._editorRemover = new CellEditorRemover(fm);
                fm.addPropertyChangeListener("permanentFocusOwner", this._editorRemover);
            }
            boolean editCellResult = this.getTable().superEditCellAt(row, column, e);
            return editCellResult;
        }

        public void removeEditor() {
            this.getTable().superRemoveEditor();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
            this._editorRemover = null;
        }

        public void removeNotify() {
            this.getTable().superRemoveNotify();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
            this._editorRemover = null;
        }

        public class CellEditorRemover
        implements PropertyChangeListener {
            KeyboardFocusManager focusManager;

            public CellEditorRemover(KeyboardFocusManager fm) {
                this.focusManager = fm;
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                XmlGenericTableAdapter.this.getXmlTableEditor().onPermanentFocusOwnerChange(ev, this.focusManager);
            }

            public JPanel getTablePanel() {
                return EditCellAtDelegate.this._xmlTableEditor.getTablePanel();
            }

            public Component getCurrentTableCellEditorComponent() {
                return EditCellAtDelegate.this._xmlTableEditor.getCurrentTableCellEditorComponent();
            }
        }
    }

    protected class ElementTableModel
    extends AbstractXmlTableAdapter.AbstractXmlTableModel
    implements EditableTableModel,
    GenericTableModel {
        public void insertColumn(int column, Object columnName, Object[] columnData) {
        }

        public void removeColumn(int column) {
        }

        public int duplicateRow(int row, int nCopy) {
            Object[] rowData = new Object[this.getColumnCount()];
            for (int i = 0; i < rowData.length; ++i) {
                rowData[i] = i == 0 ? "Copy of " + this.getValueAt(row, i) : this.getValueAt(row, i);
            }
            this.insertRow(row + 1, rowData);
            return row + 1;
        }

        public int duplicateColumn(int col, int nCopy) {
            return -1;
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public boolean canHide(int column) {
            return column != 2;
        }
    }

    protected class ElementTable
    extends GenericTable {
        private int mMinVisibleRowCount;
        private int mMaxVisibleRowCount;
        private int mVisibleRowCount;

        public ElementTable(TableModel tableModel) {
            super(tableModel);
            this.mMinVisibleRowCount = 1;
            this.mMaxVisibleRowCount = 6;
            this.mVisibleRowCount = -1;
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (ElementTable.this.getRowCount() != ElementTable.this.mVisibleRowCount) {
                        ElementTable.this.resizeViewport();
                    }
                    if (tableModelEvent.getType() == 1) {
                        int firstRow = tableModelEvent.getFirstRow();
                        int columnCount = ElementTable.this.getColumnCount();
                        for (int column = 0; column < columnCount; ++column) {
                            if (!ElementTable.this.isCellEditable(firstRow, column)) continue;
                            ElementTable.this.editCellAt(firstRow, column);
                            break;
                        }
                    }
                }
            });
            this.setRowHeight(new JTextField().getPreferredSize().height);
        }

        public int getMinVisibleRowCount() {
            return this.mMinVisibleRowCount;
        }

        public void setMinVisibleRowCount(int minVisibleRowCount) {
            this.mMinVisibleRowCount = minVisibleRowCount;
        }

        public int getMaxVisibleRowCount() {
            return this.mMaxVisibleRowCount;
        }

        public void setMaxVisibleRowCount(int maxVisibleRowCount) {
            this.mMaxVisibleRowCount = maxVisibleRowCount;
        }

        public boolean isFocusable() {
            return this.getRowCount() > 0;
        }

        public void addNotify() {
            super.addNotify();
            this.resizeViewport();
        }

        public void resizeViewport() {
            int currentRowCount = this.getRowCount();
            this.mVisibleRowCount = Math.min(currentRowCount, this.mMaxVisibleRowCount);
            this.mVisibleRowCount = Math.max(this.mVisibleRowCount, this.mMinVisibleRowCount);
            Dimension preferredScrollableViewportSize = this.getPreferredScrollableViewportSize();
            preferredScrollableViewportSize.height = this.getRowHeight() * this.mVisibleRowCount;
            this.setPreferredScrollableViewportSize(preferredScrollableViewportSize);
            Container ancestor = SwingUtilities.getAncestorOfClass(ResizeComponent.class, (Component)((Object)this));
            if (ancestor != null && ancestor instanceof JComponent) {
                ((JComponent)ancestor).revalidate();
            }
        }

        public void stopCellEditing() {
            TableCellEditor cellEditor = this.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (XmlGenericTableAdapter.this.getTable().getRowSelectionAllowed() || XmlGenericTableAdapter.this.getTable().getColumnSelectionAllowed()) {
                int row = XmlGenericTableAdapter.this.getTable().getSelectedRow();
                int col = XmlGenericTableAdapter.this.getTable().getSelectedColumn();
                if (row != -1 && col != -1) {
                    TableHelper.stopCellEditing((JTable)XmlGenericTableAdapter.this.getTable());
                    JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)XmlGenericTableAdapter.this.getToolBar()), "Edit Cell/Row (Use Case Specific)");
                    JLabel label = new JLabel("Enter the data for the new row or column");
                    JTextField jt = new JTextField(20);
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)label, "North");
                    p.add((Component)jt, "Center");
                    d.setContent((Component)p);
                    Object value = XmlGenericTableAdapter.this.getTable().getModel().getValueAt(row, col);
                    if (value != null) {
                        jt.setText(value.toString());
                    }
                    if (d.runDialog()) {
                        XmlGenericTableAdapter.this.getTable().getModel().setValueAt(jt.getText(), row, col);
                    }
                }
            }
        }
    }
}

