/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.GuiEventProcessor;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.model.XmlModelEvent;

public class SwingGuiEventProcessor
extends GuiEventProcessor {
    private XmlModelEvent _queuedEvent = null;
    private final XmlGui _gui;
    private final Object _queueLock = new Object();
    private static final Logger _LOGGER = Logger.getLogger(SwingGuiEventProcessor.class.getName());

    public SwingGuiEventProcessor(XmlGui gui) {
        this._gui = gui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(XmlGui gui, XmlModelEvent event) {
        assert (gui == this._gui);
        XmlModelEvent currEvent = event;
        if (SwingUtilities.isEventDispatchThread()) {
            SwingGuiEventProcessor._log("On event thread, sending now along with any queued events.", gui, event);
            Object object = this._queueLock;
            synchronized (object) {
                if (this._queuedEvent != null) {
                    currEvent = this._queuedEvent;
                    this._queuedEvent = null;
                    currEvent.addModelEvent(event);
                }
            }
            this.passEventToGui(gui, currEvent);
        } else {
            SwingGuiEventProcessor._log("Adding to queue.", gui, event);
            Object object = this._queueLock;
            synchronized (object) {
                boolean nothingQueuedBefore;
                boolean bl = nothingQueuedBefore = this._queuedEvent == null;
                if (nothingQueuedBefore) {
                    this._queuedEvent = (XmlModelEvent)event.clone();
                } else {
                    this._queuedEvent.addModelEvent(event);
                }
                if (nothingQueuedBefore) {
                    _LOGGER.log(Level.FINER, "Invoking later for gui {0}", gui);
                    SwingUtilities.invokeLater(new Invoker());
                }
            }
        }
    }

    private static void _log(String msg, XmlGui gui, XmlModelEvent event) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, msg + " gui={0} event={1}", new Object[]{gui, event});
        }
    }

    private class Invoker
    implements Runnable {
        private Invoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XmlModelEvent toDeliver;
            assert (SwingUtilities.isEventDispatchThread());
            Object object = SwingGuiEventProcessor.this._queueLock;
            synchronized (object) {
                if (SwingGuiEventProcessor.this._queuedEvent == null) {
                    return;
                }
                toDeliver = SwingGuiEventProcessor.this._queuedEvent;
                SwingGuiEventProcessor.this._queuedEvent = null;
            }
            SwingGuiEventProcessor._log("Delivering later.", SwingGuiEventProcessor.this._gui, toDeliver);
            assert (toDeliver != null);
            toDeliver.prepareForDelivery();
            SwingGuiEventProcessor.this.passEventToGui(SwingGuiEventProcessor.this._gui, toDeliver);
        }
    }
}

