/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.text.Position;
import oracle.bali.xml.gui.swing.util.Pickable;

public class PickableList
extends JList {
    public PickableList(Object[] pickables) {
        super(pickables);
        this._finishInit();
    }

    public PickableList(ListModel listModel) {
        super(listModel);
        this._finishInit();
    }

    private void _finishInit() {
        this.setCellRenderer(new PickableListCellRenderer());
        this.getSelectionModel().setSelectionMode(0);
    }

    public Pickable getSelectedPickable() {
        Object selectedValue = this.getSelectedValue();
        if (selectedValue instanceof Pickable) {
            return (Pickable)selectedValue;
        }
        return null;
    }

    @Override
    public int getNextMatch(String text, int start, Position.Bias bias) {
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String name;
            if (!(model.getElementAt(i) instanceof Pickable) || (name = ((Pickable)model.getElementAt(i)).getDisplayName().toLowerCase()).compareTo(text) < 0) continue;
            this.ensureIndexIsVisible(i);
            return i;
        }
        return start - 1;
    }

    private class PickableListCellRenderer
    extends DefaultListCellRenderer {
        private PickableListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (component instanceof JLabel && value instanceof Pickable) {
                JLabel label = (JLabel)component;
                Pickable pickable = (Pickable)value;
                label.setIcon(pickable.getIcon());
                label.setText(pickable.getDisplayName());
            }
            return component;
        }
    }
}

