/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.dnd.DefaultDragGestureRecognizer;
import oracle.bali.xml.gui.swing.dnd.DragGestureIdentifier;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.javatools.datatransfer.AugmentableTransferable;

public abstract class SwingPaletteDragListener
extends DragGestureIdentifier
implements ContainerListener,
DragGestureListener,
DragSourceListener {
    private final XmlGui _gui;

    public SwingPaletteDragListener(XmlGui gui, Component palette) {
        this._gui = gui;
        this._registerListeners(palette);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this._registerListeners(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this._unregisterListeners(e.getChild());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        XmlKey xmlKey = this.getXmlKey(dge);
        if (xmlKey != null && this.getView() != null) {
            AugmentableTransferable paletteTransferable = XmlTransferUtils.createXmlKeyTransferable((AbstractModel)this.getView(), (XmlKey)xmlKey);
            dge.startDrag(null, (Transferable)paletteTransferable, this);
            this.dragStarted(this._gui.getGuiContext(), (Transferable)paletteTransferable);
        }
    }

    protected abstract XmlKey getXmlKey(DragGestureEvent var1);

    @Override
    protected abstract boolean isDragPossible(MouseEvent var1);

    protected void dragStarted(GuiXmlContext context, Transferable t) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    protected void startDrag(MouseEvent currentEvent, MouseEvent armingEvent) {
        Component c = currentEvent.getComponent();
        DefaultDragGestureRecognizer ddgr = new DefaultDragGestureRecognizer(this);
        ddgr.requestDragStart(c, currentEvent, 2, 2);
    }

    protected XmlView getView() {
        return this._gui.getView();
    }

    private void _registerListeners(Component c) {
        this.registerListeners(c);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.addContainerListener(this);
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this._registerListeners(cont.getComponent(i));
            }
        }
    }

    private void _unregisterListeners(Component c) {
        this.unregisterListeners(c);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this._unregisterListeners(cont.getComponent(i));
            }
        }
    }
}

