/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JComponent;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.dnd.DefaultDragGestureRecognizer;
import oracle.bali.xml.gui.swing.dnd.DragGestureIdentifier;
import oracle.bali.xml.gui.swing.dnd.ModelDragHandler;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListHelper;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

class SwingTreeListDragHandler<ComponentType extends JComponent>
extends DragGestureIdentifier {
    private ComponentType _component;
    private SwingTreeListHelper<? extends XmlGui, ComponentType> _helper;

    public SwingTreeListDragHandler(SwingTreeListHelper<? extends XmlGui, ComponentType> helper, ComponentType component) {
        if (helper == null) {
            throw new IllegalArgumentException("helper is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        this._helper = helper;
        this._component = component;
    }

    public void dispose() {
        this.setDelegatee(null);
        this._component = null;
        this._helper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isDragPossible(MouseEvent e) {
        XmlGui gui = this._helper.getGui();
        XmlView view = gui.getView();
        if (!gui.isUserEditable()) {
            return false;
        }
        if (e.getClickCount() != 1) {
            return false;
        }
        view.acquireReadLock();
        try {
            Iterator itor = view.getSelection().getSelectedNodes();
            while (itor.hasNext()) {
                Rectangle bounds = this._helper.getBoundsIfVisible(this._component, (Node)itor.next());
                if (bounds == null || !bounds.contains(e.getPoint())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            view.releaseReadLock();
        }
        return false;
    }

    @Override
    protected void startDrag(MouseEvent currentEvent, MouseEvent armingEvent) {
        ModelDragHandler dragHandler = new ModelDragHandler(this._helper.getGui(), this._getDragImage(), armingEvent.getPoint());
        new DefaultDragGestureRecognizer(dragHandler).requestDragStart((Component)this._component, currentEvent, 3, 2);
    }

    private Image _getDragImage() {
        return null;
    }
}

