/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.dnd.DropMenuInvoker;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.OperationProcessor;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;

public abstract class DropHandlerHelper<ComponentType extends Component> {
    private transient OperationProcessor _processor;
    private transient Boolean _isPopupDrop;
    private final XmlGui _gui;
    private static final ClearDropLocationTask _CLEAR_DROP_LOCATION_TASK = new ClearDropLocationTask();
    private static final Logger _LOGGER = Logger.getLogger(DropHandlerHelper.class.getName());

    public DropHandlerHelper(XmlGui gui) {
        this._gui = gui;
    }

    public final XmlGui getGui() {
        return this._gui;
    }

    public final XmlView getView() {
        return this._gui.getView();
    }

    public final boolean performDrop(DropTargetDropEvent dropEvent) {
        if (this._isPopupDrop(dropEvent)) {
            return this._doPopupDrop(dropEvent);
        }
        return this._doRegularDrop(dropEvent);
    }

    public final void cleanupDrop() {
        this._cleanupDrop();
    }

    public final int considerPossibilitiesAndSetLocation(DropTargetDragEvent event) {
        int action = this._considerPossibilities(event, event.getLocation(), event.getSourceActions(), event.getDropAction());
        DomPosition dropPos = this._processor.getRepresentativeOperationPosition();
        this.setDropLocation(dropPos);
        return action;
    }

    public final int considerPossibilities(DropTargetDropEvent event) {
        return this._considerPossibilities(event, event.getLocation(), event.getSourceActions(), event.getDropAction());
    }

    protected void setDropLocation(final DomPosition dropPos) {
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) {
                model.getSelection().setDropLocation(dropPos);
            }
        }.run((AbstractModel)this.getView());
    }

    protected abstract DomPosition getClosestDropPosition(ComponentType var1, Point var2);

    protected void findOtherClosePositions(ComponentType dropComponent, Point location, DomPosition closestPosition, List out) {
    }

    private boolean _doPopupDrop(DropTargetDropEvent dropEvent) {
        int action = this.considerPossibilities(dropEvent);
        if (action == 0) {
            this._cleanupDrop();
            return false;
        }
        this._showPopupMenu(dropEvent);
        return true;
    }

    private void _showPopupMenu(DropTargetDropEvent dropEvent) {
        if (!dropEvent.isLocalTransfer()) {
            _LOGGER.finer("Prefetching before popup drop since it's ! local");
            Transferable nowTrans = dropEvent.getTransferable();
            AugmentableTransferable prefetched = TransferUtils.prefetchTransferableContents((Transferable)nowTrans);
            this._gui.getGuiContext().setDropTransferable((Transferable)prefetched);
            this._processor.setTransferable(this._currentTransferable());
            int action = this.considerPossibilities(dropEvent);
            if (action <= 0) {
                _LOGGER.log(Level.FINER, "Odd, action<=0 after prefetching for popup drop; action was > 0 before! prefetched={0}", prefetched);
            }
        }
        new DropMenuInvoker(dropEvent, (AbstractModel)this.getView(), this._processor, new Runnable(){

            @Override
            public void run() {
                DropHandlerHelper.this._cleanupDrop();
            }
        }).invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _doRegularDrop(DropTargetDropEvent dropEvent) {
        try {
            int dropAction = dropEvent.getDropAction();
            int action = this.considerPossibilities(dropEvent);
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "non-popup drop: proposed action={0} action={1} options={2}", new Object[]{DropHandlerHelper.getActionText(action), DropHandlerHelper.getActionText(dropAction), this._processor});
            }
            if (action <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean showMenu = this._processor.hasMoreThanOneOperationWithHighestRank();
            if (!showMenu) {
                Operation firstOp = (Operation)this._processor.getSupportedOperations().next();
                List dataAndPosList = this._processor.getListOfDataAndPositions(firstOp);
                DataAndPositions firstDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                if (dataAndPosList.size() > 1) {
                    DataAndPositions secondDataAndPos = (DataAndPositions)dataAndPosList.get(0);
                    boolean bl = showMenu = firstDataAndPos.getData().getSuitabilityRank() == secondDataAndPos.getData().getSuitabilityRank();
                }
                if (!showMenu) {
                    boolean dropOK = false;
                    try {
                        dropOK = this._processor.forceSimpleApply(XmlTransferUtils.getTransactionToken((Transferable)this._currentTransferable()));
                    }
                    catch (IOException e) {
                        _LOGGER.log(Level.WARNING, "exception in drop", e);
                    }
                    catch (XmlCommitException e) {
                        _LOGGER.log(Level.WARNING, "exception in drop", e);
                    }
                }
            }
            if (showMenu) {
                this._showPopupMenu(dropEvent);
            }
        }
        finally {
            this._cleanupDrop();
        }
        return true;
    }

    public static String getActionText(int dropAction) {
        if (dropAction == 1) {
            return "COPY";
        }
        if (dropAction == 2) {
            return "MOVE";
        }
        if (dropAction == 0x40000000) {
            return "LINK";
        }
        if (dropAction == 0) {
            return "NONE";
        }
        return "?" + dropAction + "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _considerPossibilities(DropTargetEvent event, Point location, int sourceActions, int proposedDropAction) {
        Component dropComponent = event.getDropTargetContext().getComponent();
        this._setCurrentTransferableIfNeeded(event);
        ExtendedTransferable transferable = this._currentTransferable();
        if (this._processor == null) {
            this._processor = new OperationProcessor((AbstractModel)this.getView());
        }
        this._processor.setTransferable(transferable);
        this._processor.setEditable(this._gui.isUserEditable());
        this.getView().acquireReadLock();
        try {
            DomPosition initialPosition = this.getClosestDropPosition(dropComponent, location);
            LinkedList<DomPosition> closePositions = new LinkedList<DomPosition>();
            if (initialPosition != null) {
                closePositions.add(initialPosition);
            }
            this._updateProcessor(proposedDropAction, closePositions);
            DomPosition pos = this._processor.getRepresentativeOperationPosition();
            if (pos == null) {
                this.findOtherClosePositions(dropComponent, location, initialPosition, closePositions);
            }
            if (this._isPopupDrop(event)) {
                this._updateProcessor(-1, closePositions);
                if (this._processor.hasSupportedOperation()) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            int x = this._updateProcessor(proposedDropAction, closePositions);
            if (x > 0) {
                int n = x;
                return n;
            }
            if (this._processor.wasExplicitlyRejected()) {
                int n = 0;
                return n;
            }
            sourceActions &= ~proposedDropAction;
            int[] tries = new int[]{2, 1, 0x40000000};
            for (int i = 0; i < tries.length; ++i) {
                int curTry = tries[i];
                if ((sourceActions & curTry) <= 0 || (x = this._updateProcessor(curTry, closePositions)) <= 0) continue;
                int n = x;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    private int _updateProcessor(int actionMask, List positions) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "UpdateProcessor: positions={0} actionMask={1}", new Object[]{positions, String.valueOf(actionMask)});
        }
        this._processor.setActionMask(actionMask);
        this._processor.update(positions);
        if (this._processor.hasSupportedOperation()) {
            return actionMask;
        }
        return 0;
    }

    private ExtendedTransferable _currentTransferable() {
        return this._gui.getGuiContext().getDropTransferable();
    }

    private void _cleanupDrop() {
        try {
            _CLEAR_DROP_LOCATION_TASK.run((AbstractModel)this.getView());
        }
        finally {
            this._gui.getGuiContext().releaseDropTarget(this._gui);
            this._gui.getGuiContext().setDropTransferable(null);
            this._isPopupDrop = null;
            this._processor = null;
        }
    }

    private void _setCurrentTransferableIfNeeded(DropTargetEvent event) {
        if (this._currentTransferable() == null) {
            this._gui.getGuiContext().setDropTransferable(DndUtils.getTransferable((DropTargetEvent)event));
        }
    }

    private boolean _isPopupDrop(DropTargetEvent dropEvent) {
        if (this._isPopupDrop == null) {
            InputEvent triggerEvent = DndUtils.getTriggerEvent((Transferable)this._currentTransferable());
            if (triggerEvent instanceof MouseEvent) {
                Component dropComponent = dropEvent.getDropTargetContext().getComponent();
                Point dropPoint = DropHandlerHelper.getLocation(dropEvent);
                JPopupMenu dummyMenu = new JPopupMenu();
                MouseEvent convertedTrigger = (MouseEvent)triggerEvent;
                convertedTrigger = new MouseEvent(dropComponent, 502, System.currentTimeMillis(), convertedTrigger.getModifiers(), dropPoint.x, dropPoint.y, convertedTrigger.getClickCount(), convertedTrigger.isPopupTrigger(), convertedTrigger.getButton());
                this._isPopupDrop = dummyMenu.isPopupTrigger(convertedTrigger) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                this._isPopupDrop = Boolean.FALSE;
            }
        }
        return this._isPopupDrop;
    }

    protected static Point getLocation(DropTargetEvent e) {
        if (e instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)e).getLocation();
        }
        if (e instanceof DropTargetDropEvent) {
            return ((DropTargetDropEvent)e).getLocation();
        }
        return null;
    }

    private static class ClearDropLocationTask
    extends NonDomMutationTransactionTask {
        private ClearDropLocationTask() {
        }

        protected void performTask(AbstractModel model) {
            model.getSelection().setDropLocation(null);
        }
    }
}

