/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public abstract class DragGestureIdentifier {
    private static int _DRAG_THRESHOLD;
    private MouseEvent _armingEvent;
    private Listener _listener;
    private MouseInputListener _delegatee;
    private boolean _hasBufferedPressEvent = false;
    private static final MouseInputListener _DEFAULT_DELEGATE;

    public void registerListeners(Component c) {
        c.addMouseListener(this.getMouseInputListener());
        c.addMouseMotionListener(this.getMouseInputListener());
    }

    public MouseInputListener getMouseInputListener() {
        if (this._listener == null) {
            this._listener = new Listener();
        }
        return this._listener;
    }

    public void unregisterListeners(Component c) {
        c.removeMouseListener(this.getMouseInputListener());
        c.removeMouseMotionListener(this.getMouseInputListener());
    }

    public void setDelegatee(MouseInputListener listener) {
        this._delegatee = listener;
    }

    public MouseInputListener getDelegatee() {
        return this._delegatee;
    }

    protected abstract boolean isDragPossible(MouseEvent var1);

    protected abstract void startDrag(MouseEvent var1, MouseEvent var2);

    protected final MouseEvent getArmingEvent() {
        return this._armingEvent;
    }

    private MouseInputListener _getDelegatee() {
        if (this._delegatee != null) {
            return this._delegatee;
        }
        return _DEFAULT_DELEGATE;
    }

    private boolean _isDragPossibleInternal(MouseEvent e) {
        boolean isWindows;
        boolean bl = isWindows = File.separatorChar == '\\';
        if (!isWindows && e.getButton() != 1) {
            return false;
        }
        return this.isDragPossible(e);
    }

    static {
        try {
            _DRAG_THRESHOLD = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception e) {
            _DRAG_THRESHOLD = 5;
        }
        _DEFAULT_DELEGATE = new MouseInputAdapter(){};
    }

    private class Listener
    implements MouseInputListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DragGestureIdentifier.this._getDelegatee().mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DragGestureIdentifier.this._hasBufferedPressEvent = false;
            if (DragGestureIdentifier.this._isDragPossibleInternal(e)) {
                DragGestureIdentifier.this._hasBufferedPressEvent = true;
                DragGestureIdentifier.this._armingEvent = e;
                e.consume();
            } else {
                DragGestureIdentifier.this._getDelegatee().mousePressed(e);
                if (DragGestureIdentifier.this._isDragPossibleInternal(e)) {
                    DragGestureIdentifier.this._armingEvent = e;
                    e.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DragGestureIdentifier.this._hasBufferedPressEvent && DragGestureIdentifier.this._armingEvent != null) {
                MouseEvent me = DragGestureIdentifier.this._armingEvent;
                MouseEvent clone = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
                DragGestureIdentifier.this._getDelegatee().mousePressed(clone);
                DragGestureIdentifier.this._hasBufferedPressEvent = false;
            }
            DragGestureIdentifier.this._armingEvent = null;
            DragGestureIdentifier.this._getDelegatee().mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            DragGestureIdentifier.this._getDelegatee().mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DragGestureIdentifier.this._getDelegatee().mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DragGestureIdentifier.this._armingEvent != null) {
                int dx = Math.abs(e.getX() - DragGestureIdentifier.this._armingEvent.getX());
                int dy = Math.abs(e.getY() - DragGestureIdentifier.this._armingEvent.getY());
                if (dx > _DRAG_THRESHOLD || dy > _DRAG_THRESHOLD) {
                    DragGestureIdentifier.this.startDrag(e, DragGestureIdentifier.this._armingEvent);
                    DragGestureIdentifier.this._armingEvent = null;
                }
            } else {
                DragGestureIdentifier.this._getDelegatee().mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            DragGestureIdentifier.this._getDelegatee().mouseMoved(e);
        }
    }
}

