/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.binding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.binding.BaseDatabindingEditorGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import org.w3c.dom.Node;

public abstract class DatabindingComponentWrapper
extends JPanel {
    public static final String PROPERTY_VALUE = "value";
    private static final String _TOOLTIP = "DATABINDING.TOOLTIP";
    private static final String _TITLE = "DATABINDING.TITLE";
    private boolean _dirty;
    private Object _oldValue;
    private Node _ownerNode;
    private Node _node;
    private XmlKey _key;
    private XmlContext _context;
    private Listener _listener;

    public DatabindingComponentWrapper(Component toWrap) {
        if (toWrap == null) {
            throw new IllegalArgumentException("toWrap must be specified");
        }
        JButton button = new JButton();
        button.setMargin(new Insets(0, 2, 0, 2));
        this._listener = new Listener();
        button.addActionListener(this._listener);
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", toWrap);
        this.add("East", button);
    }

    public Component getWrappedComponent() {
        return this.getComponent(0);
    }

    public void setContext(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        this._context = context;
        this._key = key;
        this._node = node;
        this._ownerNode = ownerNode;
        JButton b = (JButton)this.getComponent(1);
        b.setText(this._getTranslatedString(_TOOLTIP));
    }

    protected abstract Object getValue();

    public abstract void setValue(Object var1);

    protected void valueChanged() {
        Object newValue = this.getValue();
        this.firePropertyChange(PROPERTY_VALUE, this._oldValue, newValue);
        this._oldValue = newValue;
    }

    private String _getTranslatedString(String key) {
        return this._context == null ? "Key not Found" : this._context.getModel().getTranslatedString(key);
    }

    private void _showDialog() {
        GuiXmlContext context = (GuiXmlContext)this._context;
        BaseDatabindingEditorGui gui = (BaseDatabindingEditorGui)context.getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
        PropertyEditor dpe = gui.getDatabindingPropertyEditor(this._context, this._key, this._node, this._ownerNode);
        PropertyEditorContext.setContext((Object)dpe, (XmlContext)this._context, (XmlKey)this._key, (Node)this._node, (Node)this._ownerNode);
        dpe.setValue(this.getValue());
        JEWTDialog dialog = JEWTDialog.createDialog((Component)this, (String)this._getTranslatedString(_TITLE), (int)7);
        dialog.setContent(dpe.getCustomEditor());
        this._dirty = false;
        dpe.addPropertyChangeListener(this._listener);
        if (dialog.runDialog() && this._dirty) {
            this.setValue(dpe.getValue());
        }
        dpe.removePropertyChangeListener(this._listener);
    }

    private class Listener
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabindingComponentWrapper.this._showDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            DatabindingComponentWrapper.this._dirty = true;
        }
    }
}

