/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import oracle.bali.xml.gui.swing.action.ConvertAction;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.Convertible;
import oracle.bali.xml.util.ContextualActionProvider2;
import org.w3c.dom.Node;

public class ConvertContextualActionProvider
extends ContextualActionProvider2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getContextualActions(ContextualActionProvider2.Param param) {
        XmlContext context = param.getContext();
        Node node = param.getNode();
        if (node == null) {
            return Collections.emptyList();
        }
        XmlModel model = context.getModel();
        model.acquireReadLock();
        try {
            XmlMetadataResolver resolver = context.getModel().getXmlMetadataResolver();
            List plugins = resolver.getConvertPlugins(node);
            HashSet convertibles = new HashSet();
            for (ConvertPlugin plugin : plugins) {
                convertibles.addAll(plugin.getConvertibles(node));
                if (convertibles.size() <= 1) continue;
                List<Action> list = Collections.singletonList(new ConvertAction(context, node));
                return list;
            }
            if (convertibles.size() == 1) {
                List<ConvertAction> list = Collections.singletonList(new ConvertAction(context, node, (Convertible)convertibles.iterator().next()));
                return list;
            }
        }
        finally {
            model.releaseReadLock();
        }
        return Collections.emptyList();
    }
}

