/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.List;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightProvider;

public abstract class AbstractXMLInsightProvider
extends AbstractInsight
implements InsightProvider {
    protected static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final int IN_UNKNOWN = 0;
    protected static final int ELEMENT_NAME = 1;
    protected static final int ELEMENT_LOCAL_NAME = 2;
    protected static final int ATTRIBUTE_NAME = 3;
    protected static final int ATTRIBUTE_LOCAL_NAME = 4;
    protected static final int ATTRIBUTE_VALUE = 5;
    protected static final int ELEMENT_END_TAG = 6;
    protected static final int TEXT = 7;
    private XmlContext _xmlContext = null;
    private DocumentScannerFactory _docScannerFactory = null;
    private InsightParser _insightParser = null;
    private static Logger _sLogger = null;

    protected AbstractXMLInsightProvider(XmlContext xmlContext) {
        this(xmlContext, (DocumentScannerFactory)new DefaultDocumentScannerFactory());
    }

    protected AbstractXMLInsightProvider(XmlContext xmlContext, DocumentScannerFactory docScannerFactory) {
        this._xmlContext = xmlContext;
        this._docScannerFactory = docScannerFactory;
        this._insightParser = new InsightParser(this._docScannerFactory);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
    }

    public XmlContext getXmlContext() {
        return this._xmlContext;
    }

    public DocumentScannerFactory getDocumentScannerFactory() {
        return this._docScannerFactory;
    }

    public GrammarProvider getGrammarProvider() {
        return this._xmlContext.getGrammarProvider();
    }

    public GrammarResolver getGrammarResolver() {
        return this._xmlContext.getGrammarResolver();
    }

    public InsightParser getInsightParser() {
        return this._insightParser;
    }

    protected int getContextType(InsightLocation insightLocation) {
        TextInfo textInfo;
        ElementDeclaration elementDecl = null;
        List elementDecls = insightLocation.getElementDeclarations();
        int size = elementDecls.size();
        if (size > 0) {
            elementDecl = (ElementDeclaration)elementDecls.get(size - 1);
        }
        if (elementDecl != null) {
            int caretPosition = this.getCaretPosition();
            ElementLocator elementLocator = elementDecl.getElementLocator();
            if (this._caretInsideElement((Locator)elementLocator, elementLocator.isStartTagComplete(), caretPosition)) {
                TextBuffer buffer = this.getTextBuffer();
                if (elementDecl.isStartTag()) {
                    if (this._caretInElementInsightPosition((ReadTextBuffer)buffer, elementDecl, elementLocator, caretPosition)) {
                        if (this._caretAfterElementNamespacePrefix((ReadTextBuffer)buffer, elementDecl, elementLocator, caretPosition)) {
                            return 2;
                        }
                        return 1;
                    }
                    ResolvedName attrName = null;
                    AttributeLocator attrLocator = null;
                    AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
                    int attrIndex = InsightUtils.getAttributeAtCaretPosition(attributes, caretPosition);
                    if (attrIndex != -1) {
                        attrName = attributes.getResolvedName(attrIndex);
                        attrLocator = attributes.getLocator(attrIndex);
                    }
                    if (this._caretInAttributeInsightPosition((ReadTextBuffer)buffer, elementDecl, elementLocator, attrName, attrLocator, caretPosition)) {
                        if (this._caretAfterAttrNamespacePrefix((ReadTextBuffer)buffer, attrName, attrLocator, caretPosition)) {
                            return 4;
                        }
                        return 3;
                    }
                    if (this._caretInAttributeValueInsightPosition((ReadTextBuffer)buffer, elementDecl, elementLocator, attrName, attrLocator, caretPosition)) {
                        return 5;
                    }
                } else if (elementDecl.isEndTag() && this._caretInElementEndTagInsightPosition((ReadTextBuffer)buffer, elementDecl, elementLocator, caretPosition)) {
                    return 6;
                }
            }
        }
        if ((textInfo = insightLocation.getCurrentTextInfo()) != null) {
            return 7;
        }
        return 0;
    }

    protected Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger("oracle.bali.xml.editor.insight");
        }
        return _sLogger;
    }

    private boolean _caretInElementInsightPosition(ReadTextBuffer buffer, ElementDeclaration elementDecl, ElementLocator locator, int caretPosition) {
        boolean inPosition = false;
        int startOffset = locator.getStartOffset();
        int endOffset = locator.getEndOffset();
        if (caretPosition > startOffset && caretPosition <= endOffset) {
            inPosition = true;
            for (int currentPosition = caretPosition - 1; currentPosition >= startOffset; --currentPosition) {
                char c = buffer.getChar(currentPosition);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '/': {
                        inPosition = false;
                    }
                }
                if (!inPosition) break;
            }
        }
        return inPosition;
    }

    private boolean _caretInElementEndTagInsightPosition(ReadTextBuffer buffer, ElementDeclaration elementDecl, ElementLocator locator, int caretPosition) {
        boolean inPosition = false;
        int startOffset = locator.getStartOffset();
        int endOffset = locator.getEndOffset();
        if (caretPosition > startOffset + 1 && caretPosition <= endOffset) {
            inPosition = true;
            for (int currentPosition = caretPosition - 1; currentPosition >= startOffset; --currentPosition) {
                char c = buffer.getChar(currentPosition);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        inPosition = false;
                    }
                }
                if (!inPosition) break;
            }
        }
        return inPosition;
    }

    private boolean _caretInAttributeInsightPosition(ReadTextBuffer buffer, ElementDeclaration elementDecl, ElementLocator locator, ResolvedName attributeName, AttributeLocator attrLocator, int caretPosition) {
        boolean inPosition = false;
        int startOffset = locator.getStartOffset();
        int endOffset = locator.getEndOffset();
        if (caretPosition > startOffset && caretPosition <= endOffset) {
            SimpleLocator equalsLocator;
            inPosition = true;
            if (attrLocator != null && (equalsLocator = attrLocator.getEqualsLocator()) != null && caretPosition >= equalsLocator.getEndOffset()) {
                inPosition = false;
            }
        }
        return inPosition;
    }

    private boolean _caretInAttributeValueInsightPosition(ReadTextBuffer buffer, ElementDeclaration elementDecl, ElementLocator locator, ResolvedName attributeName, AttributeLocator attrLocator, int caretPosition) {
        TextLocator valueLocator;
        boolean inPosition = false;
        if (attrLocator != null && (valueLocator = attrLocator.getValueLocator()) != null && caretPosition >= valueLocator.getStartOffset() && caretPosition <= valueLocator.getEndOffset()) {
            inPosition = true;
        }
        return inPosition;
    }

    private boolean _caretAfterElementNamespacePrefix(ReadTextBuffer buffer, ElementDeclaration elementDecl, ElementLocator locator, int caretPosition) {
        boolean afterPrefix = false;
        SimpleLocator nameLocator = locator.getNameLocator();
        if (nameLocator != null) {
            int startOffset = nameLocator.getStartOffset();
            for (int currentPosition = caretPosition - 1; currentPosition >= startOffset; --currentPosition) {
                char c = buffer.getChar(currentPosition);
                if (c != ':') continue;
                afterPrefix = true;
                break;
            }
        }
        return afterPrefix;
    }

    private boolean _caretAfterAttrNamespacePrefix(ReadTextBuffer buffer, ResolvedName attributeName, AttributeLocator attrLocator, int caretPosition) {
        SimpleLocator nameLocator;
        boolean afterPrefix = false;
        if (attrLocator != null && (nameLocator = attrLocator.getNameLocator()) != null) {
            int startOffset = nameLocator.getStartOffset();
            for (int currentPosition = caretPosition - 1; currentPosition >= startOffset; --currentPosition) {
                char c = buffer.getChar(currentPosition);
                if (c != ':') continue;
                afterPrefix = true;
                break;
            }
        }
        return afterPrefix;
    }

    private boolean _caretInsideElement(Locator locator, boolean complete, int caretPosition) {
        if (caretPosition > locator.getStartOffset()) {
            int endOffset = locator.getEndOffset();
            if (complete ? caretPosition < endOffset : caretPosition <= endOffset) {
                return true;
            }
        }
        return false;
    }
}

