/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public class ListenerNameTablePanel
extends JPanel
implements TableModelListener {
    private List<String> _parentNames;
    private boolean _isGlobalShowing;
    private JTable _table;
    private DefaultTableModel _tableModel;
    private JPanel _highlightPanel;
    private Color _origBGColorPanel;

    public ListenerNameTablePanel() {
        this.init(null, null);
    }

    public ListenerNameTablePanel(String string, List<String> list) {
        this.init(string, list);
    }

    private void init(String string, List<String> list) {
        this.setLayout(new GridBagLayout());
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(ListenerArb.getString("COL_NAME"));
        this.setNames(list);
        this._table = new JTable(this._tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JTextPane jTextPane = null;
        if (string != null) {
            jTextPane = new JTextPane();
            jTextPane.setPreferredSize(new Dimension(200, 35));
            jTextPane.setText(string);
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setRequestFocusEnabled(false);
            jTextPane.setFocusable(false);
        }
        this._table.setPreferredScrollableViewportSize(new Dimension(200, 300));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        jButton.setToolTipText(ListenerArb.getString("ADD_PROCEDURE_BUTTON"));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        jButton2.setToolTipText(ListenerArb.getString("REMOVE_PROCEDURE_BUTTON"));
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        this._highlightPanel = new JPanel(new GridBagLayout());
        this._origBGColorPanel = new Color(this._highlightPanel.getBackground().getRGB());
        this._highlightPanel.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._highlightPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(0, 8, 8, 8), 0, 0));
        n = 0;
        if (jTextPane != null) {
            this.add((Component)jTextPane, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 1, new Insets(8, 0, 0, 8), 0, 0));
        }
        this.add((Component)this._highlightPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(8, 8, 8, 8), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ListenerNameTablePanel.this._table.getEditingColumn() > -1 && ListenerNameTablePanel.this._table.getEditingRow() > -1) {
                    ListenerNameTablePanel.this._table.getCellEditor(ListenerNameTablePanel.this._table.getEditingRow(), ListenerNameTablePanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListenerNameTablePanel.this.addRow(null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (ListenerNameTablePanel.this._table.getSelectedRowCount() > 0) {
                    ListenerNameTablePanel.this._tableModel.removeRow(ListenerNameTablePanel.this._table.getSelectedRow());
                }
            }
        });
    }

    private void addRow(String string) {
        this._tableModel.addRow(new Object[]{string});
    }

    private void updateBGColor() {
        String string;
        String string2 = ListenerUIUtils.getCommaDelimited(this._parentNames);
        if (!string2.equals(string = ListenerUIUtils.getCommaDelimited(this.getNames()))) {
            if (this._isGlobalShowing) {
                this._highlightPanel.setBackground(this._origBGColorPanel);
                this._isGlobalShowing = false;
                this.revalidate();
                this.repaint();
            }
        } else if (!this._isGlobalShowing) {
            this._highlightPanel.setBackground(ListenerUIUtils.getHighlightBackgroundColor());
            this._isGlobalShowing = true;
            this.revalidate();
            this.repaint();
        }
    }

    public void setNames(List<String> list) {
        if (list != null) {
            for (String string : list) {
                this.addRow(string);
            }
        }
    }

    public void setParentNames(List<String> list) {
        this._parentNames = list;
        this.updateBGColor();
        this._table.getModel().addTableModelListener(this);
    }

    public List<String> getNames() {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            string = (String)this._table.getModel().getValueAt(i, 0);
            if (string == null || string.isEmpty() || string.trim().isEmpty()) continue;
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    public JTable getTable() {
        return this._table;
    }

    public void removeAllRows() {
        if (this._tableModel != null) {
            if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
                this._table.getCellEditor().stopCellEditing();
            }
            while (this._tableModel.getRowCount() > 0) {
                this._tableModel.removeRow(this._tableModel.getRowCount() - 1);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateBGColor();
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

